/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERNull;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.nist.NISTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.oiw.OIWObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.RSASSAPSSparams;
import cn.tca.TopBasicCrypto.asn1.teletrust.TeleTrusTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x9.X9ObjectIdentifiers;
import cn.tca.TopBasicCrypto.jce.X509Principal;
import cn.tca.TopBasicCrypto.util.Strings;
import cn.topca.security.sm.TopSMProvider;
import cn.topca.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509Util {
    private static Hashtable algorithms;
    private static Hashtable params;
    private static Set noParams;

    X509Util() {
    }

    private static RSASSAPSSparams creatPSSParams(AlgorithmIdentifier algorithmidentifier, int i) {
        return new RSASSAPSSparams(algorithmidentifier, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, algorithmidentifier), new DERInteger(i), new DERInteger(1));
    }

    public static DERObjectIdentifier getAlgorithmOID(String s) {
        if (algorithms.containsKey(s = Strings.toUpperCase(s))) {
            return (DERObjectIdentifier)algorithms.get(s);
        }
        return new DERObjectIdentifier(s);
    }

    public static AlgorithmIdentifier getSigAlgID(DERObjectIdentifier derobjectidentifier, String s) {
        if (noParams.contains(derobjectidentifier)) {
            return new AlgorithmIdentifier(derobjectidentifier);
        }
        if (params.containsKey(s = Strings.toUpperCase(s))) {
            return new AlgorithmIdentifier(derobjectidentifier, (DEREncodable)params.get(s));
        }
        return new AlgorithmIdentifier(derobjectidentifier, new DERNull());
    }

    public static Iterator getAlgNames() {
        Enumeration enumeration = algorithms.keys();
        ArrayList arraylist = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arraylist.add(enumeration.nextElement());
        }
        return arraylist.iterator();
    }

    public static byte[] calculateSignature(DERObjectIdentifier derobjectidentifier, String s, PrivateKey privatekey, SecureRandom securerandom, ASN1Encodable asn1encodable) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (derobjectidentifier == null) {
            throw new IllegalStateException("no signature algorithm specified");
        }
        Signature signature = Signature.getInstance(s);
        if (securerandom != null) {
            signature.initSign(privatekey, securerandom);
        } else {
            signature.initSign(privatekey);
        }
        signature.update(asn1encodable.getEncoded("DER"));
        return signature.sign();
    }

    public static byte[] calculateSignature(DERObjectIdentifier derobjectidentifier, String s, String s1, PrivateKey privatekey, SecureRandom securerandom, ASN1Encodable asn1encodable) throws IOException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (derobjectidentifier == null) {
            throw new IllegalStateException("no signature algorithm specified");
        }
        Signature signature = Signature.getInstance(s, s1);
        if (securerandom != null) {
            signature.initSign(privatekey, securerandom);
        } else {
            signature.initSign(privatekey);
        }
        signature.update(asn1encodable.getEncoded("DER"));
        return signature.sign();
    }

    public static X509Principal convertPrincipal(X500Principal x500principal) {
        try {
            return new X509Principal(x500principal.getEncoded());
        }
        catch (IOException ioexception) {
            throw new IllegalArgumentException("cannot convert principal");
        }
    }

    public static Provider getProvider(String s) throws NoSuchProviderException {
        Provider provider = Security.getProvider(s);
        if (provider == null) {
            throw new NoSuchProviderException("Provider " + s + " not found");
        }
        return provider;
    }

    static {
        Security.addProvider(new TopSMProvider());
        algorithms = new Hashtable();
        params = new Hashtable();
        noParams = new HashSet();
        algorithms.put("SM3", new DERObjectIdentifier(AlgorithmId.SM3_oid.toString()));
        algorithms.put("SM2", new DERObjectIdentifier(AlgorithmId.SM2_oid.toString()));
        algorithms.put("SM3WITHSM2", new DERObjectIdentifier(AlgorithmId.SM3withSM2_oid.toString()));
        algorithms.put("MD2WITHRSAENCRYPTION", PKCSObjectIdentifiers.md2WithRSAEncryption);
        algorithms.put("MD2WITHRSA", PKCSObjectIdentifiers.md2WithRSAEncryption);
        algorithms.put("MD5WITHRSAENCRYPTION", PKCSObjectIdentifiers.md5WithRSAEncryption);
        algorithms.put("MD5WITHRSA", PKCSObjectIdentifiers.md5WithRSAEncryption);
        algorithms.put("SHA1WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha1WithRSAEncryption);
        algorithms.put("SHA1WITHRSA", PKCSObjectIdentifiers.sha1WithRSAEncryption);
        algorithms.put("SHA224WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA224WITHRSA", PKCSObjectIdentifiers.sha224WithRSAEncryption);
        algorithms.put("SHA256WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA256WITHRSA", PKCSObjectIdentifiers.sha256WithRSAEncryption);
        algorithms.put("SHA384WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA384WITHRSA", PKCSObjectIdentifiers.sha384WithRSAEncryption);
        algorithms.put("SHA512WITHRSAENCRYPTION", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("SHA512WITHRSA", PKCSObjectIdentifiers.sha512WithRSAEncryption);
        algorithms.put("SHA1WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA224WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA256WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA384WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("SHA512WITHRSAANDMGF1", PKCSObjectIdentifiers.id_RSASSA_PSS);
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        algorithms.put("RIPEMD160WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd160);
        algorithms.put("RIPEMD128WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        algorithms.put("RIPEMD128WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd128);
        algorithms.put("RIPEMD256WITHRSAENCRYPTION", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        algorithms.put("RIPEMD256WITHRSA", TeleTrusTObjectIdentifiers.rsaSignatureWithripemd256);
        algorithms.put("SHA1WITHDSA", X9ObjectIdentifiers.id_dsa_with_sha1);
        algorithms.put("DSAWITHSHA1", X9ObjectIdentifiers.id_dsa_with_sha1);
        algorithms.put("SHA224WITHDSA", NISTObjectIdentifiers.dsa_with_sha224);
        algorithms.put("SHA256WITHDSA", NISTObjectIdentifiers.dsa_with_sha256);
        algorithms.put("SHA384WITHDSA", NISTObjectIdentifiers.dsa_with_sha384);
        algorithms.put("SHA512WITHDSA", NISTObjectIdentifiers.dsa_with_sha512);
        algorithms.put("SHA1WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA1);
        algorithms.put("ECDSAWITHSHA1", X9ObjectIdentifiers.ecdsa_with_SHA1);
        algorithms.put("SHA224WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA224);
        algorithms.put("SHA256WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA256);
        algorithms.put("SHA384WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA384);
        algorithms.put("SHA512WITHECDSA", X9ObjectIdentifiers.ecdsa_with_SHA512);
        algorithms.put("GOST3411WITHGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        algorithms.put("GOST3411WITHGOST3410-94", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        algorithms.put("GOST3411WITHECGOST3410", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("GOST3411WITHECGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        algorithms.put("GOST3411WITHGOST3410-2001", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA1);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA224);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA256);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA384);
        noParams.add(X9ObjectIdentifiers.ecdsa_with_SHA512);
        noParams.add(X9ObjectIdentifiers.id_dsa_with_sha1);
        noParams.add(NISTObjectIdentifiers.dsa_with_sha224);
        noParams.add(NISTObjectIdentifiers.dsa_with_sha256);
        noParams.add(NISTObjectIdentifiers.dsa_with_sha384);
        noParams.add(NISTObjectIdentifiers.dsa_with_sha512);
        noParams.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_94);
        noParams.add(CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001);
        AlgorithmIdentifier algorithmidentifier = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, new DERNull());
        params.put("SHA1WITHRSAANDMGF1", X509Util.creatPSSParams(algorithmidentifier, 20));
        AlgorithmIdentifier algorithmidentifier1 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha224, new DERNull());
        params.put("SHA224WITHRSAANDMGF1", X509Util.creatPSSParams(algorithmidentifier1, 28));
        AlgorithmIdentifier algorithmidentifier2 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, new DERNull());
        params.put("SHA256WITHRSAANDMGF1", X509Util.creatPSSParams(algorithmidentifier2, 32));
        AlgorithmIdentifier algorithmidentifier3 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha384, new DERNull());
        params.put("SHA384WITHRSAANDMGF1", X509Util.creatPSSParams(algorithmidentifier3, 48));
        AlgorithmIdentifier algorithmidentifier4 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha512, new DERNull());
        params.put("SHA512WITHRSAANDMGF1", X509Util.creatPSSParams(algorithmidentifier4, 64));
    }
}

