/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.pkcs;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.kisa.KISAObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.nist.NISTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.ntt.NTTObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.x9.X9ObjectIdentifiers;
import cn.tca.TopBasicCrypto.cms.CMSAttributeTableGenerator;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedData;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSProcessableByteArray;
import cn.tca.TopBasicCrypto.cms.jcajce.JceCMSContentEncryptorBuilder;
import cn.tca.TopBasicCrypto.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.tca.TopBasicCrypto.operator.OutputEncryptor;
import com.itrus.cms.SM4OutputEncryptor;
import com.itrus.cms.jcajce.SM2RecipientInfoGenerator;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class CMSEnvelopedDataGenerator {
    private cn.tca.TopBasicCrypto.cms.CMSEnvelopedDataGenerator envelopedDataGenerator = new cn.tca.TopBasicCrypto.cms.CMSEnvelopedDataGenerator();
    public boolean bChina = false;
    public static final String SM4 = "1.2.156.10197.1.104";
    public static final String DES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC.getId();
    public static final String RC2_CBC = PKCSObjectIdentifiers.RC2_CBC.getId();
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = NISTObjectIdentifiers.id_aes128_CBC.getId();
    public static final String AES192_CBC = NISTObjectIdentifiers.id_aes192_CBC.getId();
    public static final String AES256_CBC = NISTObjectIdentifiers.id_aes256_CBC.getId();
    public static final String CAMELLIA128_CBC = NTTObjectIdentifiers.id_camellia128_cbc.getId();
    public static final String CAMELLIA192_CBC = NTTObjectIdentifiers.id_camellia192_cbc.getId();
    public static final String CAMELLIA256_CBC = NTTObjectIdentifiers.id_camellia256_cbc.getId();
    public static final String SEED_CBC = KISAObjectIdentifiers.id_seedCBC.getId();
    public static final String DES_EDE3_WRAP = PKCSObjectIdentifiers.id_alg_CMS3DESwrap.getId();
    public static final String AES128_WRAP = NISTObjectIdentifiers.id_aes128_wrap.getId();
    public static final String AES192_WRAP = NISTObjectIdentifiers.id_aes192_wrap.getId();
    public static final String AES256_WRAP = NISTObjectIdentifiers.id_aes256_wrap.getId();
    public static final String CAMELLIA128_WRAP = NTTObjectIdentifiers.id_camellia128_wrap.getId();
    public static final String CAMELLIA192_WRAP = NTTObjectIdentifiers.id_camellia192_wrap.getId();
    public static final String CAMELLIA256_WRAP = NTTObjectIdentifiers.id_camellia256_wrap.getId();
    public static final String SEED_WRAP = KISAObjectIdentifiers.id_npki_app_cmsSeed_wrap.getId();
    public static final String ECDH_SHA1KDF = X9ObjectIdentifiers.dhSinglePass_stdDH_sha1kdf_scheme.getId();
    public static final String ECMQV_SHA1KDF = X9ObjectIdentifiers.mqvSinglePass_sha1kdf_scheme.getId();

    public void addRecipientCert(X509Certificate recipientCert) throws CertificateEncodingException, OperatorCreationException {
        if ("SM2".equalsIgnoreCase(recipientCert.getPublicKey().getAlgorithm())) {
            this.envelopedDataGenerator.addRecipientInfoGenerator(new SM2RecipientInfoGenerator(recipientCert));
        } else {
            this.envelopedDataGenerator.addRecipientInfoGenerator(new JceKeyTransRecipientInfoGenerator(recipientCert).setProvider("BC"));
        }
    }

    public void setUnprotectedAttributeGenerator(CMSAttributeTableGenerator cmsattributetablegenerator) {
        this.envelopedDataGenerator.setUnprotectedAttributeGenerator(cmsattributetablegenerator);
    }

    public CMSEnvelopedData generate(byte[] originalData, String contentEncryptionAlgorithm) throws CMSException, CertificateEncodingException, OperatorCreationException {
        CMSProcessableByteArray typedData = new CMSProcessableByteArray(originalData);
        OutputEncryptor outputEncryptor = SM4.equalsIgnoreCase(contentEncryptionAlgorithm) ? new SM4OutputEncryptor() : new JceCMSContentEncryptorBuilder(new ASN1ObjectIdentifier(contentEncryptionAlgorithm)).setProvider("BC").build();
        CMSEnvelopedData envelopedData = this.envelopedDataGenerator.generate(typedData, outputEncryptor);
        if (this.bChina) {
            ASN1ObjectIdentifier envelopedDataIdentifier = new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.3");
            ContentInfo contentinfo = new ContentInfo(envelopedDataIdentifier, envelopedData.getContentInfo().getContent());
            envelopedData = new CMSEnvelopedData(contentinfo);
        }
        return envelopedData;
    }
}

