/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.pkcs;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Set;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.pkcs.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.pkcs.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.pkcs.SignedData;
import cn.tca.TopBasicCrypto.asn1.pkcs.SignerInfo;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.TBSCertList;
import cn.tca.TopBasicCrypto.asn1.x509.X509CertificateStructure;
import cn.tca.TopBasicCrypto.jce.X509Principal;
import cn.topca.security.sm.TopSMProvider;
import com.itrus.security.cert.X509Certificate;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PKCS7 {
    private byte[] originalData = null;
    private Collection certs = new ArrayList();
    private Collection crls = new ArrayList();
    private Collection signers = new ArrayList();
    private Collection digestAlg = new ArrayList();

    public PKCS7(byte[] pkcs7) {
        try {
            ASN1InputStream din = new ASN1InputStream(pkcs7);
            DERObject pkcs = din.readObject();
            ContentInfo content = ContentInfo.getInstance(pkcs);
            content.getContentType();
            SignedData data = SignedData.getInstance(content.getContent());
            ASN1Set set1 = data.getDigestAlgorithms();
            for (int i = 0; set1 != null && i < set1.size(); ++i) {
                AlgorithmIdentifier algId = AlgorithmIdentifier.getInstance(set1.getObjectAt(i));
                this.digestAlg.add(algId);
            }
            ASN1Set set2 = data.getCertificates();
            for (int i = 0; set2 != null && i < set2.size(); ++i) {
                X509CertificateStructure x509 = X509CertificateStructure.getInstance(set2.getObjectAt(i));
                this.certs.add(new X509Certificate(x509));
            }
            ASN1Set set3 = data.getCRLs();
            for (int i = 0; set3 != null && i < set3.size(); ++i) {
                TBSCertList crl = TBSCertList.getInstance(set3.getObjectAt(i));
                this.crls.add(crl);
            }
            ASN1Set set4 = data.getSignerInfos();
            for (int i = 0; set4 != null && i < set4.size(); ++i) {
                SignerInfo signer = SignerInfo.getInstance(set4.getObjectAt(i));
                this.signers.add(signer);
            }
            ContentInfo contentInfo = data.getContentInfo();
            DEREncodable dEREncodable = contentInfo.getContent();
            if (dEREncodable != null) {
                DEROctetString dEROctetString = (DEROctetString)dEREncodable;
                this.originalData = dEROctetString.getOctets();
            }
        }
        catch (Exception e) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
    }

    public X509Certificate verify(byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        X509Certificate signCert = null;
        for (SignerInfo signerInfo : this.signers) {
            signCert = this.getSignCert(signerInfo);
            if (signCert == null) {
                throw new SecurityException("Can't find signing certificate!");
            }
            String digestAlgorithm = signerInfo.getDigestAlgorithm().getObjectId().getId();
            String digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getObjectId().getId();
            String signAlgorithmName = this.getSignAlgorithm(digestAlgorithm, digestEncryptionAlgorithm);
            byte[] encryptedDigest = signerInfo.getEncryptedDigest().getOctets();
            Signature signature = Signature.getInstance(signAlgorithmName);
            signature.initVerify(signCert.getPublicKey());
            if (this.originalData != null) {
                signature.update(this.originalData);
            } else if (data != null) {
                signature.update(data);
            } else {
                throw new SecurityException("No original data found!");
            }
            if (signature.verify(encryptedDigest)) continue;
            return null;
        }
        return signCert;
    }

    public X509Certificate getSignCert(SignerInfo signerInfo) {
        X509Certificate signCert = null;
        IssuerAndSerialNumber isAnds = signerInfo.getIssuerAndSerialNumber();
        BigInteger serialNumber = isAnds.getCertificateSerialNumber().getValue();
        X509Principal issuer = new X509Principal(isAnds.getName());
        for (X509Certificate cert : this.certs) {
            if (!cert.getSerialNumber().equals(serialNumber) || !cert.getIssuerDN().equals(issuer)) continue;
            signCert = cert;
            break;
        }
        return signCert;
    }

    private String getSignAlgorithm(String digestAlgorithm, String digestEncryptionAlgorithm) {
        String da = digestAlgorithm;
        String dea = digestEncryptionAlgorithm;
        if (digestAlgorithm.equals("1.2.840.113549.2.5")) {
            da = "MD5";
        } else if (digestAlgorithm.equals("1.2.840.113549.2.2")) {
            da = "MD2";
        } else if (digestAlgorithm.equals("1.3.14.3.2.26")) {
            da = "SHA1";
        } else if (digestAlgorithm.equals("1.2.156.10197.1.401")) {
            da = "SM3";
        } else if (digestAlgorithm.equals("1.2.156.10197.1.401.1")) {
            da = "SM3";
        } else if (digestAlgorithm.equals("1.2.156.10197.1.401.2")) {
            da = "SM3";
        }
        if (digestEncryptionAlgorithm.equals("1.2.840.113549.1.1.1")) {
            dea = "RSA";
        } else if (digestEncryptionAlgorithm.equals("1.2.840.10040.4.1")) {
            dea = "DSA";
        } else if (digestEncryptionAlgorithm.equals("1.2.156.10197.1.301")) {
            dea = "SM2";
        }
        return da + "with" + dea;
    }

    public X509Certificate getSignCert(int i) {
        X509Certificate cert = null;
        Iterator it = this.certs.iterator();
        int cur = 0;
        while (it.hasNext()) {
            cert = (X509Certificate)it.next();
            if (cur == i) break;
            ++cur;
        }
        return cert;
    }

    public int getSignCertSize() {
        return this.certs.size();
    }

    public SignerInfo getSignerInfo(int i) {
        SignerInfo signer = null;
        Iterator it = this.signers.iterator();
        int cur = 0;
        while (it.hasNext()) {
            signer = (SignerInfo)it.next();
            if (cur == i) break;
            ++cur;
        }
        return signer;
    }

    public int getSignInfoSize() {
        return this.signers.size();
    }

    public byte[] getContent() {
        return this.originalData == null ? null : (byte[])this.originalData.clone();
    }

    public boolean isDetached() {
        return this.originalData == null;
    }

    static {
        Security.addProvider(new TopSMProvider());
    }
}

