/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.pkcs;

import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1Set;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERNull;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.DEROutputStream;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.DERSet;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import cn.tca.TopBasicCrypto.asn1.pkcs.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.pkcs.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.SignedData;
import cn.tca.TopBasicCrypto.asn1.pkcs.SignerInfo;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.CertificateList;
import cn.tca.TopBasicCrypto.asn1.x509.X509CertificateStructure;
import cn.tca.TopBasicCrypto.asn1.x509.X509Name;
import cn.tca.TopBasicCrypto.jce.X509Principal;
import cn.tca.TopBasicCrypto.jce.provider.X509CRLObject;
import cn.tca.TopBasicCrypto.jce.provider.X509CertificateObject;
import cn.topca.security.sm.TopSMProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PKCS7SignedData
implements PKCSObjectIdentifiers {
    private int version;
    private int signerversion;
    private Set digestalgos;
    private Collection certs;
    private Collection crls;
    private X509Certificate signCert;
    private byte[] digest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private Signature sig;
    private transient PrivateKey privKey;
    private final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private final String ID_MD5 = "1.2.840.113549.2.5";
    private final String ID_MD2 = "1.2.840.113549.2.2";
    private final String ID_SHA1 = "1.3.14.3.2.26";
    private final String ID_RSA = "1.2.840.113549.1.1.1";
    private final String ID_DSA = "1.2.840.10040.4.1";

    public PKCS7SignedData(byte[] abyte0) throws SecurityException, CRLException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(abyte0, null);
    }

    public PKCS7SignedData(byte[] abyte0, String s) throws SecurityException, CRLException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        DERObject derobject;
        ASN1InputStream asn1inputstream = new ASN1InputStream(new ByteArrayInputStream(abyte0));
        try {
            derobject = asn1inputstream.readObject();
        }
        catch (IOException ioexception) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(derobject instanceof ASN1Sequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo contentinfo = ContentInfo.getInstance(derobject);
        if (!contentinfo.getContentType().equals(signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + contentinfo.getContentType().getId());
        }
        SignedData signeddata = SignedData.getInstance(contentinfo.getContent());
        this.certs = new ArrayList();
        if (signeddata.getCertificates() != null) {
            Enumeration enumeration = ASN1Set.getInstance(signeddata.getCertificates()).getObjects();
            while (enumeration.hasMoreElements()) {
                try {
                    this.certs.add(new X509CertificateObject(X509CertificateStructure.getInstance(enumeration.nextElement())));
                }
                catch (CertificateParsingException certificateparsingexception) {
                    throw new SecurityException(certificateparsingexception.toString());
                }
            }
        }
        this.crls = new ArrayList();
        if (signeddata.getCRLs() != null) {
            Enumeration enumeration1 = ASN1Set.getInstance(signeddata.getCRLs()).getObjects();
            while (enumeration1.hasMoreElements()) {
                this.crls.add(new X509CRLObject(CertificateList.getInstance(enumeration1.nextElement())));
            }
        }
        this.version = signeddata.getVersion().getValue().intValue();
        this.digestalgos = new HashSet();
        Enumeration enumeration2 = signeddata.getDigestAlgorithms().getObjects();
        while (enumeration2.hasMoreElements()) {
            ASN1Sequence asn1sequence = (ASN1Sequence)enumeration2.nextElement();
            DERObjectIdentifier derobjectidentifier = (DERObjectIdentifier)asn1sequence.getObjectAt(0);
            this.digestalgos.add(derobjectidentifier.getId());
        }
        ASN1Set asn1set = signeddata.getSignerInfos();
        if (asn1set.size() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        SignerInfo signerinfo = SignerInfo.getInstance(asn1set.getObjectAt(0));
        this.signerversion = signerinfo.getVersion().getValue().intValue();
        IssuerAndSerialNumber issuerandserialnumber = signerinfo.getIssuerAndSerialNumber();
        BigInteger biginteger = issuerandserialnumber.getCertificateSerialNumber().getValue();
        X509Principal x509principal = new X509Principal(issuerandserialnumber.getName());
        for (X509Certificate x509certificate : this.certs) {
            if (!biginteger.equals(x509certificate.getSerialNumber()) || !x509principal.equals(x509certificate.getIssuerDN())) continue;
            this.signCert = x509certificate;
            break;
        }
        if (this.signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + biginteger.toString(16));
        }
        this.digestAlgorithm = signerinfo.getDigestAlgorithm().getObjectId().getId();
        this.digest = signerinfo.getEncryptedDigest().getOctets();
        this.digestEncryptionAlgorithm = signerinfo.getDigestEncryptionAlgorithm().getObjectId().getId();
        this.sig = s != null ? Signature.getInstance(this.getDigestAlgorithm(), s) : Signature.getInstance(this.getDigestAlgorithm());
        this.sig.initVerify(this.signCert.getPublicKey());
    }

    public PKCS7SignedData(PrivateKey privatekey, Certificate[] acertificate, String s) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privatekey, acertificate, s, null);
    }

    public PKCS7SignedData(PrivateKey privatekey, Certificate[] acertificate, String s, String s1) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privatekey, acertificate, null, s, s1);
    }

    public PKCS7SignedData(PrivateKey privatekey, Certificate[] acertificate, CRL[] acrl, String s, String s1) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.privKey = privatekey;
        if (s.equals("MD5")) {
            this.digestAlgorithm = "1.2.840.113549.2.5";
        } else if (s.equals("MD2")) {
            this.digestAlgorithm = "1.2.840.113549.2.2";
        } else if (s.equals("SHA")) {
            this.digestAlgorithm = "1.3.14.3.2.26";
        } else if (s.equals("SHA1")) {
            this.digestAlgorithm = "1.3.14.3.2.26";
        } else if (s.equals("SM3")) {
            this.digestAlgorithm = "1.2.156.10197.1.401";
        } else {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + s);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)acertificate[0];
        for (int i = 0; i < acertificate.length; ++i) {
            this.certs.add(acertificate[i]);
        }
        if (acrl != null) {
            for (int j = 0; j < acrl.length; ++j) {
                this.crls.add(acrl[j]);
            }
        }
        this.digestEncryptionAlgorithm = privatekey.getAlgorithm();
        if (this.digestEncryptionAlgorithm.equals("RSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.113549.1.1.1";
        } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.10040.4.1";
        } else if (this.digestEncryptionAlgorithm.equals("SM2")) {
            this.digestEncryptionAlgorithm = "1.2.156.10197.1.301";
        } else {
            throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
        }
        this.sig = s1 != null ? Signature.getInstance(this.getDigestAlgorithm(), s1) : Signature.getInstance(this.getDigestAlgorithm());
        this.sig.initSign(privatekey);
    }

    public String getDigestAlgorithm() {
        String s = this.digestAlgorithm;
        String s1 = this.digestEncryptionAlgorithm;
        if (this.digestAlgorithm.equals("1.2.840.113549.2.5")) {
            s = "MD5";
        } else if (this.digestAlgorithm.equals("1.2.840.113549.2.2")) {
            s = "MD2";
        } else if (this.digestAlgorithm.equals("1.3.14.3.2.26")) {
            s = "SHA1";
        } else if (this.digestAlgorithm.equals("1.2.156.10197.1.401")) {
            s = "SM3";
        }
        if (this.digestEncryptionAlgorithm.equals("1.2.840.113549.1.1.1")) {
            s1 = "RSA";
        } else if (this.digestEncryptionAlgorithm.equals("1.2.840.10040.4.1")) {
            s1 = "DSA";
        } else if (this.digestEncryptionAlgorithm.equals("1.2.156.10197.1.301")) {
            s1 = "SM2";
        }
        return s + "with" + s1;
    }

    public void reset() {
        try {
            if (this.privKey == null) {
                this.sig.initVerify(this.signCert.getPublicKey());
            } else {
                this.sig.initSign(this.privKey);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public void update(byte byte0) throws SignatureException {
        this.sig.update(byte0);
    }

    public void update(byte[] abyte0, int i, int j) throws SignatureException {
        this.sig.update(abyte0, i, j);
    }

    public boolean verify() throws SignatureException {
        return this.sig.verify(this.digest);
    }

    private DERObject getIssuer(byte[] abyte0) {
        try {
            ASN1InputStream asn1inputstream = new ASN1InputStream(new ByteArrayInputStream(abyte0));
            ASN1Sequence asn1sequence = (ASN1Sequence)asn1inputstream.readObject();
            return (DERObject)asn1sequence.getObjectAt(asn1sequence.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException ioexception) {
            throw new Error("IOException reading from ByteArray: " + ioexception);
        }
    }

    public byte[] getEncoded() {
        try {
            this.digest = this.sig.sign();
            ASN1EncodableVector asn1encodablevector = new ASN1EncodableVector();
            Iterator iterator = this.digestalgos.iterator();
            while (iterator.hasNext()) {
                AlgorithmIdentifier algorithmidentifier = new AlgorithmIdentifier(new DERObjectIdentifier((String)iterator.next()), null);
                asn1encodablevector.add(algorithmidentifier);
            }
            DERSet derset = new DERSet(asn1encodablevector);
            DERSequence dersequence = new DERSequence(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            asn1encodablevector = new ASN1EncodableVector();
            Iterator iterator1 = this.certs.iterator();
            while (iterator1.hasNext()) {
                ASN1InputStream asn1inputstream = new ASN1InputStream(new ByteArrayInputStream(((X509Certificate)iterator1.next()).getEncoded()));
                asn1encodablevector.add(asn1inputstream.readObject());
            }
            DERSet derset1 = new DERSet(asn1encodablevector);
            ASN1EncodableVector asn1encodablevector2 = new ASN1EncodableVector();
            asn1encodablevector2.add(new DERInteger(this.signerversion));
            IssuerAndSerialNumber issuerandserialnumber = new IssuerAndSerialNumber(new X509Name((ASN1Sequence)this.getIssuer(this.signCert.getTBSCertificate())), new DERInteger(this.signCert.getSerialNumber()));
            asn1encodablevector2.add(issuerandserialnumber);
            asn1encodablevector2.add(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), new DERNull()));
            asn1encodablevector2.add(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), new DERNull()));
            asn1encodablevector2.add(new DEROctetString(this.digest));
            ASN1EncodableVector asn1encodablevector3 = new ASN1EncodableVector();
            asn1encodablevector3.add(new DERInteger(this.version));
            asn1encodablevector3.add(derset);
            asn1encodablevector3.add(dersequence);
            asn1encodablevector3.add(new DERTaggedObject(false, 0, derset1));
            if (this.crls.size() > 0) {
                ASN1EncodableVector asn1encodablevector1 = new ASN1EncodableVector();
                Iterator iterator2 = this.crls.iterator();
                while (iterator2.hasNext()) {
                    ASN1InputStream asn1inputstream1 = new ASN1InputStream(new ByteArrayInputStream(((X509CRL)iterator2.next()).getEncoded()));
                    asn1encodablevector1.add(asn1inputstream1.readObject());
                }
                DERSet derset2 = new DERSet(asn1encodablevector1);
                asn1encodablevector3.add(new DERTaggedObject(false, 1, derset2));
            }
            asn1encodablevector3.add(new DERSet(new DERSequence(asn1encodablevector2)));
            ASN1EncodableVector asn1encodablevector4 = new ASN1EncodableVector();
            asn1encodablevector4.add(new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            asn1encodablevector4.add(new DERTaggedObject(0, new DERSequence(asn1encodablevector3)));
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            DEROutputStream deroutputstream = new DEROutputStream(bytearrayoutputstream);
            deroutputstream.writeObject(new DERSequence(asn1encodablevector4));
            deroutputstream.close();
            return bytearrayoutputstream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.toString());
        }
    }

    static {
        Security.addProvider(new TopSMProvider());
    }
}

