/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.security.x509.extension.logotype;

import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DigestInfo;

public class LogotypeDetails
extends ASN1Encodable {
    DERIA5String mediaType = null;
    ASN1Sequence logotypeHash = null;
    ASN1Sequence logotypeURI = null;

    public static LogotypeDetails getInstance(ASN1TaggedObject obj, boolean explicit) {
        return LogotypeDetails.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static LogotypeDetails getInstance(Object obj) {
        if (obj instanceof LogotypeDetails) {
            return (LogotypeDetails)((Object)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new LogotypeDetails((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public LogotypeDetails(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("size of sequence must be 3 not " + seq.size());
        }
        this.mediaType = DERIA5String.getInstance((Object)seq.getObjectAt(0));
        this.logotypeHash = ASN1Sequence.getInstance((Object)seq.getObjectAt(1));
        this.logotypeURI = ASN1Sequence.getInstance((Object)seq.getObjectAt(2));
    }

    public LogotypeDetails(String mediaType, DigestInfo[] logotypeHash, String[] logotypeURI) {
        this.mediaType = new DERIA5String(mediaType);
        this.logotypeHash = new DERSequence((ASN1Encodable[])logotypeHash);
        ASN1EncodableVector v = new ASN1EncodableVector();
        int i = 0;
        while (i < logotypeURI.length) {
            v.add((DEREncodable)new DERIA5String(logotypeURI[i]));
            ++i;
        }
        this.logotypeURI = new DERSequence(v);
    }

    public String getMediaType() {
        return this.mediaType.getString();
    }

    public DigestInfo[] getLogotypeHash() {
        Vector<DigestInfo> v = new Vector<DigestInfo>();
        int i = 0;
        while (i < this.logotypeHash.size()) {
            v.add(DigestInfo.getInstance((Object)this.logotypeHash.getObjectAt(i)));
            ++i;
        }
        DigestInfo[] infos = v.toArray(new DigestInfo[this.logotypeHash.size()]);
        return infos;
    }

    public String[] getLogotypeURI() {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < this.logotypeURI.size()) {
            v.add(DERIA5String.getInstance((Object)this.logotypeURI.getObjectAt(i)).getString());
            ++i;
        }
        String[] infos = v.toArray(new String[this.logotypeURI.size()]);
        return infos;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.mediaType);
        v.add((DEREncodable)this.logotypeHash);
        v.add((DEREncodable)this.logotypeURI);
        return new DERSequence(v);
    }
}

