/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import com.itrus.util.InvalidIntegerByteArrayException;
import com.itrus.util.InvalidLongByteArrayException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.ProviderException;

public class DataUtil {
    private static final char[] hexDigits = "0123456789ABCDEF".toCharArray();

    public static int bytes2int(byte[] b) {
        if (b.length > 4) {
            throw new InvalidIntegerByteArrayException();
        }
        int mask = 255;
        int temp = 0;
        int res = 0;
        int i = 0;
        while (i < 4 - b.length) {
            res <<= 8;
            res |= 0;
            ++i;
        }
        i = 0;
        while (i < b.length) {
            res <<= 8;
            temp = b[i] & mask;
            res |= temp;
            ++i;
        }
        return res;
    }

    public static byte[] int2bytes(int num) {
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            b[i] = (byte)(num >>> 24 - i * 8);
            ++i;
        }
        return b;
    }

    public static long bytes2long(byte[] b) {
        if (b.length > 8) {
            throw new InvalidLongByteArrayException();
        }
        int mask = 255;
        int temp = 0;
        long res = 0L;
        int i = 0;
        while (i < 8 - b.length) {
            res <<= 8;
            res |= 0L;
            ++i;
        }
        i = 0;
        while (i < b.length) {
            res <<= 8;
            temp = b[i] & mask;
            res |= (long)temp;
            ++i;
        }
        return res;
    }

    public static byte[] long2bytes(long num) {
        byte[] b = new byte[8];
        int i = 0;
        while (i < 8) {
            b[i] = (byte)(num >>> 56 - i * 8);
            ++i;
        }
        return b;
    }

    public static String toFirstUpperCase(String str) {
        char[] ch = str.toCharArray();
        ch[0] = Character.toUpperCase(ch[0]);
        return new String(ch);
    }

    public static String transformByteArrayToHexString(byte[] data, boolean format) {
        if (data == null) {
            return "(null)";
        }
        StringBuffer sb = new StringBuffer(data.length * 3);
        int i = 0;
        while (i < data.length) {
            int k = data[i] & 0xFF;
            if (i != 0 && format) {
                sb.append(' ');
            }
            sb.append(hexDigits[k >>> 4]);
            sb.append(hexDigits[k & 0xF]);
            ++i;
        }
        return sb.toString();
    }

    public static String transformByteArrayToHexString(byte[] data) {
        return DataUtil.transformByteArrayToHexString(data, false);
    }

    public static byte[] transformHexStringToByteArray(String s) {
        char c = (s = (s = s.replaceAll("[^0-9|^a-f|^A-F]", "")).length() % 2 == 1 ? "0" + s.toUpperCase() : s.toUpperCase()).charAt(0);
        if (c == '8' || c == '9' || c == 'A' || c == 'B' || c == 'C' || c == 'D' || c == 'E' || c == 'F') {
            s = "00" + s;
        }
        byte[] b1 = s.getBytes();
        byte[] b2 = new byte[b1.length / 2];
        int j = 0;
        int i = 0;
        while (i < b1.length) {
            int a = 0;
            int b = 0;
            if (b1[i] >= 48 && b1[i] <= 57) {
                a = b1[i] - 48;
            } else if (b1[i] >= 65 && b1[i] <= 70) {
                a = b1[i] - 55;
            }
            if (b1[i + 1] >= 48 && b1[i + 1] <= 57) {
                b = b1[i + 1] - 48;
            } else if (b1[i + 1] >= 65 && b1[i + 1] <= 70) {
                b = b1[i + 1] - 55;
            }
            b2[j] = (byte)((a << 4) + b);
            i += 2;
            ++j;
        }
        return b2;
    }

    public static byte[] convert(byte[] input, int offset, int len) {
        if (offset == 0 && len == input.length) {
            return input;
        }
        byte[] t = new byte[len];
        System.arraycopy(input, offset, t, 0, len);
        return t;
    }

    public static byte[] subarray(byte[] b, int ofs, int len) {
        byte[] out = new byte[len];
        System.arraycopy(b, ofs, out, 0, len);
        return out;
    }

    public static byte[] concat(byte[] b1, byte[] b2) {
        byte[] b = new byte[b1.length + b2.length];
        System.arraycopy(b1, 0, b, 0, b1.length);
        System.arraycopy(b2, 0, b, b1.length, b2.length);
        return b;
    }

    public static long[] concat(long[] b1, long[] b2) {
        if (b1.length == 0) {
            return b2;
        }
        long[] b = new long[b1.length + b2.length];
        System.arraycopy(b1, 0, b, 0, b1.length);
        System.arraycopy(b2, 0, b, b1.length, b2.length);
        return b;
    }

    public static byte[] trimZeroes(byte[] b) {
        int i = 0;
        while (i < b.length - 1 && b[i] == 0) {
            ++i;
        }
        if (i == 0) {
            return b;
        }
        byte[] t = new byte[b.length - i];
        System.arraycopy(b, i, t, 0, t.length);
        return t;
    }

    public static byte[] getMagnitude(BigInteger bi) {
        byte[] b = bi.toByteArray();
        if (b.length > 1 && b[0] == 0) {
            int n = b.length - 1;
            byte[] newarray = new byte[n];
            System.arraycopy(b, 1, newarray, 0, n);
            b = newarray;
        }
        return b;
    }

    public static byte[] getBytesUTF8(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] sha1(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(data);
            return md.digest();
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e.getMessage());
        }
    }

    public static byte[] readFully(InputStream is, int length, boolean readAll) throws IOException {
        byte[] output = new byte[]{};
        if (length == -1) {
            length = Integer.MAX_VALUE;
        }
        int pos = 0;
        while (pos < length) {
            int cc;
            int bytesToRead;
            if (pos >= output.length) {
                bytesToRead = Math.min(length - pos, output.length + 1024);
                if (output.length < pos + bytesToRead) {
                    output = DataUtil.copyOf(output, pos + bytesToRead);
                }
            } else {
                bytesToRead = output.length - pos;
            }
            if ((cc = is.read(output, pos, bytesToRead)) < 0) {
                if (readAll && length != Integer.MAX_VALUE) {
                    throw new EOFException("Detect premature EOF");
                }
                if (output.length == pos) break;
                output = DataUtil.copyOf(output, pos);
                break;
            }
            pos += cc;
        }
        return output;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

