/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

public class FileEncodingConverter {
    public static final String FILE_EXTENTION_JAVA = ".java";
    public static final int BUFFER_SIZE = 4096;
    public static final String FILE_ENCODING_UTF8 = "UTF_8";
    public static final String FILE_ENCODING_GBK = "GBK";
    public static final String FILE_ENCODING_GB2312 = "gb2312";
    private static FileFilter fileFilter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || file.isFile() && file.getName().endsWith(FileEncodingConverter.FILE_EXTENTION_JAVA);
        }
    };

    public static void scanDirectory(String sourceDirectoryPath, String destDirectoryPath, String sourceFileEncoding, String destFileEncoding) {
        File destDirectory = new File(destDirectoryPath);
        if (!destDirectory.exists()) {
            destDirectory.mkdir();
        }
        File sourceDirectory = new File(sourceDirectoryPath);
        FileEncodingConverter.scanDirectory(sourceDirectory, sourceDirectoryPath, destDirectoryPath, sourceFileEncoding, destFileEncoding);
    }

    private static void scanDirectory(File directory, String sourceDirectoryPath, String destDirectoryPath, String sourceFileEncoding, String destFileEncoding) {
        File[] files;
        File[] fileArray = files = directory.listFiles(fileFilter);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                File destFile = new File(String.valueOf(destDirectoryPath) + file.getAbsolutePath().substring(sourceDirectoryPath.length()));
                if (!destFile.exists()) {
                    destFile.mkdir();
                }
                FileEncodingConverter.scanDirectory(file, sourceDirectoryPath, destDirectoryPath, sourceFileEncoding, destFileEncoding);
            } else {
                System.out.println("Source file\uff1a\t" + file.getAbsolutePath() + "\nDest file\uff1a\t" + destDirectoryPath + file.getAbsolutePath().substring(sourceDirectoryPath.length()) + "\n-----------------------------------------------------------------");
                FileEncodingConverter.convertFile(file.getAbsolutePath(), String.valueOf(destDirectoryPath) + file.getAbsolutePath().substring(sourceDirectoryPath.length()), sourceFileEncoding, destFileEncoding);
            }
            ++n2;
        }
    }

    private static void convertFile(String sourceFilePath, String destFilePath, String sourceFileEncoding, String destFileEncoding) {
        InputStream in = System.in;
        OutputStream out = System.out;
        Reader reader = null;
        Writer writer = null;
        try {
            try {
                int len;
                if (sourceFilePath != null) {
                    in = new FileInputStream(sourceFilePath);
                }
                if (destFilePath != null) {
                    out = new FileOutputStream(destFilePath);
                }
                if (sourceFileEncoding == null) {
                    sourceFileEncoding = System.getProperty("file.encoding");
                }
                if (destFileEncoding == null) {
                    destFileEncoding = System.getProperty("file.encoding");
                }
                reader = new BufferedReader(new InputStreamReader(in, sourceFileEncoding));
                writer = new BufferedWriter(new OutputStreamWriter(out, destFileEncoding));
                char[] buffer = new char[4096];
                while ((len = reader.read(buffer)) != -1) {
                    writer.write(buffer, 0, len);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (writer != null) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
                try {
                    out.close();
                }
                catch (IOException e5) {
                    e5.printStackTrace();
                }
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String sourceDirectoryPath = "src";
        String destDirectoryPath = "dest";
        FileEncodingConverter.scanDirectory(sourceDirectoryPath, destDirectoryPath, FILE_ENCODING_GBK, FILE_ENCODING_UTF8);
    }
}

