/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NetworkInfo {
    public static final String getMacAddress() throws IOException {
        String os = System.getProperty("os.name");
        try {
            if (os.startsWith("Windows")) {
                return NetworkInfo.parseMacAddress(NetworkInfo.windowsRunIpConfigCommand());
            }
            if (os.startsWith("Linux")) {
                return NetworkInfo.parseMacAddress(NetworkInfo.linuxRunIfConfigCommand());
            }
            throw new IOException("unknown operating system: " + os);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            throw new IOException(ex.getMessage());
        }
    }

    private static final String linuxRunIfConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ifconfig");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }

    private static final String parseMacAddress(String ipConfigResponse) throws ParseException {
        String localHost = null;
        try {
            localHost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            throw new ParseException(ex.getMessage(), 0);
        }
        StringTokenizer tokenizer = new StringTokenizer(ipConfigResponse, "\n");
        String firstMacAddress = null;
        while (tokenizer.hasMoreTokens()) {
            String line = tokenizer.nextToken().trim();
            firstMacAddress = NetworkInfo.getMacAddress(line);
            if (firstMacAddress != null) break;
        }
        if (firstMacAddress == null) {
            throw new ParseException("cannot read MAC address for " + localHost + " from [" + ipConfigResponse + "]", 0);
        }
        return firstMacAddress.replaceAll("[:|-]", "");
    }

    private static final String getMacAddress(String line) {
        String regex = "[0-9|A-F|a-f]{2}([-|:][0-9|A-F|a-f]{2}){5}";
        Pattern p = Pattern.compile(regex);
        Matcher match = p.matcher(line);
        if (match.find()) {
            return match.group();
        }
        return null;
    }

    private static final String windowsRunIpConfigCommand() throws IOException {
        int c;
        Process p = Runtime.getRuntime().exec("ipconfig /all");
        BufferedInputStream stdoutStream = new BufferedInputStream(p.getInputStream());
        StringBuffer buffer = new StringBuffer();
        while ((c = ((InputStream)stdoutStream).read()) != -1) {
            buffer.append((char)c);
        }
        String outputText = buffer.toString();
        ((InputStream)stdoutStream).close();
        return outputText;
    }
}

