/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.asn1;

import cn.tca.TopBasicCrypto.asn1.ASN1Object;
import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.ASN1OutputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DEROutputStream;
import cn.tca.TopBasicCrypto.asn1.DERString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERUniversalString
extends ASN1Object
implements DERString {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private byte[] string;

    public static DERUniversalString getInstance(Object obj) {
        if (obj == null || obj instanceof DERUniversalString) {
            return (DERUniversalString)obj;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERUniversalString getInstance(ASN1TaggedObject obj, boolean explicit) {
        DERObject o = obj.getObject();
        if (explicit || o instanceof DERUniversalString) {
            return DERUniversalString.getInstance(o);
        }
        return new DERUniversalString(((ASN1OctetString)o).getOctets());
    }

    public DERUniversalString(byte[] string) {
        this.string = string;
    }

    public String getString() {
        StringBuffer buf = new StringBuffer("#");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException("internal error encoding BitString");
        }
        byte[] string = bOut.toByteArray();
        for (int i = 0; i != string.length; ++i) {
            buf.append(table[string[i] >>> 4 & 0xF]);
            buf.append(table[string[i] & 0xF]);
        }
        return buf.toString();
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return this.string;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(28, this.getOctets());
    }

    boolean asn1Equals(DERObject o) {
        if (!(o instanceof DERUniversalString)) {
            return false;
        }
        return this.getString().equals(((DERUniversalString)o).getString());
    }

    public int hashCode() {
        return this.getString().hashCode();
    }
}

