/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.asn1.x509;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.DERBitString;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.util.Enumeration;

public class SubjectPublicKeyInfo
extends ASN1Encodable {
    private AlgorithmIdentifier algId;
    private DERBitString keyData;

    public static SubjectPublicKeyInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SubjectPublicKeyInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static SubjectPublicKeyInfo getInstance(Object obj) {
        if (obj instanceof SubjectPublicKeyInfo) {
            return (SubjectPublicKeyInfo)obj;
        }
        if (obj != null) {
            return new SubjectPublicKeyInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algId, DEREncodable publicKey) {
        this.keyData = new DERBitString(publicKey);
        this.algId = algId;
    }

    public SubjectPublicKeyInfo(AlgorithmIdentifier algId, byte[] publicKey) {
        this.keyData = new DERBitString(publicKey);
        this.algId = algId;
    }

    public SubjectPublicKeyInfo(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration e = seq.getObjects();
        this.algId = AlgorithmIdentifier.getInstance(e.nextElement());
        this.keyData = DERBitString.getInstance(e.nextElement());
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public DERObject getPublicKey() throws IOException {
        ASN1InputStream aIn = new ASN1InputStream(this.keyData.getBytes());
        return aIn.readObject();
    }

    public DERBitString getPublicKeyData() {
        return this.keyData;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.algId);
        v.add(this.keyData);
        return new DERSequence(v);
    }
}

