/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cert;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.TBSCertList;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extension;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extensions;
import cn.tca.TopBasicCrypto.cert.CertUtils;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class X509CRLEntryHolder {
    private TBSCertList.CRLEntry entry;
    private X509Extensions extensions;

    X509CRLEntryHolder(TBSCertList.CRLEntry entry) {
        this.entry = entry;
        this.extensions = entry.getExtensions();
    }

    public BigInteger getSerialNumber() {
        return this.entry.getUserCertificate().getValue();
    }

    public Date getRevocationDate() {
        return this.entry.getRevocationDate().getDate();
    }

    public boolean hasExtensions() {
        return this.extensions != null;
    }

    public X509Extension getExtension(ASN1ObjectIdentifier oid) {
        if (this.extensions != null) {
            return this.extensions.getExtension(oid);
        }
        return null;
    }

    public List getExtensionOIDs() {
        return CertUtils.getExtensionOIDs(this.extensions);
    }

    public Set getCriticalExtensionOIDs() {
        return CertUtils.getCriticalExtensionOIDs(this.extensions);
    }

    public Set getNonCriticalExtensionOIDs() {
        return CertUtils.getNonCriticalExtensionOIDs(this.extensions);
    }
}

