/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cert.crmf;

import cn.tca.TopBasicCrypto.asn1.cms.EnvelopedData;
import cn.tca.TopBasicCrypto.asn1.crmf.CRMFObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.crmf.EncKeyWithID;
import cn.tca.TopBasicCrypto.asn1.crmf.EncryptedKey;
import cn.tca.TopBasicCrypto.asn1.crmf.PKIArchiveOptions;
import cn.tca.TopBasicCrypto.asn1.pkcs.PrivateKeyInfo;
import cn.tca.TopBasicCrypto.asn1.x509.GeneralName;
import cn.tca.TopBasicCrypto.cert.crmf.PKIArchiveControl;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedData;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedDataGenerator;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSProcessableByteArray;
import cn.tca.TopBasicCrypto.cms.RecipientInfoGenerator;
import cn.tca.TopBasicCrypto.operator.OutputEncryptor;
import java.io.IOException;

public class PKIArchiveControlBuilder {
    private CMSEnvelopedDataGenerator envGen;
    private CMSProcessableByteArray keyContent;

    public PKIArchiveControlBuilder(PrivateKeyInfo privateKeyInfo, GeneralName generalName) {
        EncKeyWithID encKeyWithID = new EncKeyWithID(privateKeyInfo, generalName);
        try {
            this.keyContent = new CMSProcessableByteArray(CRMFObjectIdentifiers.id_ct_encKeyWithID, encKeyWithID.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode key and general name info");
        }
        this.envGen = new CMSEnvelopedDataGenerator();
    }

    public PKIArchiveControlBuilder addRecipientGenerator(RecipientInfoGenerator recipientGen) {
        this.envGen.addRecipientInfoGenerator(recipientGen);
        return this;
    }

    public PKIArchiveControl build(OutputEncryptor contentEncryptor) throws CMSException {
        CMSEnvelopedData envContent = this.envGen.generate(this.keyContent, contentEncryptor);
        EnvelopedData envD = EnvelopedData.getInstance(envContent.getContentInfo().getContent());
        return new PKIArchiveControl(new PKIArchiveOptions(new EncryptedKey(envD)));
    }
}

