/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cert.crmf;

import cn.tca.TopBasicCrypto.asn1.DERBitString;
import cn.tca.TopBasicCrypto.asn1.crmf.PKMACValue;
import cn.tca.TopBasicCrypto.asn1.crmf.POPOSigningKey;
import cn.tca.TopBasicCrypto.asn1.crmf.POPOSigningKeyInput;
import cn.tca.TopBasicCrypto.asn1.x509.GeneralName;
import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.cert.crmf.CRMFException;
import cn.tca.TopBasicCrypto.cert.crmf.CRMFUtil;
import cn.tca.TopBasicCrypto.cert.crmf.PKMACValueGenerator;
import cn.tca.TopBasicCrypto.operator.ContentSigner;

public class ProofOfPossessionSigningKeyBuilder {
    private SubjectPublicKeyInfo pubKeyInfo;
    private GeneralName name;
    private PKMACValue publicKeyMAC;

    public ProofOfPossessionSigningKeyBuilder(SubjectPublicKeyInfo pubKeyInfo) {
        this.pubKeyInfo = pubKeyInfo;
    }

    public ProofOfPossessionSigningKeyBuilder setSender(GeneralName name) {
        this.name = name;
        return this;
    }

    public ProofOfPossessionSigningKeyBuilder setPublicKeyMac(PKMACValueGenerator generator, char[] password) throws CRMFException {
        this.publicKeyMAC = generator.generate(password, this.pubKeyInfo);
        return this;
    }

    public POPOSigningKey build(ContentSigner signer) {
        if (this.name != null && this.publicKeyMAC != null) {
            throw new IllegalStateException("name and publicKeyMAC cannot both be set.");
        }
        POPOSigningKeyInput popo = this.name != null ? new POPOSigningKeyInput(this.name, this.pubKeyInfo) : new POPOSigningKeyInput(this.publicKeyMAC, this.pubKeyInfo);
        CRMFUtil.derEncodeToStream(popo, signer.getOutputStream());
        return new POPOSigningKey(popo, signer.getAlgorithmIdentifier(), new DERBitString(signer.getSignature()));
    }
}

