/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1Set;
import cn.tca.TopBasicCrypto.asn1.cms.AuthEnvelopedData;
import cn.tca.TopBasicCrypto.asn1.cms.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.cms.EncryptedContentInfo;
import cn.tca.TopBasicCrypto.asn1.cms.OriginatorInfo;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedHelper;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSReadable;
import cn.tca.TopBasicCrypto.cms.CMSSecureReadable;
import cn.tca.TopBasicCrypto.cms.CMSUtils;
import cn.tca.TopBasicCrypto.cms.RecipientInformationStore;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import javax.crypto.SecretKey;

class CMSAuthEnvelopedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private OriginatorInfo originator;
    private AlgorithmIdentifier authEncAlg;
    private ASN1Set authAttrs;
    private byte[] mac;
    private ASN1Set unauthAttrs;

    public CMSAuthEnvelopedData(byte[] authEnvData) throws CMSException {
        this(CMSUtils.readContentInfo(authEnvData));
    }

    public CMSAuthEnvelopedData(InputStream authEnvData) throws CMSException {
        this(CMSUtils.readContentInfo(authEnvData));
    }

    public CMSAuthEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        AuthEnvelopedData authEnvData = AuthEnvelopedData.getInstance(contentInfo.getContent());
        this.originator = authEnvData.getOriginatorInfo();
        ASN1Set recipientInfos = authEnvData.getRecipientInfos();
        EncryptedContentInfo authEncInfo = authEnvData.getAuthEncryptedContentInfo();
        this.authEncAlg = authEncInfo.getContentEncryptionAlgorithm();
        CMSSecureReadable secureReadable = new CMSSecureReadable(){

            public AlgorithmIdentifier getAlgorithm() {
                return CMSAuthEnvelopedData.this.authEncAlg;
            }

            public Object getCryptoObject() {
                return null;
            }

            public CMSReadable getReadable(SecretKey key, Provider provider) throws CMSException {
                throw new CMSException("AuthEnveloped data decryption not yet implemented");
            }

            public InputStream getInputStream() throws IOException, CMSException {
                return null;
            }
        };
        this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.authEncAlg, secureReadable);
        this.authAttrs = authEnvData.getAuthAttrs();
        this.mac = authEnvData.getMac().getOctets();
        this.unauthAttrs = authEnvData.getUnauthAttrs();
    }
}

