/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.x500.X500Name;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extension;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cms.KeyTransRecipientInformation;
import cn.tca.TopBasicCrypto.cms.RecipientId;
import cn.tca.TopBasicCrypto.crypto.digests.SHA1Digest;
import cn.tca.TopBasicCrypto.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class KeyTransRecipientId
extends RecipientId {
    private byte[] subjectKeyId;
    private X500Name issuer;
    private BigInteger serialNumber;

    public KeyTransRecipientId(byte[] subjectKeyId) {
        super(0);
        super.setSubjectKeyIdentifier(new DEROctetString(subjectKeyId).getDEREncoded());
        this.subjectKeyId = subjectKeyId;
    }

    public KeyTransRecipientId(X500Name issuer, BigInteger serialNumber) {
        super(0);
        this.issuer = issuer;
        this.serialNumber = serialNumber;
        try {
            this.setIssuer(issuer.getDEREncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid issuer: " + e.getMessage());
        }
        this.setSerialNumber(serialNumber);
    }

    public int hashCode() {
        int code = Arrays.hashCode(this.subjectKeyId);
        if (this.serialNumber != null) {
            code ^= this.serialNumber.hashCode();
        }
        if (this.issuer != null) {
            code ^= this.issuer.hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (!(o instanceof KeyTransRecipientId)) {
            return false;
        }
        KeyTransRecipientId id = (KeyTransRecipientId)o;
        return Arrays.areEqual(this.subjectKeyId, id.subjectKeyId) && this.equalsObj(this.serialNumber, id.serialNumber) && this.equalsObj(this.issuer, id.issuer);
    }

    private boolean equalsObj(Object a, Object b) {
        return a != null ? a.equals(b) : b == null;
    }

    public boolean match(Object obj) {
        if (obj instanceof X509CertificateHolder) {
            X509CertificateHolder certHldr = (X509CertificateHolder)obj;
            if (this.getSerialNumber() != null) {
                IssuerAndSerialNumber iAndS = certHldr.getIssuerAndSerialNumber();
                return iAndS.getName().equals(this.issuer) && iAndS.getSerialNumber().getValue().equals(this.getSerialNumber());
            }
            if (this.getSubjectKeyIdentifier() != null) {
                X509Extension ext = certHldr.getExtension(X509Extension.subjectKeyIdentifier);
                if (ext == null) {
                    SHA1Digest dig = new SHA1Digest();
                    byte[] hash = new byte[dig.getDigestSize()];
                    byte[] spkiEnc = certHldr.getSubjectPublicKeyInfo().getDEREncoded();
                    dig.update(spkiEnc, 0, spkiEnc.length);
                    dig.doFinal(hash, 0);
                    return Arrays.areEqual(this.subjectKeyId, hash);
                }
                byte[] subKeyID = ASN1OctetString.getInstance(ext.getParsedValue()).getOctets();
                return Arrays.areEqual(this.subjectKeyId, subKeyID);
            }
        } else {
            if (obj instanceof byte[]) {
                return Arrays.areEqual(this.subjectKeyId, (byte[])obj);
            }
            if (obj instanceof KeyTransRecipientInformation) {
                return ((KeyTransRecipientInformation)obj).getRID().equals(this);
            }
        }
        return false;
    }
}

