/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cms;

import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.operator.InputDecryptor;
import cn.tca.TopBasicCrypto.operator.MacCalculator;
import cn.tca.TopBasicCrypto.util.io.TeeInputStream;
import java.io.InputStream;

public class RecipientOperator {
    private final AlgorithmIdentifier algorithmIdentifier;
    private final Object operator;

    public RecipientOperator(InputDecryptor decryptor) {
        this.algorithmIdentifier = decryptor.getAlgorithmIdentifier();
        this.operator = decryptor;
    }

    public RecipientOperator(MacCalculator macCalculator) {
        this.algorithmIdentifier = macCalculator.getAlgorithmIdentifier();
        this.operator = macCalculator;
    }

    public InputStream getInputStream(InputStream dataIn) {
        if (this.operator instanceof InputDecryptor) {
            return ((InputDecryptor)this.operator).getInputStream(dataIn);
        }
        return new TeeInputStream(dataIn, ((MacCalculator)this.operator).getOutputStream());
    }

    public boolean isMacBased() {
        return this.operator instanceof MacCalculator;
    }

    public byte[] getMac() {
        return ((MacCalculator)this.operator).getMac();
    }
}

