/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.cms.jcajce;

import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.KEKRecipient;
import cn.tca.TopBasicCrypto.cms.jcajce.CMSUtils;
import cn.tca.TopBasicCrypto.cms.jcajce.EnvelopedDataHelper;
import cn.tca.TopBasicCrypto.jcajce.DefaultJcaJceHelper;
import cn.tca.TopBasicCrypto.jcajce.NamedJcaJceHelper;
import cn.tca.TopBasicCrypto.jcajce.ProviderJcaJceHelper;
import cn.tca.TopBasicCrypto.operator.OperatorException;
import cn.tca.TopBasicCrypto.operator.SymmetricKeyUnwrapper;
import java.security.Key;
import java.security.Provider;
import javax.crypto.SecretKey;

public abstract class JceKEKRecipient
implements KEKRecipient {
    private SecretKey recipientKey;
    protected EnvelopedDataHelper helper;
    protected EnvelopedDataHelper contentHelper;

    public JceKEKRecipient(SecretKey recipientKey) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new DefaultJcaJceHelper());
        this.recipientKey = recipientKey;
    }

    public JceKEKRecipient setProvider(Provider provider) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKEKRecipient setProvider(String providerName) {
        this.contentHelper = this.helper = new EnvelopedDataHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JceKEKRecipient setContentProvider(Provider provider) {
        this.contentHelper = new EnvelopedDataHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JceKEKRecipient setContentProvider(String providerName) {
        this.contentHelper = new EnvelopedDataHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    protected Key extractSecretKey(AlgorithmIdentifier keyEncryptionAlgorithm, AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        SymmetricKeyUnwrapper unwrapper = this.helper.createSymmetricUnwrapper(keyEncryptionAlgorithm, this.recipientKey);
        try {
            return CMSUtils.getJceKey(unwrapper.generateUnwrappedKey(contentEncryptionAlgorithm, encryptedContentEncryptionKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception unwrapping key: " + e.getMessage(), e);
        }
    }
}

