/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.crypto.tls;

import cn.tca.TopBasicCrypto.crypto.BasicAgreement;
import cn.tca.TopBasicCrypto.crypto.agreement.DHBasicAgreement;
import cn.tca.TopBasicCrypto.crypto.agreement.ECDHBasicAgreement;
import cn.tca.TopBasicCrypto.crypto.params.AsymmetricKeyParameter;
import cn.tca.TopBasicCrypto.crypto.params.DHPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.ECPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.tls.Certificate;
import cn.tca.TopBasicCrypto.crypto.tls.TlsAgreementCredentials;
import cn.tca.TopBasicCrypto.util.BigIntegers;
import java.math.BigInteger;

public class DefaultTlsAgreementCredentials
implements TlsAgreementCredentials {
    protected Certificate clientCert;
    protected AsymmetricKeyParameter clientPrivateKey;
    protected BasicAgreement basicAgreement;

    public DefaultTlsAgreementCredentials(Certificate clientCertificate, AsymmetricKeyParameter clientPrivateKey) {
        if (clientCertificate == null) {
            throw new IllegalArgumentException("'clientCertificate' cannot be null");
        }
        if (clientCertificate.certs.length == 0) {
            throw new IllegalArgumentException("'clientCertificate' cannot be empty");
        }
        if (clientPrivateKey == null) {
            throw new IllegalArgumentException("'clientPrivateKey' cannot be null");
        }
        if (!clientPrivateKey.isPrivate()) {
            throw new IllegalArgumentException("'clientPrivateKey' must be private");
        }
        if (clientPrivateKey instanceof DHPrivateKeyParameters) {
            this.basicAgreement = new DHBasicAgreement();
        } else if (clientPrivateKey instanceof ECPrivateKeyParameters) {
            this.basicAgreement = new ECDHBasicAgreement();
        } else {
            throw new IllegalArgumentException("'clientPrivateKey' type not supported: " + clientPrivateKey.getClass().getName());
        }
        this.clientCert = clientCertificate;
        this.clientPrivateKey = clientPrivateKey;
    }

    public Certificate getCertificate() {
        return this.clientCert;
    }

    public byte[] generateAgreement(AsymmetricKeyParameter serverPublicKey) {
        this.basicAgreement.init(this.clientPrivateKey);
        BigInteger agreementValue = this.basicAgreement.calculateAgreement(serverPublicKey);
        return BigIntegers.asUnsignedByteArray(agreementValue);
    }
}

