/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.crypto.tls;

import cn.tca.TopBasicCrypto.crypto.CryptoException;
import cn.tca.TopBasicCrypto.crypto.Signer;
import cn.tca.TopBasicCrypto.crypto.digests.NullDigest;
import cn.tca.TopBasicCrypto.crypto.encodings.PKCS1Encoding;
import cn.tca.TopBasicCrypto.crypto.engines.RSABlindedEngine;
import cn.tca.TopBasicCrypto.crypto.params.AsymmetricKeyParameter;
import cn.tca.TopBasicCrypto.crypto.params.ParametersWithRandom;
import cn.tca.TopBasicCrypto.crypto.params.RSAKeyParameters;
import cn.tca.TopBasicCrypto.crypto.signers.GenericSigner;
import cn.tca.TopBasicCrypto.crypto.tls.CombinedHash;
import cn.tca.TopBasicCrypto.crypto.tls.TlsSigner;
import java.security.SecureRandom;

class TlsRSASigner
implements TlsSigner {
    TlsRSASigner() {
    }

    public byte[] calculateRawSignature(SecureRandom random, AsymmetricKeyParameter privateKey, byte[] md5andsha1) throws CryptoException {
        GenericSigner sig = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), new NullDigest());
        sig.init(true, new ParametersWithRandom(privateKey, random));
        sig.update(md5andsha1, 0, md5andsha1.length);
        return sig.generateSignature();
    }

    public Signer createVerifyer(AsymmetricKeyParameter publicKey) {
        GenericSigner s = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), new CombinedHash());
        s.init(false, publicKey);
        return s;
    }

    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof RSAKeyParameters && !publicKey.isPrivate();
    }
}

