/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider;

import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.x509.CertificatePair;
import cn.tca.TopBasicCrypto.jce.provider.ProviderUtil;
import cn.tca.TopBasicCrypto.x509.X509CertificatePair;
import cn.tca.TopBasicCrypto.x509.X509StreamParserSpi;
import cn.tca.TopBasicCrypto.x509.util.StreamParsingException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Collection;

public class X509CertPairParser
extends X509StreamParserSpi {
    private InputStream currentStream = null;

    private X509CertificatePair readDERCrossCertificatePair(InputStream in) throws IOException, CertificateParsingException {
        ASN1InputStream dIn = new ASN1InputStream(in, ProviderUtil.getReadLimit(in));
        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
        CertificatePair pair = CertificatePair.getInstance(seq);
        return new X509CertificatePair(pair);
    }

    public void engineInit(InputStream in) {
        this.currentStream = in;
        if (!this.currentStream.markSupported()) {
            this.currentStream = new BufferedInputStream(this.currentStream);
        }
    }

    public Object engineRead() throws StreamParsingException {
        try {
            this.currentStream.mark(10);
            int tag = this.currentStream.read();
            if (tag == -1) {
                return null;
            }
            this.currentStream.reset();
            return this.readDERCrossCertificatePair(this.currentStream);
        }
        catch (Exception e) {
            throw new StreamParsingException(e.toString(), e);
        }
    }

    public Collection engineReadAll() throws StreamParsingException {
        X509CertificatePair pair;
        ArrayList<X509CertificatePair> certs = new ArrayList<X509CertificatePair>();
        while ((pair = (X509CertificatePair)this.engineRead()) != null) {
            certs.add(pair);
        }
        return certs;
    }
}

