/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider.asymmetric.ec;

import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.cryptopro.ECGOST3410NamedCurves;
import cn.tca.TopBasicCrypto.asn1.nist.NISTNamedCurves;
import cn.tca.TopBasicCrypto.asn1.sec.SECNamedCurves;
import cn.tca.TopBasicCrypto.asn1.teletrust.TeleTrusTNamedCurves;
import cn.tca.TopBasicCrypto.asn1.x9.X962NamedCurves;
import cn.tca.TopBasicCrypto.asn1.x9.X9ECParameters;
import cn.tca.TopBasicCrypto.crypto.AsymmetricCipherKeyPair;
import cn.tca.TopBasicCrypto.crypto.generators.ECKeyPairGenerator;
import cn.tca.TopBasicCrypto.crypto.params.ECDomainParameters;
import cn.tca.TopBasicCrypto.crypto.params.ECKeyGenerationParameters;
import cn.tca.TopBasicCrypto.crypto.params.ECPrivateKeyParameters;
import cn.tca.TopBasicCrypto.crypto.params.ECPublicKeyParameters;
import cn.tca.TopBasicCrypto.jce.provider.JCEECPrivateKey;
import cn.tca.TopBasicCrypto.jce.provider.JCEECPublicKey;
import cn.tca.TopBasicCrypto.jce.provider.JDKKeyPairGenerator;
import cn.tca.TopBasicCrypto.jce.provider.ProviderUtil;
import cn.tca.TopBasicCrypto.jce.provider.asymmetric.ec.EC5Util;
import cn.tca.TopBasicCrypto.jce.spec.ECNamedCurveSpec;
import cn.tca.TopBasicCrypto.math.ec.ECCurve;
import cn.tca.TopBasicCrypto.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Hashtable;

public abstract class KeyPairGenerator
extends JDKKeyPairGenerator {
    public KeyPairGenerator(String algorithmName) {
        super(algorithmName);
    }

    public static class ECMQV
    extends EC {
        public ECMQV() {
            super("ECMQV");
        }
    }

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC");
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH");
        }
    }

    public static class ECGOST3410
    extends EC {
        public ECGOST3410() {
            super("ECGOST3410");
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class EC
    extends KeyPairGenerator {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        Object ecParams = null;
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        private static Hashtable ecParameters = new Hashtable();

        public EC() {
            super("EC");
            this.algorithm = "EC";
        }

        public EC(String algorithm) {
            super(algorithm);
            this.algorithm = algorithm;
        }

        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            this.ecParams = ecParameters.get(new Integer(strength));
            if (this.ecParams != null) {
                try {
                    this.initialize((ECGenParameterSpec)this.ecParams, random);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new InvalidParameterException("key size not configurable.");
                }
            } else {
                throw new InvalidParameterException("unknown key size.");
            }
        }

        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params instanceof cn.tca.TopBasicCrypto.jce.spec.ECParameterSpec) {
                cn.tca.TopBasicCrypto.jce.spec.ECParameterSpec p = (cn.tca.TopBasicCrypto.jce.spec.ECParameterSpec)params;
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECParameterSpec) {
                ECParameterSpec p = (ECParameterSpec)params;
                this.ecParams = params;
                ECCurve curve = EC5Util.convertCurve(p.getCurve());
                ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params instanceof ECGenParameterSpec) {
                Object ecP;
                String curveName = ((ECGenParameterSpec)params).getName();
                if (this.algorithm.equals("ECGOST3410")) {
                    ecP = ECGOST3410NamedCurves.getByName(curveName);
                    if (ecP == null) {
                        throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
                    }
                    this.ecParams = new ECNamedCurveSpec(curveName, ((ECDomainParameters)ecP).getCurve(), ((ECDomainParameters)ecP).getG(), ((ECDomainParameters)ecP).getN(), ((ECDomainParameters)ecP).getH(), ((ECDomainParameters)ecP).getSeed());
                } else {
                    ecP = X962NamedCurves.getByName(curveName);
                    if (ecP == null) {
                        ecP = SECNamedCurves.getByName(curveName);
                        if (ecP == null) {
                            ecP = NISTNamedCurves.getByName(curveName);
                        }
                        if (ecP == null) {
                            ecP = TeleTrusTNamedCurves.getByName(curveName);
                        }
                        if (ecP == null) {
                            try {
                                DERObjectIdentifier oid = new DERObjectIdentifier(curveName);
                                ecP = X962NamedCurves.getByOID(oid);
                                if (ecP == null) {
                                    ecP = SECNamedCurves.getByOID(oid);
                                }
                                if (ecP == null) {
                                    ecP = NISTNamedCurves.getByOID(oid);
                                }
                                if (ecP == null) {
                                    ecP = TeleTrusTNamedCurves.getByOID(oid);
                                }
                                if (ecP == null) {
                                    throw new InvalidAlgorithmParameterException("unknown curve OID: " + curveName);
                                }
                            }
                            catch (IllegalArgumentException ex) {
                                throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
                            }
                        }
                    }
                    this.ecParams = new ECNamedCurveSpec(curveName, ((X9ECParameters)ecP).getCurve(), ((X9ECParameters)ecP).getG(), ((X9ECParameters)ecP).getN(), ((X9ECParameters)ecP).getH(), null);
                }
                ECParameterSpec p = (ECParameterSpec)this.ecParams;
                ECCurve curve = EC5Util.convertCurve(p.getCurve());
                ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else if (params == null && ProviderUtil.getEcImplicitlyCa() != null) {
                cn.tca.TopBasicCrypto.jce.spec.ECParameterSpec p = ProviderUtil.getEcImplicitlyCa();
                this.ecParams = params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else {
                if (params == null && ProviderUtil.getEcImplicitlyCa() == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
            }
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new IllegalStateException("EC Key Pair Generator not initialised");
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
            if (this.ecParams instanceof cn.tca.TopBasicCrypto.jce.spec.ECParameterSpec) {
                cn.tca.TopBasicCrypto.jce.spec.ECParameterSpec p = (cn.tca.TopBasicCrypto.jce.spec.ECParameterSpec)this.ecParams;
                JCEECPublicKey pubKey = new JCEECPublicKey(this.algorithm, pub, p);
                return new KeyPair(pubKey, new JCEECPrivateKey(this.algorithm, priv, pubKey, p));
            }
            if (this.ecParams == null) {
                return new KeyPair(new JCEECPublicKey(this.algorithm, pub), new JCEECPrivateKey(this.algorithm, priv));
            }
            ECParameterSpec p = (ECParameterSpec)this.ecParams;
            JCEECPublicKey pubKey = new JCEECPublicKey(this.algorithm, pub, p);
            return new KeyPair(pubKey, new JCEECPrivateKey(this.algorithm, priv, pubKey, p));
        }

        static {
            ecParameters.put(new Integer(192), new ECGenParameterSpec("prime192v1"));
            ecParameters.put(new Integer(239), new ECGenParameterSpec("prime239v1"));
            ecParameters.put(new Integer(256), new ECGenParameterSpec("prime256v1"));
            ecParameters.put(new Integer(224), new ECGenParameterSpec("P-224"));
            ecParameters.put(new Integer(384), new ECGenParameterSpec("P-384"));
            ecParameters.put(new Integer(521), new ECGenParameterSpec("P-521"));
        }
    }
}

