/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.jce.provider.symmetric;

import cn.tca.TopBasicCrypto.asn1.ntt.NTTObjectIdentifiers;
import cn.tca.TopBasicCrypto.crypto.CipherKeyGenerator;
import cn.tca.TopBasicCrypto.crypto.engines.CamelliaEngine;
import cn.tca.TopBasicCrypto.crypto.engines.CamelliaWrapEngine;
import cn.tca.TopBasicCrypto.crypto.engines.RFC3211WrapEngine;
import cn.tca.TopBasicCrypto.crypto.modes.CBCBlockCipher;
import cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider;
import cn.tca.TopBasicCrypto.jce.provider.JCEBlockCipher;
import cn.tca.TopBasicCrypto.jce.provider.JCEKeyGenerator;
import cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameterGenerator;
import cn.tca.TopBasicCrypto.jce.provider.JDKAlgorithmParameters;
import cn.tca.TopBasicCrypto.jce.provider.WrapCipherSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.spec.IvParameterSpec;

public final class Camellia {
    private Camellia() {
    }

    public static class Mappings
    extends HashMap {
        public Mappings() {
            this.put("AlgorithmParameters.CAMELLIA", "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$AlgParams");
            this.put("Alg.Alias.AlgorithmParameters." + NTTObjectIdentifiers.id_camellia128_cbc, "CAMELLIA");
            this.put("Alg.Alias.AlgorithmParameters." + NTTObjectIdentifiers.id_camellia192_cbc, "CAMELLIA");
            this.put("Alg.Alias.AlgorithmParameters." + NTTObjectIdentifiers.id_camellia256_cbc, "CAMELLIA");
            this.put("AlgorithmParameterGenerator.CAMELLIA", "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$AlgParamGen");
            this.put("Alg.Alias.AlgorithmParameterGenerator." + NTTObjectIdentifiers.id_camellia128_cbc, "CAMELLIA");
            this.put("Alg.Alias.AlgorithmParameterGenerator." + NTTObjectIdentifiers.id_camellia192_cbc, "CAMELLIA");
            this.put("Alg.Alias.AlgorithmParameterGenerator." + NTTObjectIdentifiers.id_camellia256_cbc, "CAMELLIA");
            this.put("Cipher.CAMELLIA", "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$ECB");
            this.put("Cipher." + NTTObjectIdentifiers.id_camellia128_cbc, "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$CBC");
            this.put("Cipher." + NTTObjectIdentifiers.id_camellia192_cbc, "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$CBC");
            this.put("Cipher." + NTTObjectIdentifiers.id_camellia256_cbc, "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$CBC");
            this.put("Cipher.CAMELLIARFC3211WRAP", "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$RFC3211Wrap");
            this.put("Cipher.CAMELLIAWRAP", "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$Wrap");
            this.put("Alg.Alias.Cipher." + NTTObjectIdentifiers.id_camellia128_wrap, "CAMELLIAWRAP");
            this.put("Alg.Alias.Cipher." + NTTObjectIdentifiers.id_camellia192_wrap, "CAMELLIAWRAP");
            this.put("Alg.Alias.Cipher." + NTTObjectIdentifiers.id_camellia256_wrap, "CAMELLIAWRAP");
            this.put("KeyGenerator.CAMELLIA", "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$KeyGen");
            this.put("KeyGenerator." + NTTObjectIdentifiers.id_camellia128_wrap, "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$KeyGen128");
            this.put("KeyGenerator." + NTTObjectIdentifiers.id_camellia192_wrap, "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$KeyGen192");
            this.put("KeyGenerator." + NTTObjectIdentifiers.id_camellia256_wrap, "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$KeyGen256");
            this.put("KeyGenerator." + NTTObjectIdentifiers.id_camellia128_cbc, "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$KeyGen128");
            this.put("KeyGenerator." + NTTObjectIdentifiers.id_camellia192_cbc, "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$KeyGen192");
            this.put("KeyGenerator." + NTTObjectIdentifiers.id_camellia256_cbc, "cn.tca.TopBasicCrypto.jce.provider.symmetric.Camellia$KeyGen256");
        }
    }

    public static class AlgParams
    extends JDKAlgorithmParameters.IVAlgorithmParameters {
        protected String engineToString() {
            return "Camellia IV";
        }
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for Camellia parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("Camellia", BouncyCastleProvider.PROVIDER_NAME);
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class KeyGen256
    extends KeyGen {
        public KeyGen256() {
            super(256);
        }
    }

    public static class KeyGen192
    extends KeyGen {
        public KeyGen192() {
            super(192);
        }
    }

    public static class KeyGen128
    extends KeyGen {
        public KeyGen128() {
            super(128);
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            this(256);
        }

        public KeyGen(int keySize) {
            super("Camellia", keySize, new CipherKeyGenerator());
        }
    }

    public static class RFC3211Wrap
    extends WrapCipherSpi {
        public RFC3211Wrap() {
            super(new RFC3211WrapEngine(new CamelliaEngine()), 16);
        }
    }

    public static class Wrap
    extends WrapCipherSpi {
        public Wrap() {
            super(new CamelliaWrapEngine());
        }
    }

    public static class CBC
    extends JCEBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new CamelliaEngine()), 128);
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new CamelliaEngine());
        }
    }
}

