/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.apache.bzip2.CBZip2OutputStream;
import cn.tca.TopBasicCrypto.bcpg.BCPGOutputStream;
import cn.tca.TopBasicCrypto.bcpg.CompressionAlgorithmTags;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.StreamGenerator;
import cn.tca.TopBasicCrypto.openpgp.WrappedGeneratorStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class PGPCompressedDataGenerator
implements CompressionAlgorithmTags,
StreamGenerator {
    private int algorithm;
    private int compression;
    private OutputStream out;
    private OutputStream dOut;
    private BCPGOutputStream pkOut;

    public PGPCompressedDataGenerator(int algorithm) {
        this(algorithm, -1);
    }

    public PGPCompressedDataGenerator(int algorithm, int compression) {
        if (algorithm != 0 && algorithm != 1 && algorithm != 2 && algorithm != 3) {
            throw new IllegalArgumentException("unknown compression algorithm");
        }
        if (compression != -1 && (compression < 0 || compression > 9)) {
            throw new IllegalArgumentException("unknown compression level: " + compression);
        }
        this.algorithm = algorithm;
        this.compression = compression;
    }

    public OutputStream open(OutputStream out) throws IOException {
        if (this.dOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.out = out;
        switch (this.algorithm) {
            case 1: {
                this.pkOut = new BCPGOutputStream(out, 8);
                this.pkOut.write(1);
                this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression, true));
                break;
            }
            case 2: {
                this.pkOut = new BCPGOutputStream(out, 8);
                this.pkOut.write(2);
                this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression));
                break;
            }
            case 3: {
                this.pkOut = new BCPGOutputStream(out, 8);
                this.pkOut.write(3);
                this.dOut = new CBZip2OutputStream(this.pkOut);
                break;
            }
            case 0: {
                this.pkOut = new BCPGOutputStream(out, 8);
                this.pkOut.write(0);
                this.dOut = this.pkOut;
                break;
            }
            default: {
                throw new IllegalStateException("generator not initialised");
            }
        }
        return new WrappedGeneratorStream(this.dOut, this);
    }

    public OutputStream open(OutputStream out, byte[] buffer) throws IOException, PGPException {
        if (this.dOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.out = out;
        switch (this.algorithm) {
            case 1: {
                this.pkOut = new BCPGOutputStream(out, 8, buffer);
                this.pkOut.write(1);
                this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression, true));
                break;
            }
            case 2: {
                this.pkOut = new BCPGOutputStream(out, 8, buffer);
                this.pkOut.write(2);
                this.dOut = new DeflaterOutputStream((OutputStream)this.pkOut, new Deflater(this.compression));
                break;
            }
            case 3: {
                this.pkOut = new BCPGOutputStream(out, 8, buffer);
                this.pkOut.write(3);
                this.dOut = new CBZip2OutputStream(this.pkOut);
                break;
            }
            case 0: {
                this.pkOut = new BCPGOutputStream(out, 8, buffer);
                this.pkOut.write(0);
                this.dOut = this.pkOut;
                break;
            }
            default: {
                throw new IllegalStateException("generator not initialised");
            }
        }
        return new WrappedGeneratorStream(this.dOut, this);
    }

    public void close() throws IOException {
        if (this.dOut != null) {
            if (this.dOut instanceof DeflaterOutputStream) {
                DeflaterOutputStream dfOut = (DeflaterOutputStream)this.dOut;
                dfOut.finish();
            } else if (this.dOut instanceof CBZip2OutputStream) {
                CBZip2OutputStream cbOut = (CBZip2OutputStream)this.dOut;
                cbOut.finish();
            }
            this.dOut.flush();
            this.pkOut.finish();
            this.pkOut.flush();
            this.out.flush();
            this.dOut = null;
            this.pkOut = null;
            this.out = null;
        }
    }
}

