/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.BCPGInputStream;
import cn.tca.TopBasicCrypto.bcpg.BCPGOutputStream;
import cn.tca.TopBasicCrypto.bcpg.OnePassSignaturePacket;
import cn.tca.TopBasicCrypto.openpgp.PGPException;
import cn.tca.TopBasicCrypto.openpgp.PGPPublicKey;
import cn.tca.TopBasicCrypto.openpgp.PGPSignature;
import cn.tca.TopBasicCrypto.openpgp.PGPUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;

public class PGPOnePassSignature {
    private OnePassSignaturePacket sigPack;
    private int signatureType;
    private Signature sig;
    private byte lastb;

    PGPOnePassSignature(BCPGInputStream pIn) throws IOException, PGPException {
        this((OnePassSignaturePacket)pIn.readPacket());
    }

    PGPOnePassSignature(OnePassSignaturePacket sigPack) throws PGPException {
        this.sigPack = sigPack;
        this.signatureType = sigPack.getSignatureType();
    }

    public void initVerify(PGPPublicKey pubKey, String provider) throws NoSuchProviderException, PGPException {
        this.initVerify(pubKey, PGPUtil.getProvider(provider));
    }

    public void initVerify(PGPPublicKey pubKey, Provider provider) throws PGPException {
        this.lastb = 0;
        try {
            this.sig = Signature.getInstance(PGPUtil.getSignatureName(this.sigPack.getKeyAlgorithm(), this.sigPack.getHashAlgorithm()), provider);
        }
        catch (Exception e) {
            throw new PGPException("can't set up signature object.", e);
        }
        try {
            this.sig.initVerify(pubKey.getKey(provider));
        }
        catch (InvalidKeyException e) {
            throw new PGPException("invalid key.", e);
        }
    }

    public void update(byte b) throws SignatureException {
        if (this.signatureType == 1) {
            if (b == 13) {
                this.sig.update((byte)13);
                this.sig.update((byte)10);
            } else if (b == 10) {
                if (this.lastb != 13) {
                    this.sig.update((byte)13);
                    this.sig.update((byte)10);
                }
            } else {
                this.sig.update(b);
            }
            this.lastb = b;
        } else {
            this.sig.update(b);
        }
    }

    public void update(byte[] bytes) throws SignatureException {
        if (this.signatureType == 1) {
            for (int i = 0; i != bytes.length; ++i) {
                this.update(bytes[i]);
            }
        } else {
            this.sig.update(bytes);
        }
    }

    public void update(byte[] bytes, int off, int length) throws SignatureException {
        if (this.signatureType == 1) {
            int finish = off + length;
            for (int i = off; i != finish; ++i) {
                this.update(bytes[i]);
            }
        } else {
            this.sig.update(bytes, off, length);
        }
    }

    public boolean verify(PGPSignature pgpSig) throws PGPException, SignatureException {
        this.sig.update(pgpSig.getSignatureTrailer());
        return this.sig.verify(pgpSig.getSignature());
    }

    public long getKeyID() {
        return this.sigPack.getKeyID();
    }

    public int getSignatureType() {
        return this.sigPack.getSignatureType();
    }

    public int getHashAlgorithm() {
        return this.sigPack.getHashAlgorithm();
    }

    public int getKeyAlgorithm() {
        return this.sigPack.getKeyAlgorithm();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = outStream instanceof BCPGOutputStream ? (BCPGOutputStream)outStream : new BCPGOutputStream(outStream);
        out.writePacket(this.sigPack);
    }
}

