/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.openpgp;

import cn.tca.TopBasicCrypto.bcpg.SignatureSubpacket;
import cn.tca.TopBasicCrypto.bcpg.sig.IssuerKeyID;
import cn.tca.TopBasicCrypto.bcpg.sig.KeyExpirationTime;
import cn.tca.TopBasicCrypto.bcpg.sig.KeyFlags;
import cn.tca.TopBasicCrypto.bcpg.sig.NotationData;
import cn.tca.TopBasicCrypto.bcpg.sig.PreferredAlgorithms;
import cn.tca.TopBasicCrypto.bcpg.sig.PrimaryUserID;
import cn.tca.TopBasicCrypto.bcpg.sig.SignatureCreationTime;
import cn.tca.TopBasicCrypto.bcpg.sig.SignatureExpirationTime;
import cn.tca.TopBasicCrypto.bcpg.sig.SignerUserID;
import java.util.ArrayList;
import java.util.Date;

public class PGPSignatureSubpacketVector {
    SignatureSubpacket[] packets;

    PGPSignatureSubpacketVector(SignatureSubpacket[] packets) {
        this.packets = packets;
    }

    public SignatureSubpacket getSubpacket(int type) {
        for (int i = 0; i != this.packets.length; ++i) {
            if (this.packets[i].getType() != type) continue;
            return this.packets[i];
        }
        return null;
    }

    public boolean hasSubpacket(int type) {
        return this.getSubpacket(type) != null;
    }

    public SignatureSubpacket[] getSubpackets(int type) {
        ArrayList<SignatureSubpacket> list = new ArrayList<SignatureSubpacket>();
        for (int i = 0; i != this.packets.length; ++i) {
            if (this.packets[i].getType() != type) continue;
            list.add(this.packets[i]);
        }
        return list.toArray(new SignatureSubpacket[0]);
    }

    public NotationData[] getNotationDataOccurences() {
        SignatureSubpacket[] notations = this.getSubpackets(20);
        NotationData[] vals = new NotationData[notations.length];
        for (int i = 0; i < notations.length; ++i) {
            vals[i] = (NotationData)notations[i];
        }
        return vals;
    }

    public long getIssuerKeyID() {
        SignatureSubpacket p = this.getSubpacket(16);
        if (p == null) {
            return 0L;
        }
        return ((IssuerKeyID)p).getKeyID();
    }

    public Date getSignatureCreationTime() {
        SignatureSubpacket p = this.getSubpacket(2);
        if (p == null) {
            return null;
        }
        return ((SignatureCreationTime)p).getTime();
    }

    public long getSignatureExpirationTime() {
        SignatureSubpacket p = this.getSubpacket(3);
        if (p == null) {
            return 0L;
        }
        return ((SignatureExpirationTime)p).getTime();
    }

    public long getKeyExpirationTime() {
        SignatureSubpacket p = this.getSubpacket(9);
        if (p == null) {
            return 0L;
        }
        return ((KeyExpirationTime)p).getTime();
    }

    public int[] getPreferredHashAlgorithms() {
        SignatureSubpacket p = this.getSubpacket(21);
        if (p == null) {
            return null;
        }
        return ((PreferredAlgorithms)p).getPreferences();
    }

    public int[] getPreferredSymmetricAlgorithms() {
        SignatureSubpacket p = this.getSubpacket(11);
        if (p == null) {
            return null;
        }
        return ((PreferredAlgorithms)p).getPreferences();
    }

    public int[] getPreferredCompressionAlgorithms() {
        SignatureSubpacket p = this.getSubpacket(22);
        if (p == null) {
            return null;
        }
        return ((PreferredAlgorithms)p).getPreferences();
    }

    public int getKeyFlags() {
        SignatureSubpacket p = this.getSubpacket(27);
        if (p == null) {
            return 0;
        }
        return ((KeyFlags)p).getFlags();
    }

    public String getSignerUserID() {
        SignatureSubpacket p = this.getSubpacket(28);
        if (p == null) {
            return null;
        }
        return ((SignerUserID)p).getID();
    }

    public boolean isPrimaryUserID() {
        PrimaryUserID primaryId = (PrimaryUserID)this.getSubpacket(25);
        if (primaryId != null) {
            return primaryId.isPrimaryUserID();
        }
        return false;
    }

    public int[] getCriticalTags() {
        int count = 0;
        for (int i = 0; i != this.packets.length; ++i) {
            if (!this.packets[i].isCritical()) continue;
            ++count;
        }
        int[] list = new int[count];
        count = 0;
        for (int i = 0; i != this.packets.length; ++i) {
            if (!this.packets[i].isCritical()) continue;
            list[count++] = this.packets[i].getType();
        }
        return list;
    }

    public int size() {
        return this.packets.length;
    }

    SignatureSubpacket[] toSubpacketArray() {
        return this.packets;
    }
}

