/*
 * Decompiled with CFR 0.152.
 */
package cn.tca.TopBasicCrypto.tsp;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.DERBoolean;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERNull;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.tsp.MessageImprint;
import cn.tca.TopBasicCrypto.asn1.tsp.TimeStampReq;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extension;
import cn.tca.TopBasicCrypto.asn1.x509.X509Extensions;
import cn.tca.TopBasicCrypto.tsp.TimeStampRequest;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Vector;

public class TimeStampRequestGenerator {
    private DERObjectIdentifier reqPolicy;
    private DERBoolean certReq;
    private Hashtable extensions = new Hashtable();
    private Vector extOrdering = new Vector();

    public void setReqPolicy(String reqPolicy) {
        this.reqPolicy = new DERObjectIdentifier(reqPolicy);
    }

    public void setCertReq(boolean certReq) {
        this.certReq = new DERBoolean(certReq);
    }

    public void addExtension(String OID, boolean critical, ASN1Encodable value) throws IOException {
        this.addExtension(OID, critical, value.getEncoded());
    }

    public void addExtension(String OID, boolean critical, byte[] value) {
        DERObjectIdentifier oid = new DERObjectIdentifier(OID);
        this.extensions.put(oid, new X509Extension(critical, (ASN1OctetString)new DEROctetString(value)));
        this.extOrdering.addElement(oid);
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean critical, ASN1Encodable value) throws IOException {
        this.addExtension(oid, critical, value.getEncoded());
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean critical, byte[] value) {
        this.extensions.put(oid, new X509Extension(critical, (ASN1OctetString)new DEROctetString(value)));
        this.extOrdering.addElement(oid);
    }

    public TimeStampRequest generate(String digestAlgorithm, byte[] digest) {
        return this.generate(digestAlgorithm, digest, null);
    }

    public TimeStampRequest generate(String digestAlgorithmOID, byte[] digest, BigInteger nonce) {
        if (digestAlgorithmOID == null) {
            throw new IllegalArgumentException("No digest algorithm specified");
        }
        DERObjectIdentifier digestAlgOID = new DERObjectIdentifier(digestAlgorithmOID);
        AlgorithmIdentifier algID = new AlgorithmIdentifier(digestAlgOID, new DERNull());
        MessageImprint messageImprint = new MessageImprint(algID, digest);
        X509Extensions ext = null;
        if (this.extOrdering.size() != 0) {
            ext = new X509Extensions(this.extOrdering, this.extensions);
        }
        if (nonce != null) {
            return new TimeStampRequest(new TimeStampReq(messageImprint, this.reqPolicy, new DERInteger(nonce), this.certReq, ext));
        }
        return new TimeStampRequest(new TimeStampReq(messageImprint, this.reqPolicy, null, this.certReq, ext));
    }

    public TimeStampRequest generate(ASN1ObjectIdentifier digestAlgorithm, byte[] digest, BigInteger nonce) {
        return this.generate(digestAlgorithm.getId(), digest, nonce);
    }
}

