/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.ec;

import cn.topca.security.ec.ECParameters;
import cn.topca.security.ec.ECPrivateKeyImpl;
import cn.topca.security.ec.ECPublicKeyImpl;
import cn.topca.security.ec.NamedCurve;
import cn.topca.security.jca.JCAJCEUtil;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int KEY_SIZE_MIN = 112;
    private static final int KEY_SIZE_MAX = 571;
    private static final int KEY_SIZE_DEFAULT = 256;
    private SecureRandom random;
    private int keySize;
    private AlgorithmParameterSpec params = null;

    public ECKeyPairGenerator() {
        this.initialize(256, null);
    }

    public void initialize(int keySize, SecureRandom random) {
        this.checkKeySize(keySize);
        this.params = NamedCurve.getECParameterSpec(keySize);
        if (this.params == null) {
            throw new InvalidParameterException("No EC parameters available for key size " + keySize + " bits");
        }
        this.random = random;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof ECParameterSpec) {
            this.params = ECParameters.getNamedCurve((ECParameterSpec)params);
            if (this.params == null) {
                throw new InvalidAlgorithmParameterException("Unsupported curve: " + params);
            }
        } else if (params instanceof ECGenParameterSpec) {
            String name = ((ECGenParameterSpec)params).getName();
            this.params = NamedCurve.getECParameterSpec(name);
            if (this.params == null) {
                throw new InvalidAlgorithmParameterException("Unknown curve name: " + name);
            }
        } else {
            throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
        }
        this.keySize = ((ECParameterSpec)this.params).getCurve().getField().getFieldSize();
        this.random = random;
    }

    public KeyPair generateKeyPair() {
        byte[] encodedParams = ECParameters.encodeParameters((ECParameterSpec)this.params);
        byte[] seed = new byte[((this.keySize + 7 >> 3) + 1) * 2];
        if (this.random == null) {
            this.random = JCAJCEUtil.getSecureRandom();
        }
        this.random.nextBytes(seed);
        try {
            long[] handles = ECKeyPairGenerator.generateECKeyPair(this.keySize, encodedParams, seed);
            BigInteger s = new BigInteger(1, ECKeyPairGenerator.getEncodedBytes(handles[0]));
            ECPrivateKeyImpl privateKey = new ECPrivateKeyImpl(s, (ECParameterSpec)this.params);
            ECPoint w = ECParameters.decodePoint(ECKeyPairGenerator.getEncodedBytes(handles[1]), ((ECParameterSpec)this.params).getCurve());
            ECPublicKeyImpl publicKey = new ECPublicKeyImpl(w, (ECParameterSpec)this.params);
            return new KeyPair(publicKey, privateKey);
        }
        catch (Exception e) {
            throw new ProviderException(e);
        }
    }

    private void checkKeySize(int keySize) throws InvalidParameterException {
        if (keySize < 112) {
            throw new InvalidParameterException("Key size must be at least 112 bits");
        }
        if (keySize > 571) {
            throw new InvalidParameterException("Key size must be at most 571 bits");
        }
        this.keySize = keySize;
    }

    private static native long[] generateECKeyPair(int var0, byte[] var1, byte[] var2) throws GeneralSecurityException;

    private static native byte[] getEncodedBytes(long var0);
}

