/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.ec;

import cn.tca.TopBasicCrypto.jce.spec.ECParameterSpec;
import cn.tca.TopBasicCrypto.math.ec.ECCurve;
import cn.tca.TopBasicCrypto.math.ec.ECFieldElement;
import cn.tca.TopBasicCrypto.math.ec.ECPoint;
import cn.topca.security.jca.JCAJCEUtil;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.spec.ECField;
import java.security.spec.ECFieldFp;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;

public class ECUtil {
    public static BigInteger getP(java.security.spec.ECParameterSpec ecParameterSpce) {
        return ECUtil.getP(ecParameterSpce.getCurve());
    }

    public static BigInteger getP(EllipticCurve curve) {
        ECField field = curve.getField();
        if (field instanceof ECFieldFp) {
            return ((ECFieldFp)field).getP();
        }
        throw new IllegalArgumentException(field.getClass().getCanonicalName());
    }

    public static ECCurve getBC_ECCurve(java.security.spec.ECParameterSpec ecParameterSpcec) {
        return ECUtil.convertToBC_EllipticCurve(ecParameterSpcec.getCurve());
    }

    public static cn.tca.TopBasicCrypto.math.ec.ECPoint getBC_ECGeneratorPoint(java.security.spec.ECParameterSpec ecParameterSpcec) {
        ECFieldElement.Fp ecc_gx_fieldelement = new ECFieldElement.Fp(ECUtil.getP(ecParameterSpcec), ecParameterSpcec.getGenerator().getAffineX());
        ECFieldElement.Fp ecc_gy_fieldelement = new ECFieldElement.Fp(ECUtil.getP(ecParameterSpcec), ecParameterSpcec.getGenerator().getAffineY());
        return new ECPoint.Fp(ECUtil.getBC_ECCurve(ecParameterSpcec), ecc_gx_fieldelement, ecc_gy_fieldelement);
    }

    public static ECParameterSpec convertBC_ECParameterSpec(java.security.spec.ECParameterSpec ecParameterSpec) {
        return new ECParameterSpec(ECUtil.getBC_ECCurve(ecParameterSpec), ECUtil.getBC_ECGeneratorPoint(ecParameterSpec), ecParameterSpec.getOrder());
    }

    public static ECCurve convertToBC_EllipticCurve(EllipticCurve curve) {
        return new ECCurve.Fp(ECUtil.getP(curve), curve.getA(), curve.getB());
    }

    public static cn.tca.TopBasicCrypto.math.ec.ECPoint convertToBC_ECPoint(EllipticCurve curve, ECPoint point) {
        if (curve.getField() instanceof ECFieldFp) {
            ECFieldElement.Fp x = new ECFieldElement.Fp(ECUtil.getP(curve), point.getAffineX());
            ECFieldElement.Fp y = new ECFieldElement.Fp(ECUtil.getP(curve), point.getAffineY());
            return new ECPoint.Fp(ECUtil.convertToBC_EllipticCurve(curve), x, y);
        }
        throw new IllegalArgumentException(curve.getClass().getCanonicalName());
    }

    public static java.security.spec.ECParameterSpec revertFromBC_ECParameterSpec(ECParameterSpec bcECParameterSpec) {
        return new java.security.spec.ECParameterSpec(ECUtil.revertFromBC_EllipticCurve(bcECParameterSpec.getCurve()), ECUtil.revertFromBC_ECPoint(bcECParameterSpec.getG()), bcECParameterSpec.getN(), bcECParameterSpec.getH().intValue());
    }

    public static EllipticCurve revertFromBC_EllipticCurve(ECCurve bcCurve) {
        if (bcCurve instanceof ECCurve.Fp) {
            ECCurve.Fp p = (ECCurve.Fp)bcCurve;
            return new EllipticCurve(new ECFieldFp(p.getQ()), p.getA().toBigInteger(), p.getB().toBigInteger());
        }
        throw new IllegalArgumentException(bcCurve.getClass().getCanonicalName());
    }

    public static ECPoint revertFromBC_ECPoint(cn.tca.TopBasicCrypto.math.ec.ECPoint bcECPoint) {
        return new ECPoint(bcECPoint.getX().toBigInteger(), bcECPoint.getY().toBigInteger());
    }

    public static ECPoint multiply(EllipticCurve curve, ECPoint point, BigInteger k) {
        return ECUtil.revertFromBC_ECPoint(ECUtil.convertToBC_ECPoint(curve, point).multiply(k));
    }

    public static final BigInteger getRandomMultiple(java.security.spec.ECParameterSpec curve) {
        BigInteger d;
        BigInteger n = curve.getOrder();
        int nBitLength = n.bitLength();
        while ((d = new BigInteger(nBitLength, n.intValue(), JCAJCEUtil.getSecureRandom())).equals(BigInteger.ZERO) || d.compareTo(n) >= 0 || nBitLength != d.bitLength()) {
        }
        return d;
    }

    public static final ECPoint getECPoint(java.security.spec.ECParameterSpec curve, BigInteger multiple) {
        BigInteger n = curve.getOrder();
        if (multiple.equals(BigInteger.ZERO) || multiple.compareTo(n) >= 0) {
            throw new InvalidParameterException("Multiple:" + multiple.toString());
        }
        return ECUtil.revertFromBC_ECPoint(ECUtil.getBC_ECGeneratorPoint(curve).multiply(multiple));
    }
}

