/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.j2se15.patch.PatchUtil;
import cn.topca.security.pkcs11.ConfigurationException;
import cn.topca.security.pkcs11.ExtendSMConstants;
import cn.topca.security.pkcs11.TemplateManager;
import cn.topca.security.pkcs11.jna.CK_ATTRIBUTE;
import cn.topca.security.pkcs11.jna.Functions;
import cn.topca.security.util.PropertyExpander;
import cn.topca.security.util.action.GetPropertyAction;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class Config {
    static final int ERR_HALT = 1;
    static final int ERR_IGNORE_ALL = 2;
    static final int ERR_IGNORE_LIB = 3;
    private static final boolean staticAllowSingleThreadedModules;
    private static final Map<String, Config> configMap;
    private static final boolean DEBUG = false;
    private Reader reader;
    private StreamTokenizer st;
    private Set<String> parsedKeywords;
    private String name;
    private String library;
    private String password;
    private String description;
    private int slotID = -1;
    private int slotListIndex = -1;
    private Set<Long> enabledMechanisms;
    private Set<Long> disabledMechanisms;
    private boolean showInfo = false;
    private TemplateManager templateManager;
    private int handleStartupErrors = 1;
    private boolean keyStoreCompatibilityMode = true;
    private boolean explicitCancel = true;
    private int insertionCheckInterval = 2000;
    private boolean omitInitialize = false;
    private boolean allowSingleThreadedModules = true;
    private String functionList = "C_GetFunctionList";
    private String[] searchPaths;
    private boolean overrideConstants = false;
    private Map<String, Long> extendConstants;
    private ExtendSMConstants sm2Constants;
    private static final CK_ATTRIBUTE[] CK_A0;

    static Config getConfig(String name, InputStream stream) {
        Config config = configMap.get(name);
        if (config != null) {
            return config;
        }
        try {
            config = new Config(name, stream);
            configMap.put(name, config);
            return config;
        }
        catch (Exception e) {
            throw new ProviderException("Error parsing configuration", e);
        }
    }

    static Config removeConfig(String name) {
        return configMap.remove(name);
    }

    private static void debug(Object o) {
    }

    private Config(String filename, InputStream in) throws IOException {
        if (in == null) {
            if (filename.startsWith("--")) {
                String config = filename.substring(2).replace("\\n", "\n");
                this.reader = new StringReader(config);
            } else {
                in = new FileInputStream(Config.expand(filename));
            }
        }
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(in));
        }
        this.parsedKeywords = new HashSet<String>();
        this.st = new StreamTokenizer(this.reader);
        this.setupTokenizer();
        this.parse();
    }

    String getName() {
        return this.name;
    }

    String getLibrary() {
        return this.library;
    }

    String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return "TopPKCS11-" + this.name + " using library " + this.library;
    }

    String getPassword() {
        return this.password;
    }

    int getSlotID() {
        return this.slotID;
    }

    int getSlotListIndex() {
        if (this.slotID == -1 && this.slotListIndex == -1) {
            return 0;
        }
        return this.slotListIndex;
    }

    boolean getShowInfo() {
        return this.showInfo;
    }

    ExtendSMConstants getSMConstants() {
        if (this.sm2Constants == null) {
            this.sm2Constants = new ExtendSMConstants(this.extendConstants);
        }
        return this.sm2Constants;
    }

    TemplateManager getTemplateManager() {
        if (this.templateManager == null) {
            this.templateManager = new TemplateManager();
        }
        return this.templateManager;
    }

    boolean isEnabled(long m) {
        if (this.enabledMechanisms != null) {
            return this.enabledMechanisms.contains(m);
        }
        if (this.disabledMechanisms != null) {
            return !this.disabledMechanisms.contains(m);
        }
        return true;
    }

    int getHandleStartupErrors() {
        return this.handleStartupErrors;
    }

    boolean getKeyStoreCompatibilityMode() {
        return this.keyStoreCompatibilityMode;
    }

    boolean getExplicitCancel() {
        return this.explicitCancel;
    }

    int getInsertionCheckInterval() {
        return this.insertionCheckInterval;
    }

    boolean getOmitInitialize() {
        return this.omitInitialize;
    }

    boolean getAllowSingleThreadedModules() {
        return staticAllowSingleThreadedModules && this.allowSingleThreadedModules;
    }

    String[] getSearchPaths() {
        return this.searchPaths;
    }

    String getFunctionList() {
        return this.functionList;
    }

    private static String expand(String s) throws IOException {
        try {
            return PropertyExpander.expand(s);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void setupTokenizer() {
        this.st.resetSyntax();
        this.st.wordChars(97, 122);
        this.st.wordChars(65, 90);
        this.st.wordChars(48, 57);
        this.st.wordChars(58, 58);
        this.st.wordChars(46, 46);
        this.st.wordChars(95, 95);
        this.st.wordChars(45, 45);
        this.st.wordChars(47, 47);
        this.st.wordChars(92, 92);
        this.st.wordChars(36, 36);
        this.st.wordChars(123, 123);
        this.st.wordChars(125, 125);
        this.st.wordChars(42, 42);
        this.st.whitespaceChars(0, 32);
        this.st.commentChar(35);
        this.st.eolIsSignificant(true);
        this.st.quoteChar(34);
    }

    private ConfigurationException excToken(String msg) {
        return new ConfigurationException(msg + " " + this.st);
    }

    private ConfigurationException excLine(String msg) {
        return new ConfigurationException(msg + ", line " + this.st.lineno());
    }

    private void parse() throws IOException {
        int token;
        while ((token = this.nextToken()) != -1) {
            if (token == 10) continue;
            if (token != -3) {
                throw this.excToken("Unexpected token:");
            }
            String word = this.st.sval;
            if (word.equals("name")) {
                this.name = this.parseStringEntry(word);
            } else if (word.equals("library")) {
                this.library = this.parseLibrary(word);
            } else if (word.equals("searchPaths")) {
                this.searchPaths = this.parseSearchPaths(word);
            } else if (word.equals("password")) {
                this.password = this.parseStringEntry(word);
            } else if (word.equals("description")) {
                this.parseDescription(word);
            } else if (word.equals("slot")) {
                this.parseSlotID(word);
            } else if (word.equals("slotListIndex")) {
                this.parseSlotListIndex(word);
            } else if (word.equals("enabledMechanisms")) {
                this.parseEnabledMechanisms(word);
            } else if (word.equals("disabledMechanisms")) {
                this.parseDisabledMechanisms(word);
            } else if (word.equals("attributes")) {
                this.parseAttributes(word);
            } else if (word.equals("handleStartupErrors")) {
                this.parseHandleStartupErrors(word);
            } else if (word.endsWith("insertionCheckInterval")) {
                this.insertionCheckInterval = this.parseIntegerEntry(word);
                if (this.insertionCheckInterval < 100) {
                    throw this.excLine(word + " must be at least 100 ms");
                }
            } else if (word.equals("showInfo")) {
                this.showInfo = this.parseBooleanEntry(word);
            } else if (word.equals("keyStoreCompatibilityMode")) {
                this.keyStoreCompatibilityMode = this.parseBooleanEntry(word);
            } else if (word.equals("explicitCancel")) {
                this.explicitCancel = this.parseBooleanEntry(word);
            } else if (word.equals("omitInitialize")) {
                this.omitInitialize = this.parseBooleanEntry(word);
            } else if (word.equals("allowSingleThreadedModules")) {
                this.allowSingleThreadedModules = this.parseBooleanEntry(word);
            } else if (word.equals("functionList")) {
                this.functionList = this.parseStringEntry(word);
            } else if (word.equals("overrideConstants")) {
                this.overrideConstants = this.parseBooleanEntry(word);
            } else if (word.equals("extendConstants")) {
                this.extendConstants = this.parseExtendConstants(word);
            } else {
                throw new ConfigurationException("Unknown keyword '" + word + "', line " + this.st.lineno());
            }
            this.parsedKeywords.add(word);
        }
        this.reader.close();
        this.reader = null;
        this.st = null;
        this.parsedKeywords = null;
        if (this.name == null) {
            throw new ConfigurationException("name must be specified");
        }
        if (this.library == null) {
            throw new ConfigurationException("library must be specified");
        }
    }

    private int nextToken() throws IOException {
        int token = this.st.nextToken();
        Config.debug(this.st);
        return token;
    }

    private void parseEquals() throws IOException {
        int token = this.nextToken();
        if (token != 61) {
            throw this.excToken("Expected '=', read");
        }
    }

    private void parseOpenBraces() throws IOException {
        int token;
        while ((token = this.nextToken()) == 10) {
        }
        if (token == -3 && this.st.sval.equals("{")) {
            return;
        }
        throw this.excToken("Expected '{', read");
    }

    private boolean isCloseBraces(int token) {
        return token == -3 && this.st.sval.equals("}");
    }

    private String parseWord() throws IOException {
        int token = this.nextToken();
        if (token != -3) {
            throw this.excToken("Unexpected value:");
        }
        return this.st.sval;
    }

    private String parseStringEntry(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        int token = this.nextToken();
        if (token != -3 && token != 34) {
            throw this.excToken("Unexpected value:");
        }
        String value = this.st.sval;
        Config.debug(keyword + ": " + value);
        return value;
    }

    private boolean parseBooleanEntry(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        boolean value = this.parseBoolean();
        Config.debug(keyword + ": " + value);
        return value;
    }

    private int parseIntegerEntry(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        int value = (int)this.decodeNumber(this.parseWord());
        Config.debug(keyword + ": " + value);
        return value;
    }

    private boolean parseBoolean() throws IOException {
        String val = this.parseWord();
        if (val.equals("true")) {
            return true;
        }
        if (val.equals("false")) {
            return false;
        }
        throw this.excToken("Expected boolean value, read:");
    }

    private String parseLine() throws IOException {
        int token;
        String s = this.parseWord();
        while ((token = this.nextToken()) != 10 && token != -1) {
            if (token != -3) {
                throw this.excToken("Unexpected value");
            }
            s = s + " " + this.st.sval;
        }
        return s;
    }

    private long decodeNumber(String str) throws IOException {
        try {
            if (str.startsWith("0x") || str.startsWith("0X")) {
                return Long.parseLong(str.substring(2), 16);
            }
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            System.err.println(str);
            throw this.excToken("Expected number, read");
        }
    }

    private static boolean isNumber(String s) {
        if (s.length() == 0) {
            return false;
        }
        char ch = s.charAt(0);
        return ch >= '0' && ch <= '9';
    }

    private void parseComma() throws IOException {
        int token = this.nextToken();
        if (token != 44) {
            throw this.excToken("Expected ',', read");
        }
    }

    private static boolean isByteArray(String val) {
        return val.startsWith("0h");
    }

    private byte[] decodeByteArray(String str) throws IOException {
        if (!str.startsWith("0h")) {
            throw this.excToken("Expected byte array value, read");
        }
        str = str.substring(2);
        try {
            return new BigInteger(str, 16).toByteArray();
        }
        catch (NumberFormatException e) {
            throw this.excToken("Expected byte array value, read");
        }
    }

    private void checkDup(String keyword) throws IOException {
        if (this.parsedKeywords.contains(keyword)) {
            throw this.excLine(keyword + " must only be specified once");
        }
    }

    private String parseLibrary(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        String lib = this.parseLine();
        lib = Config.expand(lib);
        int i = lib.indexOf("/$ISA/");
        if (i != -1) {
            String osName = System.getProperty("os.name", "");
            String osArch = System.getProperty("os.arch", "");
            String prefix = lib.substring(0, i);
            String suffix = lib.substring(i + 5);
            lib = osName.equals("SunOS") && osArch.equals("sparcv9") ? prefix + "/sparcv9" + suffix : (osName.equals("SunOS") && osArch.equals("amd64") ? prefix + "/amd64" + suffix : prefix + suffix);
        }
        Config.debug(keyword + ": " + lib);
        return lib;
    }

    private void parseDescription(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        this.description = this.parseLine();
        Config.debug("description: " + this.description);
    }

    private void parseSlotID(String keyword) throws IOException {
        if (this.slotID >= 0) {
            throw this.excLine("Duplicate slot definition");
        }
        if (this.slotListIndex >= 0) {
            throw this.excLine("Only one of slot and slotListIndex must be specified");
        }
        this.parseEquals();
        String slotString = this.parseWord();
        this.slotID = (int)this.decodeNumber(slotString);
        Config.debug("slot: " + this.slotID);
    }

    private void parseSlotListIndex(String keyword) throws IOException {
        if (this.slotListIndex >= 0) {
            throw this.excLine("Duplicate slotListIndex definition");
        }
        if (this.slotID >= 0) {
            throw this.excLine("Only one of slot and slotListIndex must be specified");
        }
        this.parseEquals();
        String slotString = this.parseWord();
        this.slotListIndex = (int)this.decodeNumber(slotString);
        Config.debug("slotListIndex: " + this.slotListIndex);
    }

    private void parseEnabledMechanisms(String keyword) throws IOException {
        this.enabledMechanisms = this.parseMechanisms(keyword);
    }

    private void parseDisabledMechanisms(String keyword) throws IOException {
        this.disabledMechanisms = this.parseMechanisms(keyword);
    }

    private Set<Long> parseMechanisms(String keyword) throws IOException {
        int token;
        this.checkDup(keyword);
        HashSet<Long> mechs = new HashSet<Long>();
        this.parseEquals();
        this.parseOpenBraces();
        while (!this.isCloseBraces(token = this.nextToken())) {
            if (token == 10) continue;
            if (token != -3) {
                throw this.excToken("Expected mechanism, read");
            }
            long mech = this.parseMechanism(this.st.sval);
            mechs.add(mech);
        }
        return mechs;
    }

    private long parseMechanism(String mech) throws IOException {
        if (Config.isNumber(mech)) {
            return this.decodeNumber(mech);
        }
        try {
            return Functions.getMechanismId(mech);
        }
        catch (IllegalArgumentException e) {
            throw this.excLine("Unknown mechanism: " + mech);
        }
    }

    private void parseAttributes(String keyword) throws IOException {
        int token;
        if (this.templateManager == null) {
            this.templateManager = new TemplateManager();
        }
        if ((token = this.nextToken()) == 61) {
            String s = this.parseWord();
            if (!s.equals("compatibility")) {
                throw this.excLine("Expected 'compatibility', read " + s);
            }
            this.setCompatibilityAttributes();
            return;
        }
        if (token != 40) {
            throw this.excToken("Expected '(' or '=', read");
        }
        String op = this.parseOperation();
        this.parseComma();
        long objectClass = this.parseObjectClass();
        this.parseComma();
        long keyAlg = this.parseKeyAlgorithm();
        token = this.nextToken();
        if (token != 41) {
            throw this.excToken("Expected ')', read");
        }
        this.parseEquals();
        this.parseOpenBraces();
        ArrayList<CK_ATTRIBUTE> attributes = new ArrayList<CK_ATTRIBUTE>();
        while (!this.isCloseBraces(token = this.nextToken())) {
            if (token == 10) continue;
            if (token != -3) {
                throw this.excToken("Expected mechanism, read");
            }
            String attributeName = this.st.sval;
            long attributeId = this.decodeAttributeName(attributeName);
            this.parseEquals();
            String attributeValue = this.parseWord();
            attributes.add(this.decodeAttributeValue(attributeId, attributeValue));
        }
        this.templateManager.addTemplate(op, objectClass, keyAlg, attributes.toArray(CK_A0));
    }

    private void setCompatibilityAttributes() {
        this.templateManager.addTemplate("*", 4L, 0x7FFFFF22L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.TOKEN_FALSE, CK_ATTRIBUTE.SENSITIVE_FALSE, CK_ATTRIBUTE.EXTRACTABLE_TRUE, CK_ATTRIBUTE.ENCRYPT_TRUE, CK_ATTRIBUTE.DECRYPT_TRUE, CK_ATTRIBUTE.WRAP_TRUE, CK_ATTRIBUTE.UNWRAP_TRUE});
        this.templateManager.addTemplate("*", 4L, 16L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.SIGN_TRUE, CK_ATTRIBUTE.VERIFY_TRUE, CK_ATTRIBUTE.ENCRYPT_NULL, CK_ATTRIBUTE.DECRYPT_NULL, CK_ATTRIBUTE.WRAP_NULL, CK_ATTRIBUTE.UNWRAP_NULL, CK_ATTRIBUTE.DERIVE_TRUE});
        this.templateManager.addTemplate("*", 3L, 0x7FFFFF22L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.TOKEN_FALSE, CK_ATTRIBUTE.SENSITIVE_FALSE, CK_ATTRIBUTE.EXTRACTABLE_TRUE});
        this.templateManager.addTemplate("*", 2L, 0x7FFFFF22L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.TOKEN_FALSE});
        this.templateManager.addTemplate("*", 3L, 0L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.DECRYPT_TRUE, CK_ATTRIBUTE.SIGN_TRUE, CK_ATTRIBUTE.SIGN_RECOVER_TRUE, CK_ATTRIBUTE.UNWRAP_TRUE});
        this.templateManager.addTemplate("*", 2L, 0L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.ENCRYPT_TRUE, CK_ATTRIBUTE.VERIFY_TRUE, CK_ATTRIBUTE.VERIFY_RECOVER_TRUE, CK_ATTRIBUTE.WRAP_TRUE});
        this.templateManager.addTemplate("*", 3L, 1L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.SIGN_TRUE});
        this.templateManager.addTemplate("*", 2L, 1L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.VERIFY_TRUE});
        this.templateManager.addTemplate("*", 3L, 2L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.DERIVE_TRUE});
        this.templateManager.addTemplate("*", 3L, 3L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.SIGN_TRUE, CK_ATTRIBUTE.DERIVE_TRUE});
        this.templateManager.addTemplate("*", 2L, 3L, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.VERIFY_TRUE});
        long CKK_SM2 = this.getSMConstants().CKK_SM2;
        this.templateManager.addTemplate("*", 3L, CKK_SM2, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.DECRYPT_TRUE, CK_ATTRIBUTE.SIGN_TRUE});
        this.templateManager.addTemplate("*", 2L, CKK_SM2, new CK_ATTRIBUTE[]{CK_ATTRIBUTE.ENCRYPT_TRUE, CK_ATTRIBUTE.VERIFY_TRUE});
    }

    private String parseOperation() throws IOException {
        String op = this.parseWord();
        if (op.equals("*")) {
            return "*";
        }
        if (op.equals("generate")) {
            return "generate";
        }
        if (op.equals("import")) {
            return "import";
        }
        throw this.excLine("Unknown operation " + op);
    }

    private long parseObjectClass() throws IOException {
        String name = this.parseWord();
        try {
            return Functions.getObjectClassId(name);
        }
        catch (IllegalArgumentException e) {
            throw this.excLine("Unknown object class " + name);
        }
    }

    private long parseKeyAlgorithm() throws IOException {
        String name = this.parseWord();
        if (Config.isNumber(name)) {
            return this.decodeNumber(name);
        }
        try {
            return Functions.getKeyId(name);
        }
        catch (IllegalArgumentException e) {
            throw this.excLine("Unknown key algorithm " + name);
        }
    }

    private long decodeAttributeName(String name) throws IOException {
        if (Config.isNumber(name)) {
            return this.decodeNumber(name);
        }
        try {
            return Functions.getAttributeId(name);
        }
        catch (IllegalArgumentException e) {
            throw this.excLine("Unknown attribute name " + name);
        }
    }

    private CK_ATTRIBUTE decodeAttributeValue(long id, String value) throws IOException {
        if (value.equals("null")) {
            return new CK_ATTRIBUTE(id);
        }
        if (value.equals("true")) {
            return new CK_ATTRIBUTE(id, true);
        }
        if (value.equals("false")) {
            return new CK_ATTRIBUTE(id, false);
        }
        if (Config.isByteArray(value)) {
            return new CK_ATTRIBUTE(id, this.decodeByteArray(value));
        }
        if (Config.isNumber(value)) {
            return new CK_ATTRIBUTE(id, this.decodeNumber(value));
        }
        return new CK_ATTRIBUTE(id, value);
    }

    private void parseHandleStartupErrors(String keyword) throws IOException {
        this.checkDup(keyword);
        this.parseEquals();
        String val = this.parseWord();
        if (val.equals("ignoreAll")) {
            this.handleStartupErrors = 2;
        } else if (val.equals("ignoreMissingLibrary")) {
            this.handleStartupErrors = 3;
        } else if (val.equals("halt")) {
            this.handleStartupErrors = 1;
        } else {
            throw this.excToken("Invalid value for handleStartupErrors:");
        }
        Config.debug("handleStartupErrors: " + this.handleStartupErrors);
    }

    private Map<String, Long> parseExtendConstants(String keyword) throws IOException {
        int token;
        this.checkDup(keyword);
        HashMap<String, Long> extConstants = new HashMap<String, Long>();
        this.parseEquals();
        this.parseOpenBraces();
        while (!this.isCloseBraces(token = this.nextToken())) {
            if (token == 10) continue;
            if (token != -3) {
                throw this.excToken("Expected mechanism, read");
            }
            String key = this.st.sval;
            this.parseEquals();
            String value = this.parseWord();
            if (!Config.isNumber(value)) continue;
            extConstants.put(key, this.decodeNumber(value));
        }
        return extConstants;
    }

    private String[] parseSearchPaths(String keyword) throws IOException {
        int token;
        this.checkDup(keyword);
        HashSet<String> paths = new HashSet<String>();
        this.parseEquals();
        this.parseOpenBraces();
        String _path = "";
        while (!this.isCloseBraces(token = this.nextToken())) {
            if (token == 10) {
                if (!PatchUtil.isEmpty(_path.trim())) {
                    paths.add(Config.expand(_path.trim()));
                }
                _path = "";
                continue;
            }
            if (token != -3) {
                throw this.excToken("Expected searchPath, read");
            }
            _path = " " + this.st.sval;
        }
        return paths.toArray(new String[paths.size()]);
    }

    public boolean getNssNetscapeDbWorkaround() {
        return false;
    }

    void addSearchPath(Set<String> searchPath) {
        HashSet<String> _sp = new HashSet<String>(searchPath);
        for (String path : searchPath) {
            _sp.add(path);
        }
        this.searchPaths = _sp.toArray(new String[_sp.size()]);
        _sp.clear();
        _sp = null;
    }

    static {
        String p = "topca.pkcs11.allowSingleThreadedModules";
        String s = AccessController.doPrivileged(new GetPropertyAction(p));
        staticAllowSingleThreadedModules = !"false".equalsIgnoreCase(s);
        configMap = new HashMap<String, Config>();
        CK_A0 = new CK_ATTRIBUTE[0];
    }
}

