/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.security.pkcs11.P11Key;
import cn.topca.security.pkcs11.Session;
import cn.topca.security.pkcs11.Token;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import cn.topca.security.x509.AlgorithmId;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public abstract class P11KeyFactory
extends KeyFactorySpi {
    final Token token;
    final String algorithm;

    P11KeyFactory(Token token, String algorithm) {
        this.token = token;
        this.algorithm = algorithm;
    }

    public static P11Key convertKey(Token token, Key key, String algorithm) throws InvalidKeyException {
        return (P11Key)token.getKeyFactory(algorithm).engineTranslateKey(key);
    }

    @Override
    protected final <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpec) throws InvalidKeySpecException {
        P11Key p11Key;
        this.token.ensureValid();
        if (key == null || keySpec == null) {
            throw new InvalidKeySpecException("key and keySpec must not be null");
        }
        if (PKCS8EncodedKeySpec.class.isAssignableFrom(keySpec) || X509EncodedKeySpec.class.isAssignableFrom(keySpec)) {
            try {
                return this.implGetSoftwareFactory().getKeySpec(key, keySpec);
            }
            catch (GeneralSecurityException e) {
                throw new InvalidKeySpecException("Could not encode key", e);
            }
        }
        try {
            p11Key = (P11Key)this.engineTranslateKey(key);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException("Could not convert key", e);
        }
        Session[] session = new Session[1];
        try {
            if (p11Key.isPublic()) {
                KeySpec keySpec2 = this.implGetPublicKeySpec(p11Key, keySpec, session);
                return (T)keySpec2;
            }
            KeySpec keySpec3 = this.implGetPrivateKeySpec(p11Key, keySpec, session);
            return (T)keySpec3;
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not generate KeySpec", e);
        }
        finally {
            session[0] = this.token.releaseSession(session[0]);
        }
    }

    @Override
    protected final Key engineTranslateKey(Key key) throws InvalidKeyException {
        P11Key p11Key;
        this.token.ensureValid();
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        try {
            if (!AlgorithmId.get(key.getAlgorithm()).equals(AlgorithmId.get(this.algorithm))) {
                throw new InvalidKeyException("Key algorithm must be " + this.algorithm);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException("Key algorithm must be " + this.algorithm, e);
        }
        if (key instanceof P11Key) {
            p11Key = (P11Key)key;
            if (p11Key.token == this.token) {
                return key;
            }
        }
        if ((p11Key = this.token.privateCache.get(key)) != null) {
            return p11Key;
        }
        if (key instanceof PublicKey) {
            PublicKey publicKey = this.implTranslatePublicKey((PublicKey)key);
            this.token.privateCache.put(key, (P11Key)((Object)publicKey));
            return publicKey;
        }
        if (key instanceof PrivateKey) {
            PrivateKey privateKey = this.implTranslatePrivateKey((PrivateKey)key);
            this.token.privateCache.put(key, (P11Key)((Object)privateKey));
            return privateKey;
        }
        throw new InvalidKeyException("Key must be instance of PublicKey or PrivateKey");
    }

    abstract KeySpec implGetPublicKeySpec(P11Key var1, Class var2, Session[] var3) throws PKCS11Exception, InvalidKeySpecException;

    abstract KeySpec implGetPrivateKeySpec(P11Key var1, Class var2, Session[] var3) throws PKCS11Exception, InvalidKeySpecException;

    abstract PublicKey implTranslatePublicKey(PublicKey var1) throws InvalidKeyException;

    abstract PrivateKey implTranslatePrivateKey(PrivateKey var1) throws InvalidKeyException;

    abstract KeyFactory implGetSoftwareFactory() throws GeneralSecurityException;
}

