/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.security.pkcs11.P11Key;
import cn.topca.security.pkcs11.P11SecretKeyFactory;
import cn.topca.security.pkcs11.Session;
import cn.topca.security.pkcs11.Token;
import cn.topca.security.pkcs11.jna.CK_MECHANISM;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;

final class P11Mac
extends MacSpi {
    private static final int S_UNINIT = 1;
    private static final int S_RESET = 2;
    private static final int S_UPDATE = 3;
    private static final int S_DOFINAL = 4;
    private final Token token;
    private final String algorithm;
    private final long mechanism;
    private final CK_MECHANISM ckMechanism;
    private final int macLength;
    private P11Key p11Key;
    private Session session;
    private int state;
    private byte[] oneByte;

    P11Mac(Token token, String algorithm, long mechanism) throws PKCS11Exception {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = mechanism;
        Long params = null;
        switch ((int)mechanism) {
            case 529: {
                this.macLength = 16;
                break;
            }
            case 545: {
                this.macLength = 20;
                break;
            }
            case 593: {
                this.macLength = 32;
                break;
            }
            case 609: {
                this.macLength = 48;
                break;
            }
            case 625: {
                this.macLength = 64;
                break;
            }
            case 896: {
                this.macLength = 16;
                params = 16L;
                break;
            }
            case 897: {
                this.macLength = 20;
                params = 20L;
                break;
            }
            case 36865: {
                this.macLength = 16;
                params = 16L;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism: " + mechanism);
            }
        }
        this.ckMechanism = new CK_MECHANISM(mechanism, params);
        this.state = 1;
        this.initialize();
    }

    private void ensureInitialized() throws PKCS11Exception {
        this.token.ensureValid();
        if (this.state == 1) {
            this.initialize();
        }
    }

    private void cancelOperation() {
        this.token.ensureValid();
        if (this.state == 1) {
            return;
        }
        this.state = 1;
        if (this.session == null || !this.token.explicitCancel) {
            return;
        }
        try {
            this.token.p11.C_SignFinal(this.session.id(), 0);
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("Cancel failed", e);
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.state == 2) {
            return;
        }
        if (this.session == null) {
            this.session = this.token.getOpSession();
        }
        if (this.p11Key != null) {
            this.token.p11.C_SignInit(this.session.id(), this.ckMechanism, this.p11Key.keyID);
            this.state = 2;
        } else {
            this.state = 1;
        }
    }

    @Override
    protected int engineGetMacLength() {
        return this.macLength;
    }

    @Override
    protected void engineReset() {
        if (this.state == 4) {
            this.state = 1;
            return;
        }
        this.cancelOperation();
        try {
            this.initialize();
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("reset() failed, ", e);
        }
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.cancelOperation();
        this.p11Key = P11SecretKeyFactory.convertKey(this.token, key, this.algorithm);
        try {
            this.initialize();
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("init() failed", e);
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        try {
            this.ensureInitialized();
            byte[] mac = this.token.p11.C_SignFinal(this.session.id(), 0);
            this.state = 4;
            byte[] byArray = mac;
            return byArray;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("doFinal() failed", e);
        }
        finally {
            this.session = this.token.releaseSession(this.session);
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = input;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] b, int ofs, int len) {
        try {
            this.ensureInitialized();
            this.token.p11.C_SignUpdate(this.session.id(), 0L, b, ofs, len);
            this.state = 3;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("update() failed", e);
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        try {
            long addr;
            this.ensureInitialized();
            int len = byteBuffer.remaining();
            if (len <= 0) {
                return;
            }
            try {
                Field addressField = byteBuffer.getClass().getField("address");
                addr = addressField.getLong(byteBuffer);
            }
            catch (Exception e) {
                super.engineUpdate(byteBuffer);
                return;
            }
            int ofs = byteBuffer.position();
            this.token.p11.C_SignUpdate(this.session.id(), addr + (long)ofs, null, 0, len);
            byteBuffer.position(ofs + len);
            this.state = 3;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("update() failed", e);
        }
    }
}

