/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.pkcs11;

import cn.topca.security.pkcs11.P11Key;
import cn.topca.security.pkcs11.P11SM2KeyFactory;
import cn.topca.security.pkcs11.P11Util;
import cn.topca.security.pkcs11.Session;
import cn.topca.security.pkcs11.Token;
import cn.topca.security.pkcs11.TopPKCS11Provider;
import cn.topca.security.pkcs11.jna.CK_MECHANISM;
import cn.topca.security.pkcs11.jna.PKCS11;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import cn.topca.security.util.DerInputStream;
import cn.topca.security.util.DerOutputStream;
import cn.topca.security.util.DerValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class P11SM2Cipher
extends CipherSpi {
    private static final Log log = LogFactory.getLog((String)"TopP11-P11SM2Cipher");
    private static final int PAD_NONE = 5;
    private final long mechanism;
    private PKCS11 p11;
    private Session session = null;
    private boolean initialized;
    private final int blockSize;
    private int paddingType;
    private ByteArrayOutputStream buffer;
    private P11Key p11Key;
    private static final byte[] B0 = new byte[0];
    private int mode;
    private final Token token;
    private String algorithm;
    @Deprecated
    private static final Map<Provider, P11SM2Cipher> INSTANCEs = new HashMap<Provider, P11SM2Cipher>();
    @Deprecated
    private Provider provider;
    @Deprecated
    private static final String KEY_USAGE_EXTENSION_OID = "2.5.29.15";

    public P11SM2Cipher(Token token, String algorithm, long mechanism) throws PKCS11Exception {
        this.p11 = token.p11;
        this.mechanism = mechanism;
        this.blockSize = 0;
        this.token = token;
        this.algorithm = "SM2";
        String paddingMode = this.blockSize == 0 ? "NoPadding" : "PKCS5Padding";
        try {
            this.engineSetPadding(paddingMode);
        }
        catch (NoSuchPaddingException localNoSuchPaddingException) {
            throw new ProviderException(localNoSuchPaddingException);
        }
        this.openSession();
    }

    private void implInit(int opmode, Key key) throws InvalidKeyException {
        try {
            this.cancelOperation();
        }
        catch (PKCS11Exception e1) {
            throw new RuntimeException(e1.getMessage(), e1);
        }
        this.mode = opmode;
        this.buffer = new ByteArrayOutputStream();
        try {
            this.p11Key = P11SM2KeyFactory.convertKey(this.token, key, "SM2");
            this.initialize();
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException(e);
        }
    }

    private void cancelOperation() throws PKCS11Exception {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        if (this.session == null) {
            return;
        }
        int bufLen = this.buffer.size();
        byte[] _tmpOut = new byte[bufLen];
        switch (this.mode) {
            case 1: {
                this.p11.C_Encrypt(this.session.id(), this.buffer.toByteArray(), 0, bufLen, _tmpOut, 0, bufLen);
                break;
            }
            case 2: {
                this.p11.C_Decrypt(this.session.id(), this.buffer.toByteArray(), 0, bufLen, _tmpOut, 0, bufLen);
                break;
            }
            default: {
                throw new ProviderException("internal error");
            }
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        if (!this.initialized) {
            throw new RuntimeException("Uninitialized cipher");
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.session == null) {
            this.session = this.token.getOpSession();
        }
        CK_MECHANISM ckMechanism = new CK_MECHANISM(this.mechanism);
        switch (this.mode) {
            case 1: {
                this.p11.C_EncryptInit(this.session.id(), ckMechanism, this.p11Key.keyID);
                break;
            }
            case 2: {
                this.p11.C_DecryptInit(this.session.id(), ckMechanism, this.p11Key.keyID);
                break;
            }
            default: {
                throw new AssertionError((Object)"internal error");
            }
        }
        this.initialized = true;
    }

    private void implUpdate(byte[] in, int inOfs, int inLen) {
        if (inLen == 0 || in == null) {
            return;
        }
        this.buffer.write(in, inOfs, inLen);
    }

    private int implDoFinal(byte[] out, int outOfs, int outLen) throws ShortBufferException, PKCS11Exception, BadPaddingException, IllegalBlockSizeException {
        Session session = this.session;
        try {
            int n;
            this.ensureInitialized();
            byte[] buf = null;
            switch (this.mode) {
                case 1: {
                    n = this.p11.C_Encrypt(session.id(), this.buffer.toByteArray(), 0, this.buffer.size(), out, outOfs, outLen);
                    DerOutputStream dos = new DerOutputStream();
                    buf = new byte[32];
                    System.arraycopy(out, 0, buf, 0, 32);
                    dos.putInteger(new BigInteger(1, buf));
                    Arrays.fill(buf, (byte)0);
                    System.arraycopy(out, 32, buf, 0, 32);
                    dos.putInteger(new BigInteger(1, buf));
                    Arrays.fill(buf, (byte)0);
                    System.arraycopy(out, 64, buf, 0, 32);
                    dos.putOctetString(buf);
                    buf = new byte[n - 96];
                    System.arraycopy(out, 96, buf, 0, n - 96);
                    dos.putOctetString(buf);
                    buf = dos.toByteArray();
                    dos.close();
                    dos = new DerOutputStream();
                    dos.write((byte)48, buf);
                    Arrays.fill(out, (byte)0);
                    buf = dos.toByteArray();
                    System.arraycopy(buf, 0, out, 0, buf.length);
                    n = buf.length;
                    dos.close();
                    buf = null;
                    break;
                }
                case 2: {
                    DerInputStream dis = new DerInputStream(this.buffer.toByteArray());
                    DerValue[] s_in = dis.getSequence(4);
                    byte[] x = P11Util.trimZeroes(s_in[0].getPositiveBigInteger().toByteArray());
                    byte[] y = P11Util.trimZeroes(s_in[1].getPositiveBigInteger().toByteArray());
                    byte[] hash = s_in[2].getOctetString();
                    byte[] data = s_in[3].getOctetString();
                    buf = new byte[96 + data.length];
                    System.arraycopy(x, 0, buf, 32 - x.length, x.length);
                    System.arraycopy(y, 0, buf, 64 - y.length, y.length);
                    System.arraycopy(hash, 0, buf, 64, 32);
                    System.arraycopy(data, 0, buf, 96, data.length);
                    n = this.p11.C_Decrypt(session.id(), buf, 0, buf.length, out, outOfs, outLen);
                    buf = null;
                    break;
                }
                default: {
                    throw new ProviderException("internal error");
                }
            }
            int n2 = n;
            return n2;
        }
        catch (PKCS11Exception e) {
            throw (BadPaddingException)new BadPaddingException("doFinal() failed").initCause(e);
        }
        catch (IOException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
        finally {
            this.initialized = false;
            this.token.releaseSession(session);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.initialized) {
                this.cancelOperation();
                this.closeSession();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void openSession() throws PKCS11Exception {
        if (this.session != null) {
            this.token.releaseSession(this.session);
        }
        try {
            this.session = this.token.getOpSession();
        }
        catch (PKCS11Exception e) {
            this.session = null;
            throw e;
        }
        log.debug((Object)("Open session:" + this.session));
    }

    private void closeSession() throws PKCS11Exception {
        this.token.releaseSession(this.session);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        int n;
        this.implUpdate(input, inputOffset, inputLen);
        byte[] t = new byte[4096];
        try {
            try {
                n = this.implDoFinal(t, 0, t.length);
            }
            catch (ShortBufferException e) {
                throw new BadPaddingException(e.getMessage());
            }
        }
        catch (PKCS11Exception e) {
            throw new BadPaddingException(e.getMessage());
        }
        byte[] out = new byte[n];
        System.arraycopy(t, 0, out, 0, n);
        return out;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.implUpdate(input, inputOffset, inputLen);
        try {
            return this.implDoFinal(output, outputOffset, output.length - outputOffset);
        }
        catch (PKCS11Exception e) {
            throw new BadPaddingException(e.getMessage());
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return inputLen;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.implInit(opmode, key);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.implInit(opmode, key);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.implInit(opmode, key);
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!padding.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException("Padding " + padding + " not supported");
        }
        this.paddingType = 5;
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.implUpdate(input, inputOffset, inputLen);
        return B0;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int n;
        this.implUpdate(input, inputOffset, inputLen);
        int outputSize = this.buffer.size();
        if (outputSize > output.length - outputOffset) {
            throw new ShortBufferException("Need " + outputSize + " bytes for output");
        }
        try {
            n = this.implDoFinal(input, outputOffset, inputLen);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return n;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
    }

    @Deprecated
    public static P11SM2Cipher getInstance(Provider provider0) throws PKCS11Exception {
        TopPKCS11Provider provider = (TopPKCS11Provider)provider0;
        long mechanism = provider.config.getSMConstants().CKM_SM2;
        P11SM2Cipher cipher = new P11SM2Cipher(provider.getToken(), "SM2", mechanism);
        return cipher;
    }

    @Deprecated
    public static P11SM2Cipher getInstance(String transformation, Provider provider) throws PKCS11Exception {
        if (!transformation.startsWith("SM2")) {
            System.err.println("transformation must be SM2");
        }
        if (INSTANCEs.containsKey(provider)) {
            return INSTANCEs.get(provider);
        }
        TopPKCS11Provider _p = (TopPKCS11Provider)provider;
        long mechanism = _p.config.getSMConstants().CKM_SM2;
        P11SM2Cipher cipher = new P11SM2Cipher(_p.getToken(), "SM2", mechanism);
        cipher.provider = provider;
        INSTANCEs.put(provider, cipher);
        return cipher;
    }

    @Deprecated
    public final Provider getProvider() {
        return this.provider;
    }

    @Deprecated
    public final String getAlgorithm() {
        return "SM2";
    }

    @Deprecated
    public final int getBlockSize() {
        return this.engineGetBlockSize();
    }

    @Deprecated
    public final int getOutputSize(int inputLen) {
        return this.engineGetOutputSize(inputLen);
    }

    @Deprecated
    public final byte[] getIV() {
        return this.engineGetIV();
    }

    @Deprecated
    public final AlgorithmParameters getParameters() {
        return this.engineGetParameters();
    }

    @Deprecated
    public final void init(int opmode, Key key) throws InvalidKeyException {
        this.engineInit(opmode, key, null);
    }

    @Deprecated
    public final void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.engineInit(opmode, key, random);
    }

    @Deprecated
    public final void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, params, null);
    }

    @Deprecated
    public final void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, params, random);
    }

    @Deprecated
    public final void init(int opmode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key, params, null);
    }

    @Deprecated
    public final void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, params, random);
    }

    @Deprecated
    public final void init(int opmode, Certificate certificate) throws InvalidKeyException {
        this.init(opmode, certificate, null);
    }

    @Deprecated
    public final void init(int opmode, Certificate certificate, SecureRandom random) throws InvalidKeyException {
        boolean[] keyUsageInfo;
        X509Certificate cert;
        Set<String> critSet;
        if (certificate instanceof X509Certificate && (critSet = (cert = (X509Certificate)certificate).getCriticalExtensionOIDs()) != null && !critSet.isEmpty() && critSet.contains(KEY_USAGE_EXTENSION_OID) && (keyUsageInfo = cert.getKeyUsage()) != null && (opmode == 1 && keyUsageInfo.length > 3 && !keyUsageInfo[3] || opmode == 3 && keyUsageInfo.length > 2 && !keyUsageInfo[2])) {
            throw new InvalidKeyException("Wrong key usage");
        }
        PublicKey publicKey = certificate == null ? null : certificate.getPublicKey();
        this.engineInit(opmode, publicKey, random);
    }

    @Deprecated
    public final byte[] update(byte[] input) {
        if (input == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        if (input.length == 0) {
            return null;
        }
        return this.engineUpdate(input, 0, input.length);
    }

    @Deprecated
    public final byte[] update(byte[] input, int inputOffset, int inputLen) {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return null;
        }
        return this.engineUpdate(input, inputOffset, inputLen);
    }

    @Deprecated
    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output) throws ShortBufferException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return 0;
        }
        return this.engineUpdate(input, inputOffset, inputLen, output, 0);
    }

    @Deprecated
    public final int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0 || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        if (inputLen == 0) {
            return 0;
        }
        return this.engineUpdate(input, inputOffset, inputLen, output, outputOffset);
    }

    @Deprecated
    public final int update(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        if (input == null || output == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (input == output) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (output.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.engineUpdate(input, output);
    }

    @Deprecated
    public final byte[] doFinal() throws IllegalBlockSizeException, BadPaddingException {
        return this.engineDoFinal(B0, 0, 0);
    }

    @Deprecated
    public final int doFinal(byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        if (output == null || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.engineDoFinal(null, 0, 0, output, outputOffset);
    }

    @Deprecated
    public final byte[] doFinal(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        if (input == null) {
            throw new IllegalArgumentException("Null input buffer");
        }
        return this.engineDoFinal(input, 0, input.length);
    }

    @Deprecated
    public final byte[] doFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.engineDoFinal(input, inputOffset, inputLen);
    }

    @Deprecated
    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.engineDoFinal(input, inputOffset, inputLen, output, 0);
    }

    @Deprecated
    public final int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input == null || inputOffset < 0 || inputLen > input.length - inputOffset || inputLen < 0 || outputOffset < 0) {
            throw new IllegalArgumentException("Bad arguments");
        }
        return this.engineDoFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Deprecated
    public final int doFinal(ByteBuffer input, ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (input == null || output == null) {
            throw new IllegalArgumentException("Buffers must not be null");
        }
        if (input == output) {
            throw new IllegalArgumentException("Input and output buffers must not be the same object, consider using buffer.duplicate()");
        }
        if (output.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.engineDoFinal(input, output);
    }

    @Deprecated
    public final byte[] wrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.engineWrap(key);
    }

    @Deprecated
    public final Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        if (wrappedKeyType != 3 && wrappedKeyType != 2 && wrappedKeyType != 1) {
            throw new InvalidParameterException("Invalid key type");
        }
        return this.engineUnwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }
}

