/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.rsa;

import cn.topca.security.util.DerInputStream;
import cn.topca.security.util.DerValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSAKeyUtil {
    public static final int MIN_MODLEN = 512;
    public static final int MAX_MODLEN = 16384;
    public static final int MAX_MODLEN_RESTRICT_EXP = 3072;
    public static final int MAX_RESTRICTED_EXPLEN = 64;
    private static final boolean restrictExpLen = true;

    public static void checkKeyLengths(int modulusLen, BigInteger exponent, int minModulusLen, int maxModulusLen) throws InvalidKeyException {
        if (minModulusLen > 0 && modulusLen < minModulusLen) {
            throw new InvalidKeyException("RSA keys must be at least " + minModulusLen + " bits long");
        }
        int maxLen = Math.min(maxModulusLen, 16384);
        if (modulusLen > maxLen) {
            throw new InvalidKeyException("RSA keys must be no longer than " + maxLen + " bits");
        }
        if (exponent != null && modulusLen > 3072 && exponent.bitLength() > 64) {
            throw new InvalidKeyException("RSA exponents can be no longer than 64 bits  if modulus is greater than 3072 bits");
        }
    }

    public static PrivateKey translatePrivateKey(Key key) {
        try {
            if (key instanceof RSAPrivateKey) {
                return (PrivateKey)key;
            }
            if ("X.509".equals(key.getFormat())) {
                key = KeyFactory.getInstance("RSA").translateKey(key);
                return (PrivateKey)key;
            }
            throw new InvalidKeyException("PublicKey must be instance of RSAPublicKey or have X.509 encoding");
        }
        catch (Exception e) {
            throw new RuntimeException("can not be happend , translate RSAKey fail!", e);
        }
    }

    public static PublicKey translatePublic(Key key) {
        try {
            if (key instanceof RSAPublicKey) {
                return (PublicKey)key;
            }
            if ("X.509".equals(key.getFormat())) {
                key = (PublicKey)KeyFactory.getInstance("RSA").translateKey(key);
                return (PublicKey)key;
            }
            throw new InvalidKeyException("PublicKey must be instance of RSAPublicKey or have X.509 encoding");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("can not be happened, but RSA KeyFactory not support.", e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("can not be happened, but...", e);
        }
    }

    public static PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] encoded = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            PrivateKey privateKey = null;
            try {
                privateKey = RSAKeyUtil.decodePrivate(encoded);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException("decodePrivateKey fail!", e);
            }
            return RSAKeyUtil.translatePrivateKey(privateKey);
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            try {
                return KeyFactory.getInstance("RSA").generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new RuntimeException("can not be happened, but RSA KeyFactory not support.", ex);
            }
        }
        throw new InvalidKeySpecException("Only RSAPrivateKeySpec and PKCS8EncodedKeySpec supported for RSA public keys");
    }

    public static PrivateKey decodePrivate(InputStream in) throws InvalidKeyException {
        try {
            DerValue privateKeyInfo = new DerValue(in);
            if (privateKeyInfo.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            BigInteger version = privateKeyInfo.data.getBigInteger();
            if (!version.equals(BigInteger.ZERO)) {
                throw new IOException("version mismatch: (supported: " + BigInteger.ZERO.toString(16) + ", parsed: " + version.toString(16));
            }
            privateKeyInfo.data.getDerValue();
            DerInputStream key = new DerInputStream(privateKeyInfo.data.getOctetString());
            DerValue derValue = key.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = derValue.data;
            BigInteger v = RSAKeyUtil.readPositiveBigInteger(data);
            BigInteger n = RSAKeyUtil.readPositiveBigInteger(data);
            BigInteger e = RSAKeyUtil.readPositiveBigInteger(data);
            BigInteger d = RSAKeyUtil.readPositiveBigInteger(data);
            BigInteger p = RSAKeyUtil.readPositiveBigInteger(data);
            BigInteger q = RSAKeyUtil.readPositiveBigInteger(data);
            BigInteger pe = RSAKeyUtil.readPositiveBigInteger(data);
            BigInteger qe = RSAKeyUtil.readPositiveBigInteger(data);
            BigInteger coeff = RSAKeyUtil.readPositiveBigInteger(data);
            if (data.available() != 0) {
                throw new InvalidKeyException("Extra key data");
            }
            return RSAKeyUtil.generatePrivateKey(v, n, e, d, p, q, pe, qe, coeff);
        }
        catch (IOException localIOException) {
            throw new InvalidKeyException("IOException: " + localIOException.getMessage());
        }
    }

    public static PrivateKey decodePrivate(byte[] encoded) throws InvalidKeyException {
        return RSAKeyUtil.decodePrivate(new ByteArrayInputStream(encoded));
    }

    public static PrivateKey generatePrivateKey(BigInteger v, BigInteger n, BigInteger e, BigInteger d, BigInteger p, BigInteger q, BigInteger pe, BigInteger qe, BigInteger coeff) throws InvalidKeyException {
        try {
            return RSAKeyUtil.generatePrivate(new RSAPrivateKeySpec(n, d));
        }
        catch (InvalidKeySpecException ex) {
            throw new InvalidKeyException(ex.getMessage(), ex);
        }
    }

    public static PrivateKey generatePrivateKey(BigInteger modulus, BigInteger privateKeyExponent) throws InvalidKeyException {
        return RSAKeyUtil.generatePrivateKey(null, modulus, null, privateKeyExponent, null, null, null, null, null);
    }

    public static PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                byte[] encoded = ((X509EncodedKeySpec)keySpec).getEncoded();
                PublicKey key = RSAKeyUtil.decodePublic(encoded);
                return RSAKeyUtil.translatePublic(key);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Could not create RSA public key", e);
            }
        }
        if (keySpec instanceof RSAPublicKeySpec) {
            try {
                return KeyFactory.getInstance("RSA").generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("can not be happened, but RSA KeyFactory not support.", e);
            }
        }
        throw new InvalidKeySpecException("Only RSAPublicKeySpec and X509EncodedKeySpec supported for RSA public keys");
    }

    public static PublicKey generatePublic(BigInteger modulus, BigInteger exponent) throws InvalidKeyException {
        try {
            return RSAKeyUtil.generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
    }

    public static PublicKey decodePublic(InputStream in) throws InvalidKeyException {
        try {
            DerValue publicKeyInfo = new DerValue(in);
            if (publicKeyInfo.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            publicKeyInfo.data.getDerValue();
            DerInputStream key = new DerInputStream(publicKeyInfo.data.getUnalignedBitString().toByteArray());
            DerValue derValue = key.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = derValue.data;
            BigInteger n = RSAKeyUtil.readPositiveBigInteger(data);
            BigInteger e = RSAKeyUtil.readPositiveBigInteger(data);
            if (publicKeyInfo.data.available() != 0) {
                throw new InvalidKeyException("Extra key data");
            }
            return RSAKeyUtil.generatePublic(n, e);
        }
        catch (IOException localIOException) {
            throw new InvalidKeyException("IOException: " + localIOException.getMessage());
        }
    }

    public static PublicKey decodePublic(byte[] encodedKey) throws InvalidKeyException {
        return RSAKeyUtil.decodePublic(new ByteArrayInputStream(encodedKey));
    }

    private static BigInteger readPositiveBigInteger(DerInputStream in) throws IOException {
        BigInteger bi = in.getBigInteger();
        return bi.signum() < 0 ? new BigInteger(1, bi.toByteArray()) : bi;
    }
}

