/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.ASN1InputStream;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DERInteger;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.DERSet;
import cn.tca.TopBasicCrypto.asn1.pkcs.ContentInfo;
import cn.tca.TopBasicCrypto.asn1.pkcs.PKCSObjectIdentifiers;
import cn.tca.TopBasicCrypto.asn1.pkcs.SignedData;
import cn.tca.TopBasicCrypto.openssl.PEMWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SM2CertPath
extends CertPath {
    static final List<String> certPathEncodings;
    private List<Certificate> certificates;

    private List<Certificate> sortCerts(List<Certificate> certs) {
        int i;
        if (certs.size() < 2) {
            return certs;
        }
        X500Principal issuer = ((X509Certificate)certs.get(0)).getIssuerX500Principal();
        boolean okay = true;
        for (int i2 = 1; i2 != certs.size(); ++i2) {
            X509Certificate cert = (X509Certificate)certs.get(i2);
            if (!issuer.equals(cert.getSubjectX500Principal())) {
                okay = false;
                break;
            }
            issuer = ((X509Certificate)certs.get(i2)).getIssuerX500Principal();
        }
        if (okay) {
            return certs;
        }
        ArrayList<Certificate> retList = new ArrayList<Certificate>(certs.size());
        ArrayList<Certificate> orig = new ArrayList<Certificate>(certs);
        for (i = 0; i < certs.size(); ++i) {
            X509Certificate cert = (X509Certificate)certs.get(i);
            boolean found = false;
            X500Principal subject = cert.getSubjectX500Principal();
            for (int j = 0; j != certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!c.getIssuerX500Principal().equals(subject)) continue;
                found = true;
                break;
            }
            if (found) continue;
            retList.add(cert);
            certs.remove(i);
        }
        if (retList.size() > 1) {
            return orig;
        }
        block3: for (i = 0; i != retList.size(); ++i) {
            issuer = ((X509Certificate)retList.get(i)).getIssuerX500Principal();
            for (int j = 0; j < certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!issuer.equals(c.getSubjectX500Principal())) continue;
                retList.add(c);
                certs.remove(j);
                continue block3;
            }
        }
        if (certs.size() > 0) {
            return orig;
        }
        return retList;
    }

    SM2CertPath(List<Certificate> certificates) {
        super("X.509");
        this.certificates = this.sortCerts(new ArrayList<Certificate>(certificates));
    }

    SM2CertPath(InputStream inStream, String encoding) throws CertificateException {
        block8: {
            super("X.509");
            try {
                if (encoding.equalsIgnoreCase("PkiPath")) {
                    ASN1InputStream derInStream = new ASN1InputStream(inStream);
                    DERObject derObject = derInStream.readObject();
                    if (!(derObject instanceof ASN1Sequence)) {
                        derInStream.close();
                        throw new CertificateException("input stream does not contain a ASN1 SEQUENCE while reading PkiPath encoded data to load CertPath");
                    }
                    Enumeration e = ((ASN1Sequence)derObject).getObjects();
                    this.certificates = new ArrayList<Certificate>();
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "TopSM");
                    while (e.hasMoreElements()) {
                        ASN1Encodable element = (ASN1Encodable)e.nextElement();
                        byte[] encoded = element.getEncoded("DER");
                        this.certificates.add(0, certFactory.generateCertificate(new ByteArrayInputStream(encoded)));
                    }
                    derInStream.close();
                    break block8;
                }
                if (encoding.equalsIgnoreCase("PKCS7") || encoding.equalsIgnoreCase("PEM")) {
                    Certificate cert;
                    inStream = new BufferedInputStream(inStream);
                    this.certificates = new ArrayList<Certificate>();
                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509", "TopSM");
                    while ((cert = certFactory.generateCertificate(inStream)) != null) {
                        this.certificates.add(cert);
                    }
                    break block8;
                }
                throw new CertificateException("unsupported encoding: " + encoding);
            }
            catch (IOException ex) {
                throw new CertificateException("IOException throw while decoding CertPath:\n" + ex.toString());
            }
            catch (NoSuchProviderException ex) {
                throw new CertificateException("BouncyCastle provider not found while trying to get a CertificateFactory:\n" + ex.toString());
            }
        }
        this.certificates = this.sortCerts(this.certificates);
    }

    @Override
    public Iterator<String> getEncodings() {
        return certPathEncodings.iterator();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        String enc;
        Iterator<String> iter = this.getEncodings();
        if (iter.hasNext() && (enc = iter.next()) instanceof String) {
            return this.getEncoded(enc);
        }
        return null;
    }

    @Override
    public byte[] getEncoded(String encoding) throws CertificateEncodingException {
        if (encoding.equalsIgnoreCase("PkiPath")) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            ListIterator<Certificate> iter = this.certificates.listIterator(this.certificates.size());
            while (iter.hasPrevious()) {
                v.add(this.toASN1Object((X509Certificate)iter.previous()));
            }
            return this.toDEREncoded(new DERSequence(v));
        }
        if (encoding.equalsIgnoreCase("PKCS7")) {
            ContentInfo encInfo = new ContentInfo(PKCSObjectIdentifiers.data, null);
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i != this.certificates.size(); ++i) {
                v.add(this.toASN1Object((X509Certificate)this.certificates.get(i)));
            }
            SignedData sd = new SignedData(new DERInteger(1), new DERSet(), encInfo, new DERSet(v), null, new DERSet());
            return this.toDEREncoded(new ContentInfo(PKCSObjectIdentifiers.signedData, sd));
        }
        if (encoding.equalsIgnoreCase("PEM")) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            PEMWriter pWrt = new PEMWriter(new OutputStreamWriter(bOut));
            try {
                for (int i = 0; i != this.certificates.size(); ++i) {
                    pWrt.writeObject(this.certificates.get(i));
                }
                pWrt.close();
            }
            catch (Exception e) {
                throw new CertificateEncodingException("can't encode certificate for PEM encoded path");
            }
            return bOut.toByteArray();
        }
        throw new CertificateEncodingException("unsupported encoding: " + encoding);
    }

    public List<Certificate> getCertificates() {
        return Collections.unmodifiableList(new ArrayList<Certificate>(this.certificates));
    }

    private DERObject toASN1Object(X509Certificate cert) throws CertificateEncodingException {
        try {
            return new ASN1InputStream(cert.getEncoded()).readObject();
        }
        catch (Exception e) {
            throw new CertificateEncodingException("Exception while encoding certificate: " + e.toString());
        }
    }

    private byte[] toDEREncoded(ASN1Encodable obj) throws CertificateEncodingException {
        try {
            return obj.getEncoded("DER");
        }
        catch (IOException e) {
            throw new CertificateEncodingException("Exception thrown: " + e);
        }
    }

    static {
        ArrayList<String> encodings = new ArrayList<String>();
        encodings.add("PkiPath");
        encodings.add("PEM");
        encodings.add("PKCS7");
        certPathEncodings = Collections.unmodifiableList(encodings);
    }
}

