/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.ec.ECParameters;
import cn.topca.security.ec.ECUtil;
import cn.topca.security.ec.NamedCurve;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;

public final class SM2Core {
    protected static final ECParameterSpec sm2Curve = NamedCurve.getECParameterSpec("SM2");
    private ECPoint c1Point;
    private ECPoint encKeyBasePoint;
    private byte[] p2X;
    private byte[] p2Y;

    protected SM2Core(ECPublicKey publicKey) {
        do {
            BigInteger k = ECUtil.getRandomMultiple(sm2Curve);
            this.c1Point = ECUtil.getECPoint(sm2Curve, k);
            this.encKeyBasePoint = ECUtil.multiply(sm2Curve.getCurve(), publicKey.getW(), k);
            this.p2X = ECParameters.trimZeroes(this.encKeyBasePoint.getAffineX().toByteArray());
            this.p2Y = ECParameters.trimZeroes(this.encKeyBasePoint.getAffineY().toByteArray());
        } while (this.p2X.length < 32 || this.p2Y.length < 32);
    }

    protected SM2Core(ECPoint c1Point, ECPrivateKey privateKey) {
        this.c1Point = c1Point;
        this.encKeyBasePoint = ECUtil.multiply(sm2Curve.getCurve(), c1Point, privateKey.getS());
        this.p2X = ECParameters.trimZeroes(this.encKeyBasePoint.getAffineX().toByteArray());
        this.p2Y = ECParameters.trimZeroes(this.encKeyBasePoint.getAffineY().toByteArray());
    }

    protected ECPoint c1Point() {
        return this.c1Point;
    }

    protected ECPoint getEncKeyBasePoint() {
        return this.encKeyBasePoint;
    }

    protected byte[] c3Hash(byte[] data) {
        MessageDigest sm3c3 = null;
        try {
            sm3c3 = MessageDigest.getInstance("SM3");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        sm3c3.update(this.p2X);
        sm3c3.update(data);
        sm3c3.update(this.p2Y);
        return sm3c3.digest();
    }

    protected byte[] c2Data(byte[] origin) {
        byte[] _data = (byte[])origin.clone();
        int ct = 1;
        byte[] maskKey = this._nextkey(ct++);
        int i = 0;
        int keyOff = 0;
        while (i < _data.length) {
            if (keyOff == maskKey.length) {
                maskKey = this._nextkey(ct++);
                keyOff = 0;
            }
            int n = i++;
            _data[n] = (byte)(_data[n] ^ maskKey[keyOff]);
            ++keyOff;
        }
        return _data;
    }

    private byte[] _nextkey(int ct) {
        MessageDigest maskKeyGen = null;
        try {
            maskKeyGen = MessageDigest.getInstance("SM3");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        maskKeyGen.update(this.p2X);
        maskKeyGen.update(this.p2Y);
        maskKeyGen.update((byte)(ct >> 24 & 0xFF));
        maskKeyGen.update((byte)(ct >> 16 & 0xFF));
        maskKeyGen.update((byte)(ct >> 8 & 0xFF));
        maskKeyGen.update((byte)(ct & 0xFF));
        byte[] key = maskKeyGen.digest();
        return key;
    }
}

