/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.sm.SM2PrivateKey;
import cn.topca.security.sm.SM2PublicKey;
import cn.topca.security.sm.TopSMProvider;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SM2KeyFactory
extends KeyFactorySpi {
    public static final KeyFactory INSTANCE;
    public static final Provider sm2InternalProvider;

    public static ECKey toSM2Key(Key paramKey) throws InvalidKeyException {
        if (paramKey instanceof ECKey) {
            ECKey sm2Key = (ECKey)((Object)paramKey);
            SM2KeyFactory.checkKey(sm2Key);
            return sm2Key;
        }
        return (ECKey)((Object)INSTANCE.translateKey(paramKey));
    }

    private static void checkKey(ECKey ecKey) throws InvalidKeyException {
        String keyAlg;
        if (ecKey instanceof ECPublicKey) {
            if (ecKey instanceof SM2PublicKey) {
                return;
            }
        } else if (ecKey instanceof ECPrivateKey) {
            if (ecKey instanceof SM2PrivateKey) {
                return;
            }
        } else {
            throw new InvalidKeyException("Neither a public nor a private key");
        }
        if (!(keyAlg = ((Key)((Object)ecKey)).getAlgorithm()).equals("SM2")) {
            throw new InvalidKeyException("Not an SM2 key: " + keyAlg);
        }
    }

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        String keyAlg = key.getAlgorithm();
        if (!keyAlg.equals("SM2")) {
            throw new InvalidKeyException("Not an SM2 key: " + keyAlg);
        }
        if (key instanceof PublicKey) {
            try {
                return this.implTranslatePublicKey((PublicKey)key);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidKeyException(e);
            }
        }
        if (key instanceof PrivateKey) {
            return this.implTranslatePrivateKey((PrivateKey)key);
        }
        throw new InvalidKeyException("Neither a public nor a private key");
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.implGeneratePublic(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            return this.implGeneratePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    private PublicKey implTranslatePublicKey(PublicKey key) throws InvalidKeyException, InvalidParameterSpecException {
        if (key instanceof ECPublicKey) {
            if (key instanceof SM2PublicKey) {
                return key;
            }
            ECPublicKey ecKey = (ECPublicKey)key;
            return new SM2PublicKey(ecKey.getW(), ecKey.getParams());
        }
        if ("X.509".equals(key.getFormat())) {
            byte[] publicKeyBuf = key.getEncoded();
            return new SM2PublicKey(publicKeyBuf);
        }
        throw new InvalidKeyException("Public keys must be instance of ECPublicKey or have X.509 encoding");
    }

    private PrivateKey implTranslatePrivateKey(PrivateKey key) throws InvalidKeyException {
        if (key instanceof ECPrivateKey) {
            if (key instanceof SM2PrivateKey) {
                return key;
            }
            ECPrivateKey ecKey = (ECPrivateKey)key;
            try {
                return new SM2PrivateKey(ecKey.getS(), null, ecKey.getParams());
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidKeyException(e);
            }
        }
        if ("PKCS#8".equals(key.getFormat())) {
            return new SM2PrivateKey(key.getEncoded());
        }
        throw new InvalidKeyException("Private keys must be instance of ECPrivateKey or have PKCS#8 encoding");
    }

    private PublicKey implGeneratePublic(KeySpec keySpec) throws GeneralSecurityException {
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509Spec = (X509EncodedKeySpec)keySpec;
            return new SM2PublicKey(x509Spec.getEncoded());
        }
        if (keySpec instanceof ECPublicKeySpec) {
            ECPublicKeySpec ecSpec = (ECPublicKeySpec)keySpec;
            return new SM2PublicKey(ecSpec.getW(), ecSpec.getParams());
        }
        throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for SM2 public keys");
    }

    private PrivateKey implGeneratePrivate(KeySpec keySpec) throws GeneralSecurityException {
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pkcsSpec = (PKCS8EncodedKeySpec)keySpec;
            return new SM2PrivateKey(pkcsSpec.getEncoded());
        }
        if (keySpec instanceof ECPrivateKeySpec) {
            ECPrivateKeySpec ecSpce = (ECPrivateKeySpec)keySpec;
            return new SM2PrivateKey(ecSpce.getS(), null, ecSpce.getParams());
        }
        throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
    }

    @Override
    protected <T extends KeySpec> T engineGetKeySpec(Key key, Class<T> keySpce) throws InvalidKeySpecException {
        try {
            key = this.engineTranslateKey(key);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException(e);
        }
        if (key instanceof ECPublicKey) {
            ECPublicKey ecKey = (ECPublicKey)key;
            if (ECPublicKeySpec.class.isAssignableFrom(keySpce)) {
                return (T)new ECPublicKeySpec(ecKey.getW(), ecKey.getParams());
            }
            if (X509EncodedKeySpec.class.isAssignableFrom(keySpce)) {
                return (T)new X509EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("KeySpec must be ECPublicKeySpec or X509EncodedKeySpec for EC public keys");
        }
        if (key instanceof ECPrivateKey) {
            if (PKCS8EncodedKeySpec.class.isAssignableFrom(keySpce)) {
                return (T)new PKCS8EncodedKeySpec(key.getEncoded());
            }
            if (ECPrivateKeySpec.class.isAssignableFrom(keySpce)) {
                ECPrivateKey ecKey = (ECPrivateKey)key;
                return (T)new ECPrivateKeySpec(ecKey.getS(), ecKey.getParams());
            }
            throw new InvalidKeySpecException("KeySpec must be ECPrivateKeySpec or PKCS8EncodedKeySpec for EC private keys");
        }
        throw new InvalidKeySpecException("Neither public nor private key");
    }

    static {
        TopSMProvider provider = TopSMProvider.INSTANCE;
        try {
            INSTANCE = KeyFactory.getInstance("SM2", provider);
        }
        catch (NoSuchAlgorithmException localNoSuchAlgorithmException) {
            throw new RuntimeException(localNoSuchAlgorithmException);
        }
        sm2InternalProvider = provider;
    }
}

