/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.tca.TopBasicCrypto.asn1.DERBitString;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import cn.topca.security.ec.ECParameters;
import cn.topca.security.ec.ECUtil;
import cn.topca.security.ec.NamedCurve;
import cn.topca.security.pkcs.PKCS8Key;
import cn.topca.security.sm.SM2AlgorithmId;
import cn.topca.security.sm.SM2Core;
import cn.topca.security.sm.SM2PublicKey;
import cn.topca.security.util.DerInputStream;
import cn.topca.security.util.DerOutputStream;
import cn.topca.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;
import org.apache.commons.codec.binary.Hex;

public final class SM2PrivateKey
extends PKCS8Key
implements ECPrivateKey {
    private static final long serialVersionUID = 88695385615075129L;
    private BigInteger s;
    private ECParameterSpec sm2Curve = null;
    private ECPoint w;

    public SM2PrivateKey(byte[] encoded) throws InvalidKeyException {
        this.decode(encoded);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SM2PrivateKey(BigInteger s, ECPoint w, ECParameterSpec params) throws InvalidKeyException, InvalidParameterSpecException {
        this.s = s;
        if (params != null && !params.equals(SM2Core.sm2Curve)) {
            if (!params.toString().matches(".*SM2.*")) throw new InvalidParameterSpecException("need SM2 params, but " + Hex.encodeHexString(ECParameters.encodeParameters(params)));
            this.sm2Curve = params;
        } else {
            this.sm2Curve = SM2Core.sm2Curve;
        }
        this.algid = SM2AlgorithmId.INSTANCE;
        DerOutputStream out = null;
        try {
            SM2PublicKey pubKey;
            out = new DerOutputStream();
            out.putInteger(1);
            byte[] sb = ECParameters.trimZeroes(s.toByteArray());
            out.putInteger(s);
            ECPoint _w = this.getW();
            if (_w == null) {
                _w = ECUtil.getECPoint(this.sm2Curve, this.getS());
            }
            if ((pubKey = new SM2PublicKey(_w, this.getParams())) != null) {
                out.write(new DERTaggedObject(1, new DERBitString(pubKey.getSM2Key())).getDEREncoded());
            }
            DerValue seq = new DerValue(48, out.toByteArray());
            this.key = seq.toByteArray();
        }
        catch (IOException e) {
            throw new InvalidKeyException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (w == null && s != null) {
            w = ECUtil.getECPoint(this.sm2Curve, s);
        }
        this.w = w;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public BigInteger getS() {
        return this.s;
    }

    public ECPoint getW() {
        return this.w;
    }

    public ECParameterSpec getParams() {
        return this.sm2Curve;
    }

    public byte[] getEncodedPrivateValue() {
        return (byte[])this.key.clone();
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            DerValue derValue = in.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = derValue.data;
            int version = data.getInteger();
            if (version != 1) {
                throw new IOException("Version must be 1");
            }
            DerValue v = data.getDerValue();
            try {
                this.s = v.getBigInteger();
            }
            catch (Exception e) {
                byte[] privData = v.getOctetString();
                this.s = new BigInteger(1, privData);
            }
            while (data.available() != 0) {
                DerValue value = data.getDerValue();
                if (value.isContextSpecific((byte)0)) continue;
                if (value.isContextSpecific((byte)1)) {
                    byte[] publicKeyBuf = value.getData().getDerValue().getBitString();
                    this.w = new SM2PublicKey(publicKeyBuf).getW();
                    continue;
                }
                throw new InvalidKeyException("Unexpected value: " + value);
            }
            this.sm2Curve = SM2Core.sm2Curve;
            if (this.s != null && this.w == null) {
                this.w = ECUtil.getECPoint(this.sm2Curve, this.s);
            }
        }
        catch (IOException e) {
            throw new InvalidKeyException("Invalid SM2 private key", e);
        }
    }

    public String toString() {
        return "Top SM2 private key, " + this.sm2Curve.getCurve().getField().getFieldSize() + " bits\n  private value:  " + this.s + "\n  parameters: " + this.sm2Curve;
    }

    protected static final SM2PrivateKey getTestKey() throws InvalidKeyException, InvalidParameterSpecException {
        BigInteger s = new BigInteger("128B2FA8BD433C6C068C8D803DFF79792A519A55171B1B650C23661D15897263", 16);
        BigInteger x = new BigInteger("0AE4C7798AA0F119471BEE11825BE46202BB79E2A5844495E97C04FF4DF2548A", 16);
        BigInteger y = new BigInteger("7C0240F88F1CD4E16352A73C17B7F16F07353E53A176D684A9FE0C6BB798E857", 16);
        ECPoint point = new ECPoint(x, y);
        ECParameterSpec params = NamedCurve.getECParameterSpec("SM2Test1");
        return new SM2PrivateKey(s, point, params);
    }
}

