/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.sm;

import cn.topca.security.ec.ECParameters;
import cn.topca.security.ec.NamedCurve;
import cn.topca.security.sm.SM2AlgorithmId;
import cn.topca.security.sm.SM2Core;
import cn.topca.security.x509.X509Key;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidParameterSpecException;
import org.apache.commons.codec.binary.Hex;

public final class SM2PublicKey
extends X509Key
implements ECPublicKey {
    private ECPoint w;
    private ECParameterSpec sm2Curve = SM2Core.sm2Curve;

    public SM2PublicKey(ECPoint point, ECParameterSpec params) throws InvalidKeyException, InvalidParameterSpecException {
        this.w = point;
        if (params != null && !params.equals(SM2Core.sm2Curve)) {
            if (params.toString().matches(".*SM2.*")) {
                this.sm2Curve = params;
            } else {
                throw new InvalidParameterSpecException("need SM2 params, but " + Hex.encodeHexString(ECParameters.encodeParameters(params)));
            }
        }
        this.algid = SM2AlgorithmId.INSTANCE;
        this.key = ECParameters.encodePoint(point, params.getCurve());
    }

    public SM2PublicKey(byte[] encoded) throws InvalidKeyException {
        if (encoded[0] == 4) {
            this.key = encoded;
            this.algid = SM2AlgorithmId.INSTANCE;
            this.parseKeyBits();
        } else {
            this.decode(encoded);
        }
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public ECPoint getW() {
        return this.w;
    }

    public ECParameterSpec getParams() {
        return this.sm2Curve;
    }

    public byte[] getSM2Key() {
        return (byte[])this.key.clone();
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            this.w = ECParameters.decodePoint(this.key, this.sm2Curve.getCurve());
        }
        catch (IOException localIOException) {
            throw new InvalidKeyException("Invalid SM2 key", localIOException);
        }
    }

    public String toString() {
        return "Top SM2 public key, " + this.sm2Curve.getCurve().getField().getFieldSize() + " bits\n  public x coord: " + this.w.getAffineX() + "\n  public y coord: " + this.w.getAffineY() + "\n  parameters: " + this.sm2Curve;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    protected static final SM2PublicKey getTestKey() throws InvalidKeyException, InvalidParameterSpecException {
        BigInteger x = new BigInteger("0AE4C7798AA0F119471BEE11825BE46202BB79E2A5844495E97C04FF4DF2548A", 16);
        BigInteger y = new BigInteger("7C0240F88F1CD4E16352A73C17B7F16F07353E53A176D684A9FE0C6BB798E857", 16);
        ECPoint point = new ECPoint(x, y);
        ECParameterSpec params = NamedCurve.getECParameterSpec("SM2Test1");
        return new SM2PublicKey(point, params);
    }
}

