/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.util;

import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.x500.X500Name;
import cn.tca.TopBasicCrypto.asn1.x509.SubjectPublicKeyInfo;
import cn.tca.TopBasicCrypto.cert.X509CertificateHolder;
import cn.tca.TopBasicCrypto.cert.X509v3CertificateBuilder;
import cn.tca.TopBasicCrypto.jce.PKCS10CertificationRequest;
import cn.tca.TopBasicCrypto.openssl.PEMWriter;
import cn.tca.TopBasicCrypto.operator.ContentSigner;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.tca.TopBasicCrypto.pkcs.PKCS10CertificationRequestBuilder;
import cn.tca.TopBasicCrypto.pkcs.PKCS10CertificationRequestHolder;
import cn.tca.TopBasicCrypto.util.encoders.Base64;
import cn.topca.security.bc.operator.JcaContentSignerBuilder;
import cn.topca.security.bc.operator.NullContentSigner;
import cn.topca.security.util.BCUtil;
import cn.topca.security.util.NoMatchingException;
import cn.topca.security.x509.AlgorithmId;
import cn.topca.security.x509.X509Name;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;

public class CertUtil {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";

    public static CRL getCRL(String crlUrl) throws CertificateException, CRLException, IOException {
        URL crlURL = null;
        try {
            crlURL = new URL(crlUrl);
        }
        catch (MalformedURLException e) {
            String message = e.getMessage();
            if (message.indexOf("unknown protocol") >= 0) {
                crlURL = new URL("File:///".concat(crlUrl));
            }
            throw e;
        }
        CRL crl = CertUtil.convertCRL(crlURL.openConnection().getInputStream());
        return crl;
    }

    public static String matchSubject(Certificate certificate, String regex, int groupIndex) throws NoMatchingException {
        X509Certificate x509cert = (X509Certificate)certificate;
        Pattern p = Pattern.compile(regex);
        Matcher match = p.matcher(x509cert.getSubjectDN().getName());
        if (match.find()) {
            return match.group(groupIndex);
        }
        throw new NoMatchingException("No matching from the certificate. @SerialNumber: ".concat(x509cert.getSerialNumber().toString(16)));
    }

    public static String[] matchSubject(Certificate certificate, String regex) throws NoMatchingException {
        X509Certificate x509cert = (X509Certificate)certificate;
        Pattern p = Pattern.compile(regex);
        Matcher match = p.matcher(x509cert.getSubjectDN().getName());
        if (match.find()) {
            int count = match.groupCount();
            if (count > 0) {
                String[] matches = new String[count];
                for (int i = 0; i < count; ++i) {
                    matches[i] = match.group(i);
                }
                return matches;
            }
            return null;
        }
        throw new NoMatchingException("No matching from the certificate. @SerialNumber: ".concat(x509cert.getSerialNumber().toString(16)));
    }

    public static Certificate convertCertificate(String certificatePEMBuffer) throws CertificateException, IOException {
        if (certificatePEMBuffer.contains(BEGIN_CERT)) {
            certificatePEMBuffer = certificatePEMBuffer.substring(BEGIN_CERT.length(), certificatePEMBuffer.indexOf(END_CERT));
        }
        certificatePEMBuffer = certificatePEMBuffer.replaceAll("\\s", "");
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode(certificatePEMBuffer));
        return CertUtil.convertCertificate(bais);
    }

    public static Certificate convertCertificate(File certFile) throws CertificateException, IOException {
        return CertUtil.convertCertificate(new FileInputStream(certFile));
    }

    public static Certificate convertCertificate(byte[] derBuf) throws CertificateException, IOException {
        return CertUtil.convertCertificate(new ByteArrayInputStream(derBuf));
    }

    public static BigInteger convertCertSerialnumber(String serialnumber) {
        return new BigInteger(serialnumber.replaceAll("[^0-9|^a-f|^A-F]", ""), 16);
    }

    public static void storeCert(Certificate cert, boolean pem, PrintStream out) throws IOException, CertificateException {
        pem = false;
        if (false) {
            out.println(BEGIN_CERT);
            Base64.encode(cert.getEncoded(), out);
            out.println(END_CERT);
        } else {
            out.write(cert.getEncoded());
        }
    }

    public static Certificate convertCertificate(InputStream in) throws CertificateException {
        CertificateFactory cf;
        try {
            cf = CertificateFactory.getInstance("X509", "TopSM");
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            cf = CertificateFactory.getInstance("X509");
        }
        return cf.generateCertificate(in);
    }

    public static Certificate[] convertCertChain(InputStream in) throws CertificateException {
        CertificateFactory cf;
        try {
            cf = CertificateFactory.getInstance("X509", "TopSM");
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            cf = CertificateFactory.getInstance("X509");
        }
        Collection<? extends Certificate> c = cf.generateCertificates(in);
        return c.toArray(new Certificate[c.size() - 1]);
    }

    public static CRL convertCRL(InputStream in) throws CRLException, CertificateException {
        CertificateFactory cf;
        try {
            cf = CertificateFactory.getInstance("X509", "TopSM");
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            cf = CertificateFactory.getInstance("X509");
        }
        return cf.generateCRL(in);
    }

    public static void genCSR(String subjectName, KeyPair keypair, String sigAlgName, Writer out, Provider provider) throws IOException {
        try {
            CertUtil.genCSR(new X509Name(subjectName), keypair, sigAlgName, out, provider);
        }
        catch (OperatorCreationException e) {
            e.printStackTrace();
        }
    }

    public static void genCSR(X509Name subjectName, KeyPair keypair, String sigAlgName, Writer out, Provider provider) throws OperatorCreationException, IOException {
        PublicKey publicKey = keypair.getPublic();
        PrivateKey privateKey = keypair.getPrivate();
        SubjectPublicKeyInfo publicKeyInfo = null;
        String signatureAlgorithm = sigAlgName;
        if (signatureAlgorithm == null) {
            signatureAlgorithm = publicKey.getAlgorithm().equals("SM2") ? "SM3withSM2" : "SHA1with" + publicKey.getAlgorithm();
        }
        publicKeyInfo = new SubjectPublicKeyInfo(DERSequence.getInstance(publicKey.getEncoded()));
        X500Name subject = BCUtil.toX500Name(subjectName);
        PKCS10CertificationRequestBuilder csrBuilder = new PKCS10CertificationRequestBuilder(subject, publicKeyInfo);
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).setProvider(provider).build(privateKey);
        PKCS10CertificationRequestHolder holder = csrBuilder.build(signer);
        PEMWriter writer = new PEMWriter(out);
        PKCS10CertificationRequest csr = new PKCS10CertificationRequest(holder.getEncoded());
        writer.writeObject(csr);
        writer.flush();
    }

    public static Certificate wrapToCertContainer(PublicKey publicKey) {
        byte[] keyBuffer = publicKey.getEncoded();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] publicKeyHash = md.digest(keyBuffer);
        BigInteger serialnumber = new BigInteger(publicKeyHash);
        String subjectDN = "CN={SHA1}" + Hex.encodeHexString(publicKeyHash) + ", OU=R&D Center, O=TopCA";
        String issureDN = "CN=PublicKey Container, OU=R&D Center, O=TopCA";
        X509Name subject = new X509Name(subjectDN);
        X509Name issuer = new X509Name(issureDN);
        Date notBefore = new Date();
        long year = 1471228928L;
        Date notAfter = new Date(notBefore.getTime() + 10L * year);
        byte[] certBuf = null;
        certBuf = CertUtil.genCert(serialnumber, subject, notBefore, notAfter, issuer, publicKey, null, null);
        try {
            return CertUtil.convertCertificate(certBuf);
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] genSelfSignCert(KeyPair keypair) {
        PublicKey subjectPublicKey = keypair.getPublic();
        byte[] keyBuffer = subjectPublicKey.getEncoded();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] publicKeyHash = md.digest(keyBuffer);
        BigInteger serialnumber = new BigInteger(publicKeyHash);
        String subjectDN = "CN={SHA1}" + Hex.encodeHexString(publicKeyHash) + ", OU=R&D Center, O=TopCA";
        return CertUtil.genSelfSignCert(serialnumber, subjectDN, keypair, null);
    }

    public static byte[] genSelfSignCert(BigInteger serialnumber, String subjectDN, KeyPair keypair) {
        return CertUtil.genSelfSignCert(serialnumber, subjectDN, keypair, null);
    }

    public static byte[] genSelfSignCert(BigInteger serialnumber, String subjectDN, KeyPair keypair, String provider) {
        PublicKey subjectPublicKey = keypair.getPublic();
        PrivateKey issuerPrivateKey = keypair.getPrivate();
        String issuerDN = subjectDN;
        X509Name subjectName = new X509Name(subjectDN);
        X509Name issuerName = new X509Name(issuerDN);
        Date notBefore = new Date();
        long year = 1471228928L;
        Date notAfter = new Date(notBefore.getTime() + 10L * year);
        byte[] certBuf = null;
        certBuf = CertUtil.genCert(serialnumber, subjectName, notBefore, notAfter, issuerName, subjectPublicKey, issuerPrivateKey, provider);
        return certBuf;
    }

    public static final byte[] genCert(BigInteger serialnumber, X509Name subjectDN, Date notBefore, Date notAfter, X509Name issuerDN, PublicKey subjectPublicKey, PrivateKey issuerPrivateKey, String provider) {
        AlgorithmId keyAlgId;
        String keyAlg;
        try {
            keyAlg = AlgorithmId.get(subjectPublicKey.getAlgorithm()).getOID().toString();
        }
        catch (NoSuchAlgorithmException e) {
            keyAlg = subjectPublicKey.getAlgorithm();
        }
        try {
            keyAlgId = AlgorithmId.get(keyAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        String sigAlg = null;
        sigAlg = keyAlgId.getName().equals("SM2") ? "SM3withSM2" : "SHA1with" + keyAlgId.getName();
        SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(ASN1Sequence.getInstance(subjectPublicKey.getEncoded()));
        X500Name subject = BCUtil.toX500Name(subjectDN);
        X500Name issuer = BCUtil.toX500Name(issuerDN);
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuer, serialnumber, notBefore, notAfter, subject, publicKeyInfo);
        ContentSigner signer = null;
        try {
            signer = issuerPrivateKey != null ? new JcaContentSignerBuilder(sigAlg).setProvider(provider).build(issuerPrivateKey) : NullContentSigner.getInstance();
        }
        catch (OperatorCreationException e1) {
            e1.printStackTrace();
        }
        X509CertificateHolder certHolder = certBuilder.build(signer);
        byte[] certBuf = null;
        try {
            certBuf = certHolder.getEncoded();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return certBuf;
    }
}

