/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.x509;

import cn.tca.TopBasicCrypto.asn1.ASN1EncodableVector;
import cn.tca.TopBasicCrypto.asn1.DERBitString;
import cn.tca.TopBasicCrypto.asn1.DERSequence;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.asn1.x509.TBSCertificateStructure;
import cn.tca.TopBasicCrypto.asn1.x509.X509CertificateStructure;
import cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider;
import cn.tca.TopBasicCrypto.jce.provider.X509CertificateObject;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;

public class X509CertificaateGenerator {
    public static Certificate generator(TBSCertificateStructure v3TBSCertificate, AlgorithmIdentifier algSign, byte[] v3TBSCertSignature) throws CertificateParsingException {
        if (v3TBSCertificate.getSubjectPublicKeyInfo().getAlgorithmId().getAlgorithm().getId().equals("1.2.156.10197.1.301")) {
            algSign = new AlgorithmIdentifier("1.2.156.10197.1.501");
        }
        ASN1EncodableVector asn1encodablevector = new ASN1EncodableVector();
        asn1encodablevector.add(v3TBSCertificate);
        asn1encodablevector.add(algSign);
        asn1encodablevector.add(new DERBitString(v3TBSCertSignature));
        return new X509CertificateObject(new X509CertificateStructure(new DERSequence(asn1encodablevector)));
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

