/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.x509;

import cn.topca.security.x509.X509Extension;
import cn.topca.security.x509.X509ExtensionIdentifier;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509Extensions
implements java.security.cert.X509Extension {
    private ConcurrentHashMap<String, X509Extension> criticalExtns;
    private ConcurrentHashMap<String, X509Extension> nonCriticalExtns;
    private static final Set<String> EMPTY_SET = new HashSet<String>(0);
    private boolean hasUnsupportedCriticalExtension = false;

    public void add(String extnOID, byte[] extnValue, boolean critical) throws IOException {
        this.add(new X509Extension(new X509ExtensionIdentifier(extnOID), extnValue, critical));
    }

    public void add(X509ExtensionIdentifier extnID, byte[] extnValue, boolean critical) {
        this.add(new X509Extension(extnID, extnValue, critical));
    }

    public void add(X509Extension extn) {
        if (extn.isCritical()) {
            if (this.criticalExtns == null) {
                this.criticalExtns = new ConcurrentHashMap();
            }
            this.criticalExtns.put(extn.getExtnID().toString(), extn);
        } else {
            if (this.nonCriticalExtns == null) {
                this.nonCriticalExtns = new ConcurrentHashMap();
            }
            this.nonCriticalExtns.put(extn.getExtnID().toString(), extn);
        }
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.criticalExtns != null) {
            return this.criticalExtns.keySet();
        }
        return EMPTY_SET;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        if (this.criticalExtns != null && this.criticalExtns.contains(oid)) {
            return this.criticalExtns.get(oid).getExtnValue();
        }
        if (this.nonCriticalExtns != null && this.nonCriticalExtns.contains(oid)) {
            return this.nonCriticalExtns.get(oid).getExtnValue();
        }
        return null;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.nonCriticalExtns != null) {
            return this.nonCriticalExtns.keySet();
        }
        return EMPTY_SET;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.hasUnsupportedCriticalExtension;
    }

    public void hasUnsupportedCriticalExtension(boolean unsupported) {
        this.hasUnsupportedCriticalExtension = unsupported;
    }
}

