/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.x509;

import cn.topca.security.util.X500NameTokenizer;
import java.util.ArrayList;

public class X509Name {
    private AttributeTypeAndValue[] attrs;
    private static final AttributeTypeAndValue[] A0 = new AttributeTypeAndValue[0];

    public X509Name(AttributeTypeAndValue[] attrs) {
        this.attrs = attrs;
    }

    public X509Name(String subjectName) {
        this.attrs = X509Name.attrsFromString(subjectName);
    }

    public AttributeTypeAndValue[] getAttributeTypeAndValues() {
        return this.attrs;
    }

    private static AttributeTypeAndValue[] attrsFromString(String name) {
        ArrayList<AttributeTypeAndValue> attrs = new ArrayList<AttributeTypeAndValue>();
        X500NameTokenizer nTok = new X500NameTokenizer(name);
        while (nTok.hasMoreTokens()) {
            String token = nTok.nextToken();
            int index = token.indexOf(61);
            if (index == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String attr = token.substring(0, index);
            String value = token.substring(index + 1);
            if (value.indexOf(43) > 0) {
                X500NameTokenizer vTok = new X500NameTokenizer(value, '+');
                String v = vTok.nextToken();
                AttributeTypeAndValue.AttributeValueType attrValueType = AttributeTypeAndValue.AttributeValueType.UTF8;
                if (attr.matches("C")) {
                    attrValueType = AttributeTypeAndValue.AttributeValueType.PRINTABLE;
                } else if (attr.matches("E")) {
                    attrValueType = AttributeTypeAndValue.AttributeValueType.IA5;
                } else if (attr.matches("Emailaddress")) {
                    attrValueType = AttributeTypeAndValue.AttributeValueType.IA5;
                }
                attrs.add(new AttributeTypeAndValue(attr, v, attrValueType));
                while (vTok.hasMoreTokens()) {
                    String sv = vTok.nextToken();
                    int ndx = sv.indexOf(61);
                    String nm = sv.substring(0, ndx);
                    String vl = sv.substring(ndx + 1);
                    attrValueType = AttributeTypeAndValue.AttributeValueType.UTF8;
                    if (attr.matches("C")) {
                        attrValueType = AttributeTypeAndValue.AttributeValueType.PRINTABLE;
                    } else if (attr.matches("E")) {
                        attrValueType = AttributeTypeAndValue.AttributeValueType.IA5;
                    } else if (attr.matches("Emailaddress")) {
                        attrValueType = AttributeTypeAndValue.AttributeValueType.IA5;
                    }
                    attrs.add(new AttributeTypeAndValue(nm, vl, attrValueType));
                }
                continue;
            }
            AttributeTypeAndValue.AttributeValueType attrValueType = AttributeTypeAndValue.AttributeValueType.UTF8;
            if (attr.matches("C")) {
                attrValueType = AttributeTypeAndValue.AttributeValueType.PRINTABLE;
            } else if (attr.matches("E")) {
                attrValueType = AttributeTypeAndValue.AttributeValueType.IA5;
            } else if (attr.matches("Emailaddress")) {
                attrValueType = AttributeTypeAndValue.AttributeValueType.IA5;
            }
            attrs.add(new AttributeTypeAndValue(attr, value, attrValueType));
        }
        return attrs.toArray(A0);
    }

    public static class AttributeTypeAndValue {
        private final String type;
        private final String value;
        private final AttributeValueType attrValueType;

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public AttributeValueType getAttrValueType() {
            return this.attrValueType;
        }

        public AttributeTypeAndValue(String type, String value, AttributeValueType attrValueType) {
            this.type = type;
            this.value = value;
            this.attrValueType = attrValueType;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum AttributeValueType {
            PRINTABLE,
            IA5,
            UTF8,
            BMP,
            T61;

        }
    }
}

