/*
 * Decompiled with CFR 0.152.
 */
package cn.topca.security.x509.extension.logotype;

import cn.tca.TopBasicCrypto.asn1.ASN1Choice;
import cn.tca.TopBasicCrypto.asn1.ASN1Encodable;
import cn.tca.TopBasicCrypto.asn1.ASN1Sequence;
import cn.tca.TopBasicCrypto.asn1.ASN1TaggedObject;
import cn.tca.TopBasicCrypto.asn1.DERObject;
import cn.tca.TopBasicCrypto.asn1.DERTaggedObject;
import cn.topca.security.x509.extension.logotype.LogotypeData;
import cn.topca.security.x509.extension.logotype.LogotypeReference;

public class LogotypeInfo
extends ASN1Encodable
implements ASN1Choice {
    public static final int direct = 0;
    public static final int indirect = 1;
    ASN1Sequence obj;
    int tag;

    public static LogotypeInfo getInstance(ASN1TaggedObject tagObj) {
        int tag = tagObj.getTagNo();
        DERObject object = tagObj.getObject();
        if (object instanceof ASN1Sequence) {
            ASN1Sequence seq = (ASN1Sequence)object;
            switch (tag) {
                case 0: 
                case 1: {
                    return new LogotypeInfo(seq, tag);
                }
            }
            throw new IllegalArgumentException("unknown tag in factory: " + tag);
        }
        throw new IllegalArgumentException("object must be an ASN1Sequence. Not: " + object.getClass().getName());
    }

    public LogotypeInfo(ASN1Sequence obj, int tag) {
        if (tag != 0 && tag != 1) {
            throw new IllegalArgumentException("tag must be 0 or 1");
        }
        this.obj = obj;
        this.tag = tag;
    }

    public LogotypeInfo(LogotypeData direct) {
        this.obj = ASN1Sequence.getInstance(direct.toASN1Object());
        this.tag = 0;
    }

    public LogotypeInfo(LogotypeReference indirect) {
        this.obj = ASN1Sequence.getInstance(indirect.toASN1Object());
        this.tag = 1;
    }

    public LogotypeData getLogotypeData() {
        if (this.tag == 0) {
            return LogotypeData.getInstance(this.obj);
        }
        return null;
    }

    public LogotypeReference getLogotypeReference() {
        if (this.tag == 1) {
            return LogotypeReference.getInstance(this.obj);
        }
        return null;
    }

    public int getTagNo() {
        return this.tag;
    }

    public DERObject toASN1Object() {
        return new DERTaggedObject(true, this.tag, this.obj);
    }
}

