/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.asn1.cms;

import cn.tca.TopBasicCrypto.asn1.ASN1Null;
import cn.tca.TopBasicCrypto.asn1.ASN1OctetString;
import cn.tca.TopBasicCrypto.asn1.ASN1Set;
import cn.tca.TopBasicCrypto.asn1.DEREncodable;
import cn.tca.TopBasicCrypto.asn1.cms.AttributeTable;
import cn.tca.TopBasicCrypto.asn1.cms.EncryptedContentInfo;
import cn.tca.TopBasicCrypto.asn1.cms.EnvelopedData;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.cms.KeyTransRecipientInfo;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.RecipientInfo;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedData;
import cn.tca.TopBasicCrypto.cms.CMSEnvelopedDataGenerator;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.KeyTransRecipientId;
import cn.tca.TopBasicCrypto.cms.RecipientId;
import cn.tca.TopBasicCrypto.cms.RecipientInformation;
import cn.tca.TopBasicCrypto.cms.RecipientInformationStore;
import cn.tca.TopBasicCrypto.cms.jcajce.JceKeyTransEnvelopedRecipient;
import com.itrus.cms.CMSEnvelopedAsymmetricDecryptor;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public class CMSEnvelopedDataEx {
    private CMSEnvelopedData envelopedData;
    protected static final Map BASE_CIPHER_NAMES = new HashMap();
    protected static final Map CIPHER_ALG_NAMES = new HashMap();

    public CMSEnvelopedDataEx(byte[] bytes) throws CMSException {
        this(new CMSEnvelopedData(bytes));
    }

    public CMSEnvelopedDataEx(CMSEnvelopedData ed) {
        this.envelopedData = ed;
    }

    public byte[] getEncoded() throws IOException {
        return this.envelopedData.getEncoded();
    }

    public String getEncryptionAlgOID() {
        return this.envelopedData.getEncryptionAlgOID();
    }

    public byte[] getEncryptionAlgParams() {
        return this.envelopedData.getEncryptionAlgParams();
    }

    public AttributeTable getUnprotectedAttributes() {
        return this.envelopedData.getUnprotectedAttributes();
    }

    public byte[] getContent(X509Certificate cert, PrivateKey privateKey) throws CMSException {
        RecipientInformationStore recipients = this.envelopedData.getRecipientInfos();
        Collection c = recipients.getRecipients();
        for (RecipientInformation recipient : c) {
            RecipientId rid = recipient.getRID();
            if (!rid.match(cert)) continue;
            return recipient.getContent(new JceKeyTransEnvelopedRecipient(privateKey).setProvider("BC"));
        }
        return null;
    }

    public byte[] getContent(CMSEnvelopedAsymmetricDecryptor decryptor) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, InvalidAlgorithmParameterException, CMSException, IllegalBlockSizeException, BadPaddingException {
        EnvelopedData envelopeddata = EnvelopedData.getInstance(this.envelopedData.getContentInfo().getContent());
        ASN1Set asn1set = envelopeddata.getRecipientInfos();
        EncryptedContentInfo encryptedcontentinfo = envelopeddata.getEncryptedContentInfo();
        byte[] encryptedContent = encryptedcontentinfo.getEncryptedContent().getOctets();
        for (int i = 0; i != asn1set.size(); ++i) {
            RecipientInfo recipientinfo = RecipientInfo.getInstance(asn1set.getObjectAt(i));
            DEREncodable info = recipientinfo.getInfo();
            if (info instanceof KeyTransRecipientInfo) {
                Key sKey;
                KeyTransRecipientId rid;
                KeyTransRecipientInfo keytransrecipientinfo = (KeyTransRecipientInfo)info;
                byte[] encryptedKey = keytransrecipientinfo.getEncryptedKey().getOctets();
                AlgorithmIdentifier keyEncAlg = keytransrecipientinfo.getKeyEncryptionAlgorithm();
                String encAlgId = encryptedcontentinfo.getContentEncryptionAlgorithm().getObjectId().getId();
                String algBaseName = (String)BASE_CIPHER_NAMES.get(encAlgId) == null ? encAlgId : (String)BASE_CIPHER_NAMES.get(encAlgId);
                String algCipherName = (String)CIPHER_ALG_NAMES.get(encAlgId) == null ? encAlgId : (String)CIPHER_ALG_NAMES.get(encAlgId);
                RecipientIdentifier recipientidentifier = keytransrecipientinfo.getRecipientIdentifier();
                if (recipientidentifier.isTagged()) {
                    ASN1OctetString asn1octetstring = ASN1OctetString.getInstance(recipientidentifier.getId());
                    rid = new KeyTransRecipientId(asn1octetstring.getOctets());
                } else {
                    IssuerAndSerialNumber issuerandserialnumber = IssuerAndSerialNumber.getInstance(recipientidentifier.getId());
                    rid = new KeyTransRecipientId(issuerandserialnumber.getName(), issuerandserialnumber.getSerialNumber().getValue());
                }
                if (!decryptor.interested(rid, keyEncAlg) || (sKey = decryptor.decrypt(encryptedKey, algBaseName)) == null) continue;
                if (encAlgId.equalsIgnoreCase("1.2.156.10197.1.104")) {
                    throw new UnsupportedOperationException("sm4 not supported.");
                }
                Cipher cipher = Cipher.getInstance(algCipherName, "BC");
                DEREncodable parameters = encryptedcontentinfo.getContentEncryptionAlgorithm().getParameters();
                if (parameters != null && !(parameters instanceof ASN1Null)) {
                    try {
                        AlgorithmParameters algorithmparameters = AlgorithmParameters.getInstance(encAlgId, "BC");
                        try {
                            algorithmparameters.init(parameters.getDERObject().getEncoded(), "ASN.1");
                        }
                        catch (IOException ioexception) {
                            throw new CMSException("error decoding algorithm parameters.", ioexception);
                        }
                        cipher.init(2, sKey, algorithmparameters);
                    }
                    catch (NoSuchAlgorithmException nosuchalgorithmexception) {
                        if (encAlgId.equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC) || encAlgId.equals("1.3.6.1.4.1.188.7.1.1.2") || encAlgId.equals(CMSEnvelopedDataGenerator.AES128_CBC) || encAlgId.equals(CMSEnvelopedDataGenerator.AES192_CBC) || encAlgId.equals(CMSEnvelopedDataGenerator.AES256_CBC)) {
                            cipher.init(2, sKey, new IvParameterSpec(ASN1OctetString.getInstance(parameters).getOctets()));
                        }
                        throw nosuchalgorithmexception;
                    }
                } else if (encAlgId.equals(CMSEnvelopedDataGenerator.DES_EDE3_CBC) || encAlgId.equals("1.3.6.1.4.1.188.7.1.1.2") || encAlgId.equals("1.2.840.113533.7.66.10")) {
                    cipher.init(2, sKey, new IvParameterSpec(new byte[8]));
                } else {
                    cipher.init(2, sKey);
                }
                return cipher.doFinal(encryptedContent);
            }
            throw new UnsupportedOperationException("only supported key trans recipient type.");
        }
        return null;
    }

    static {
        BASE_CIPHER_NAMES.put("1.2.156.10197.1.104", "SM4");
        BASE_CIPHER_NAMES.put(com.itrus.security.pkcs.CMSEnvelopedDataGenerator.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(com.itrus.security.pkcs.CMSEnvelopedDataGenerator.AES128_CBC, "AES");
        BASE_CIPHER_NAMES.put(com.itrus.security.pkcs.CMSEnvelopedDataGenerator.AES192_CBC, "AES");
        BASE_CIPHER_NAMES.put(com.itrus.security.pkcs.CMSEnvelopedDataGenerator.AES256_CBC, "AES");
        CIPHER_ALG_NAMES.put("1.2.156.10197.1.104", "SM4");
        CIPHER_ALG_NAMES.put(com.itrus.security.pkcs.CMSEnvelopedDataGenerator.DES_EDE3_CBC, "DESEDE/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(com.itrus.security.pkcs.CMSEnvelopedDataGenerator.AES128_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(com.itrus.security.pkcs.CMSEnvelopedDataGenerator.AES192_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(com.itrus.security.pkcs.CMSEnvelopedDataGenerator.AES256_CBC, "AES/CBC/PKCS5Padding");
    }
}

