/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base.dao;

import com.itrus.base.dao.CertInfo;
import com.itrus.base.dao.DbConnection;
import com.itrus.util.CertUtils;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CertDao {
    private static final Logger log = Logger.getLogger(CertDao.class);
    private final String L = "(.*iTrusChina.*)|(.*\u5929\u5a01\u8bda\u4fe1.*),";

    public CertInfo findCertByCertSerialnumber(String serialnumber) {
        log.info((Object)(">>findCert(" + serialnumber + ")"));
        int dbmodel = DbConnection.getInstance().getConnectionType();
        CertInfo cert = null;
        log.info((Object)("dbmodel[" + dbmodel + "]"));
        switch (dbmodel) {
            case 1: {
                cert = this.findCertFromItrusRABySerialnumber(serialnumber);
                break;
            }
            case 2: {
                cert = this.findCertFromTopRABySerialnumber(serialnumber);
                break;
            }
            case 3: {
                cert = this.findCertFromTopRABySerialnumber(serialnumber);
                if (cert != null && cert.getCertSignBuf() != null) break;
                log.info((Object)"cert or certbuf is null,do findCertFromItrusRABySerialnumber");
                cert = this.findCertFromItrusRABySerialnumber(serialnumber);
                break;
            }
            default: {
                log.error((Object)("Error, wrong dbmodel[" + dbmodel + "],\u6570\u636e\u5e93\u914d\u7f6e\u9879dbmodel\u4e0d\u88ab\u652f\u6301"));
                throw new RuntimeException("Error, wrong dbmodel[" + dbmodel + "],\u6570\u636e\u5e93\u914d\u7f6e\u9879dbmodel\u4e0d\u88ab\u652f\u6301");
            }
        }
        return cert;
    }

    public CertInfo findCertFromTopRABySerialnumber(String certSerialnumber) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block13: {
            log.info((Object)(">>findCertFromTopRABySerialnumber(" + certSerialnumber + ")"));
            log.debug((Object)"(.*iTrusChina.*)|(.*\u5929\u5a01\u8bda\u4fe1.*),");
            certSerialnumber = certSerialnumber.toUpperCase();
            CertInfo info = new CertInfo();
            conn = null;
            ps = null;
            rs = null;
            conn = DbConnection.getInstance().getTopRAConnection();
            log.info((Object)("conn:" + conn.toString()));
            String sql = "select * from ITRUS_CERTINFO  where CERT_SERIALNUMBER = '" + certSerialnumber + "'";
            log.info((Object)("Sql:" + sql));
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            if (!rs.next()) break block13;
            info.setCertSignBuf(rs.getString("CERT_SIGN_BUF"));
            info.setCertSerialnumber(rs.getString("CERT_SERIALNUMBER"));
            info.setUserId(rs.getString("USER_ADDTIONAL_FIELD1"));
            info.setStatus(rs.getString("CERT_STATUS"));
            log.info((Object)"cert has find from TopRA");
            CertInfo certInfo = info;
            try {
                DbConnection.release(rs);
                DbConnection.release(ps);
                DbConnection.release(conn);
            }
            catch (SQLException e) {
                log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return certInfo;
        }
        try {
            try {
                log.error((Object)"\u672a\u627e\u5230\u5bf9\u5e94\u516c\u94a5\u8bc1\u4e66\uff0ccert not find from TopRA");
            }
            catch (SQLException e) {
                log.error((Object)"findCertFromTopRABySerialnumber error,\u67e5\u8be2\u8bc1\u4e66\u5f02\u5e38");
                log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    DbConnection.release(rs);
                    DbConnection.release(ps);
                    DbConnection.release(conn);
                }
                catch (SQLException e2) {
                    log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                DbConnection.release(rs);
                DbConnection.release(ps);
                DbConnection.release(conn);
            }
            catch (SQLException e) {
                log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw throwable;
        }
        try {
            DbConnection.release(rs);
            DbConnection.release(ps);
            DbConnection.release(conn);
        }
        catch (SQLException e) {
            log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public CertInfo findCertFromItrusRABySerialnumber(String certSerialnumber) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        CertInfo info;
        block13: {
            log.info((Object)(">>findCertFromItrusRABySerialnumber(" + certSerialnumber + ")"));
            log.debug((Object)"(.*iTrusChina.*)|(.*\u5929\u5a01\u8bda\u4fe1.*),");
            certSerialnumber = certSerialnumber.toUpperCase();
            info = new CertInfo();
            conn = null;
            ps = null;
            rs = null;
            conn = DbConnection.getInstance().getItrusRAConnection();
            log.info((Object)("conn:" + conn));
            String sql = "select * from ITRUS_CERTINFO  where CERT_SERIALNUMBER = '" + certSerialnumber + "'";
            log.info((Object)("Sql:" + sql));
            ps = conn.prepareStatement(sql);
            rs = ps.executeQuery();
            if (!rs.next()) break block13;
            info.setCertSignBuf(rs.getString("CERT_SIGN_BUF"));
            info.setCertSerialnumber(rs.getString("CERT_SERIALNUMBER"));
            info.setUserId(rs.getString("USER_ADDTIONAL_FIELD1"));
            info.setStatus(rs.getString("CERT_STATUS"));
            log.info((Object)"cert has find from ItrusRA");
            CertInfo certInfo = info;
            try {
                DbConnection.release(rs);
                DbConnection.release(ps);
                DbConnection.release(conn);
            }
            catch (Exception e) {
                log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            return certInfo;
        }
        try {
            try {
                log.error((Object)"\u672a\u627e\u5230\u5bf9\u5e94\u516c\u94a5\u8bc1\u4e66\uff0ccert not find from ItrusRA");
            }
            catch (SQLException e) {
                log.error((Object)"findCertFromTopRAByUID error,\u67e5\u8be2\u8bc1\u4e66\u5f02\u5e38");
                log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    DbConnection.release(rs);
                    DbConnection.release(ps);
                    DbConnection.release(conn);
                }
                catch (Exception e2) {
                    log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                DbConnection.release(rs);
                DbConnection.release(ps);
                DbConnection.release(conn);
            }
            catch (Exception e) {
                log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw throwable;
        }
        try {
            DbConnection.release(rs);
            DbConnection.release(ps);
            DbConnection.release(conn);
        }
        catch (Exception e) {
            log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public CertInfo findByCertUID(String userID) {
        log.info((Object)(">>findByCertUID(" + userID + ")"));
        log.debug((Object)"(.*iTrusChina.*)|(.*\u5929\u5a01\u8bda\u4fe1.*),");
        int dbmodel = DbConnection.getInstance().getConnectionType();
        CertInfo cert = null;
        log.info((Object)("dbmodel[" + dbmodel + "]"));
        switch (dbmodel) {
            case 1: {
                cert = this.findCertFromItrusRAByUID(userID);
                break;
            }
            case 2: {
                cert = this.findCertFromTopRAByUID(userID);
                break;
            }
            case 3: {
                log.info((Object)"do findCertFromTopRAByUID");
                cert = this.findCertFromTopRAByUID(userID);
                if (cert != null && cert.getCertSignBuf() != null) break;
                log.info((Object)"cert or certbuf is null,do findCertFromItrusRAByUID");
                cert = this.findCertFromItrusRAByUID(userID);
                break;
            }
            default: {
                log.error((Object)("Error, wrong dbmodel[" + dbmodel + "],\u6570\u636e\u5e93\u914d\u7f6e\u9879dbmodel\u4e0d\u88ab\u652f\u6301"));
                throw new RuntimeException("Error, wrong dbmodel[" + dbmodel + "],\u6570\u636e\u5e93\u914d\u7f6e\u9879dbmodel\u4e0d\u88ab\u652f\u6301");
            }
        }
        return cert;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CertInfo findCertFromTopRAByUID(String userID) {
        block18: {
            CertDao.log.info((Object)(">>findCertFromTopRAByUID(" + userID + ")"));
            CertDao.log.debug((Object)"(.*iTrusChina.*)|(.*\u5929\u5a01\u8bda\u4fe1.*),");
            info = null;
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = DbConnection.getInstance().getTopRAConnection();
                CertDao.log.info((Object)("conn:" + conn));
                sql = "select * from ITRUS_CERTINFO where USER_ADDTIONAL_FIELD1 = '" + userID + "'";
                CertDao.log.info((Object)("Sql:" + sql));
                ps = conn.prepareStatement(sql);
                rs = ps.executeQuery();
                certs = new ArrayList<CertInfo>();
                while (true) {
                    block19: {
                        if (rs.next()) break block19;
                        if (certs.size() < 1) break block18;
                        var9_9 = certs.iterator();
                        ** GOTO lbl-1000
                    }
                    info = new CertInfo();
                    info.setCertSignBuf(rs.getString("CERT_SIGN_BUF"));
                    info.setCertSerialnumber(rs.getString("CERT_SERIALNUMBER"));
                    info.setUserId(rs.getString("USER_ADDTIONAL_FIELD1"));
                    info.setStatus(rs.getString("CERT_STATUS"));
                    CertDao.log.info((Object)"cert has find from TopRA");
                    certs.add(info);
                }
            }
            catch (SQLException e) {
                CertDao.log.error((Object)"findCertFromTopRAByUID error,\u67e5\u8be2\u8bc1\u4e66\u5f02\u5e38");
                CertDao.log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    DbConnection.release(rs);
                    DbConnection.release(ps);
                    DbConnection.release(conn);
                }
                catch (SQLException e) {
                    CertDao.log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                    CertDao.log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable var12_18) {
                try {
                    DbConnection.release(rs);
                    DbConnection.release(ps);
                    DbConnection.release(conn);
                    throw var12_18;
                }
                catch (SQLException e) {
                    CertDao.log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                    CertDao.log.error((Object)e.getMessage(), (Throwable)e);
                }
                throw var12_18;
            }
lbl52:
            // 1 sources

            while (true) {
                try {
                    DbConnection.release(rs);
                    DbConnection.release(ps);
                    DbConnection.release(conn);
                    return var13_13;
                }
                catch (SQLException e) {
                    CertDao.log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                    CertDao.log.error((Object)e.getMessage(), (Throwable)e);
                }
                return var13_13;
            }
lbl-1000:
            // 3 sources

            {
                ** while (var9_9.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                certInfo = (CertInfo)var9_9.next();
                cert = null;
                try {
                    cert = CertUtils.getX509CertificateFromBase64(certInfo.getCertSignBuf());
                }
                catch (CertificateException e) {
                    CertDao.log.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                if (!CertUtils.isOnValidPeriod(cert) || certInfo.getStatus().equalsIgnoreCase("REVOKE")) continue;
                var13_13 = certInfo;
                ** continue;
lbl74:
                // 1 sources

                ** GOTO lbl52
            }
        }
        try {
            DbConnection.release(rs);
            DbConnection.release(ps);
            DbConnection.release(conn);
        }
        catch (SQLException e) {
            CertDao.log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
            CertDao.log.error((Object)e.getMessage(), (Throwable)e);
        }
        CertDao.log.error((Object)"\u672a\u627e\u5230\u5bf9\u5e94\u516c\u94a5\u8bc1\u4e66\uff0ccert not find from TopRA");
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CertInfo findCertFromItrusRAByUID(String userID) {
        block18: {
            CertDao.log.info((Object)(">>findCertFromItrusRAByUID(" + userID + ")"));
            CertDao.log.debug((Object)"(.*iTrusChina.*)|(.*\u5929\u5a01\u8bda\u4fe1.*),");
            info = null;
            conn = null;
            ps = null;
            rs = null;
            try {
                conn = DbConnection.getInstance().getItrusRAConnection();
                CertDao.log.info((Object)("conn:" + conn));
                sql = "select * from ITRUS_CERTINFO where USER_ADDTIONAL_FIELD1 = '" + userID + "'";
                CertDao.log.info((Object)("Sql:" + sql));
                ps = conn.prepareStatement(sql);
                rs = ps.executeQuery();
                certs = new ArrayList<CertInfo>();
                while (true) {
                    block19: {
                        if (rs.next()) break block19;
                        if (certs.size() < 1) break block18;
                        var9_9 = certs.iterator();
                        ** GOTO lbl-1000
                    }
                    info = new CertInfo();
                    info.setCertSignBuf(rs.getString("CERT_SIGN_BUF"));
                    info.setCertSerialnumber(rs.getString("CERT_SERIALNUMBER"));
                    info.setUserId(rs.getString("USER_ADDTIONAL_FIELD1"));
                    info.setStatus(rs.getString("CERT_STATUS"));
                    CertDao.log.info((Object)"cert has find from TopRA");
                    certs.add(info);
                }
            }
            catch (Exception e) {
                CertDao.log.error((Object)"findCertFromItrusRAByUID error,\u67e5\u8be2\u8bc1\u4e66\u5f02\u5e38");
                CertDao.log.error((Object)e.getMessage(), (Throwable)e);
                try {
                    DbConnection.release(rs);
                    DbConnection.release(ps);
                    DbConnection.release(conn);
                    return null;
                }
                catch (Exception e) {
                    CertDao.log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                    CertDao.log.error((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            catch (Throwable var12_18) {
                try {
                    DbConnection.release(rs);
                    DbConnection.release(ps);
                    DbConnection.release(conn);
                    throw var12_18;
                }
                catch (Exception e) {
                    CertDao.log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                    CertDao.log.error((Object)e.getMessage(), (Throwable)e);
                }
                throw var12_18;
            }
lbl52:
            // 1 sources

            while (true) {
                try {
                    DbConnection.release(rs);
                    DbConnection.release(ps);
                    DbConnection.release(conn);
                    return var13_13;
                }
                catch (Exception e) {
                    CertDao.log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
                    CertDao.log.error((Object)e.getMessage(), (Throwable)e);
                }
                return var13_13;
            }
lbl-1000:
            // 3 sources

            {
                ** while (var9_9.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                certInfo = (CertInfo)var9_9.next();
                cert = null;
                try {
                    cert = CertUtils.getX509CertificateFromBase64(certInfo.getCertSignBuf());
                }
                catch (CertificateException e) {
                    CertDao.log.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                if (!CertUtils.isOnValidPeriod(cert) || certInfo.getStatus().equalsIgnoreCase("REVOKE")) continue;
                var13_13 = certInfo;
                ** continue;
lbl74:
                // 1 sources

                ** GOTO lbl52
            }
        }
        try {
            DbConnection.release(rs);
            DbConnection.release(ps);
            DbConnection.release(conn);
            return null;
        }
        catch (Exception e) {
            CertDao.log.error((Object)"DbConnection.release error,\u5173\u95ed\u5f02\u5e38");
            CertDao.log.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

