/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base.dao;

import com.itrus.base.ServerConfParser;
import com.itrus.base.ServerConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;

public class DbConnection {
    private static final Logger log = Logger.getLogger(DbConnection.class);
    private static ServerConfig config = ServerConfParser.getInstance().getServerConfig();
    private static DataSource topRA_dataSource = null;
    private static DataSource itrusRA_dataSource = null;
    private static int dbmodel = -1;
    private static DbConnection instance = null;

    public static DataSource setupDataSource(String dbDrv, String dbUrl, String dbUser, String dbPwd) {
        log.info((Object)">>setupDataSource()");
        log.info((Object)("dbDrv[" + dbDrv + "]"));
        log.info((Object)("dbUrl[" + dbUrl + "]"));
        log.info((Object)("dbUser[" + dbUser + "]"));
        BasicDataSource bds = new BasicDataSource();
        bds.setDriverClassName(dbDrv);
        bds.setUrl(dbUrl);
        bds.setUsername(dbUser);
        bds.setPassword(dbPwd);
        bds.setMaxActive(100);
        bds.setMaxIdle(15);
        bds.setMaxWait(10000L);
        return bds;
    }

    public Connection getTopRAConnection() {
        log.info((Object)">>getTopRAConnection()");
        Connection conn = null;
        try {
            BasicDataSource bds = (BasicDataSource)topRA_dataSource;
            log.info((Object)("NumActive:" + bds.getNumActive() + "," + "NumIdle:" + bds.getNumIdle()));
            conn = topRA_dataSource.getConnection();
        }
        catch (SQLException e) {
            log.error((Object)"getTopRAConnection  Error!");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return conn;
    }

    public void shutdownTopRA() throws SQLException {
        log.info((Object)">>shutdownTopRA()");
        BasicDataSource bds = (BasicDataSource)topRA_dataSource;
        bds.close();
    }

    public Connection getItrusRAConnection() {
        log.info((Object)">>getItrusRAConnection()");
        Connection conn = null;
        try {
            BasicDataSource bds = (BasicDataSource)itrusRA_dataSource;
            log.info((Object)("NumActive: " + bds.getNumActive() + "," + "NumIdle: " + bds.getNumIdle()));
            conn = itrusRA_dataSource.getConnection();
        }
        catch (SQLException e) {
            log.error((Object)"getItrusRAConnection  Error!");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return conn;
    }

    public void shutdownItrusRA() throws SQLException {
        log.info((Object)">>shutdownItrusRA()");
        BasicDataSource bds = (BasicDataSource)itrusRA_dataSource;
        bds.close();
    }

    private DbConnection() {
        log.info((Object)">>DbConnection()");
        log.info((Object)("\u6a21\u5f0f[" + config.getDbmodel() + "]"));
        switch (Integer.parseInt(config.getDbmodel())) {
            case 1: {
                log.info((Object)("itrusca\u6a21\u5f0f[" + config.getDbmodel() + "]"));
                itrusRA_dataSource = DbConnection.setupDataSource(config.getIca_driverclass(), config.getIca_dburl(), config.getIca_user(), config.getIca_password());
                dbmodel = 1;
                break;
            }
            case 2: {
                log.info((Object)("topca\u6a21\u5f0f[" + config.getDbmodel() + "]"));
                topRA_dataSource = DbConnection.setupDataSource(config.getTop_driverclass(), config.getTop_dburl(), config.getTop_user(), config.getTop_password());
                dbmodel = 2;
                break;
            }
            case 3: {
                log.info((Object)("itrusca+topca\u6a21\u5f0f[" + config.getDbmodel() + "]"));
                itrusRA_dataSource = DbConnection.setupDataSource(config.getIca_driverclass(), config.getIca_dburl(), config.getIca_user(), config.getIca_password());
                topRA_dataSource = DbConnection.setupDataSource(config.getTop_driverclass(), config.getTop_dburl(), config.getTop_user(), config.getTop_password());
                dbmodel = 3;
                break;
            }
            default: {
                log.error((Object)("\u6ca1\u6709\u8fd9\u79cd\u8fde\u63a5\u6a21\u5f0f\uff0cdbmodel=" + config.getDbmodel()));
                throw new RuntimeException("\u6ca1\u6709\u8fd9\u79cd\u8fde\u63a5\u6a21\u5f0f\uff0cdbmodel=" + config.getDbmodel());
            }
        }
    }

    public static DbConnection getInstance() {
        log.info((Object)">>getInstance()");
        if (instance == null) {
            instance = new DbConnection();
        }
        return instance;
    }

    public int getConnectionType() {
        log.info((Object)">>getConnectionType()");
        log.info((Object)("dbmodel[" + dbmodel + "]"));
        return dbmodel;
    }

    public static String getDBType() {
        log.info((Object)">>getDBType()");
        log.info((Object)("DBType[" + config.getDbtype() + "]"));
        return config.getDbtype();
    }

    public static void release(Object obj) throws SQLException {
        log.info((Object)(">>release(" + obj + ")"));
        if (obj == null) {
            return;
        }
        if (obj instanceof Connection) {
            ((Connection)obj).close();
        }
        if (obj instanceof PreparedStatement) {
            ((PreparedStatement)obj).close();
        }
        if (obj instanceof ResultSet) {
            ((ResultSet)obj).close();
        }
        if (obj instanceof Statement) {
            ((Statement)obj).close();
        }
    }
}

