/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.base.service;

import cn.topca.security.pkcs11.jna.CK_ATTRIBUTE;
import cn.topca.security.pkcs11.jna.CK_MECHANISM;
import cn.topca.security.pkcs11.jna.CK_SESSION_INFO;
import cn.topca.security.pkcs11.jna.CK_TOKEN_INFO;
import cn.topca.security.pkcs11.jna.Functions;
import cn.topca.security.pkcs11.jna.PKCS11;
import cn.topca.security.pkcs11.jna.PKCS11Exception;
import com.itrus.base.util.DataUtil;
import com.itrus.base.util.PKCS11ServiceUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKCS11Service {
    private static final Logger log = Logger.getLogger(PKCS11Service.class);
    public static final long NULL = -1L;
    private static final char[] pPin = new char[]{'~', '~', '~', '~', '~', '~', '~', '~', '~', '~', '~', '~', '~', '~', '~', '~'};
    private static final long CKM_SM2 = -2097151999L;
    private static final long FINDOBJECTS_MAX = 100L;
    private static final CK_ATTRIBUTE ATTR_CLASS_PKEY = new CK_ATTRIBUTE(0L, 3L);
    private static final CK_ATTRIBUTE ATTR_CLASS_CERT = new CK_ATTRIBUTE(0L, 1L);
    private String pinPassword = null;
    private PKCS11 pkcs11 = null;
    private long[] slots = null;
    private long slot = -1L;
    private long session = -1L;
    private HashMap<byte[], PublicKey> pubKeyMap = new HashMap();
    private HashMap<byte[], Long> priKeyMap = new HashMap();
    private HashMap<byte[], X509Certificate> certMap = new HashMap();
    private HashMap<X509Certificate, Long> certPriKeyPair = null;
    private HashMap<PublicKey, Long> pubpriKeyPair = null;

    public PKCS11Service() {
    }

    public PKCS11Service(String providerLibPath) {
        log.info((Object)(">>PKCS11Service(" + providerLibPath + ")"));
        try {
            this.pkcs11 = PKCS11.getInstance(providerLibPath, null, "C_GetFunctionList", null, false);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (PKCS11Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public PKCS11 getPKCS11Instance(String providerLibPath) {
        log.info((Object)(">>getPKCS11Instance[" + providerLibPath + "]"));
        try {
            this.pkcs11 = PKCS11.getInstance(providerLibPath, null, "C_GetFunctionList", null, false);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (PKCS11Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.pkcs11;
    }

    public String getInfo() throws PKCS11Exception {
        log.info((Object)">>getInfo()");
        String cryptokiInfo = this.pkcs11.C_GetInfo().toString();
        log.info((Object)("return cryptokiInfo[" + cryptokiInfo + "]"));
        return cryptokiInfo;
    }

    public long[] getKeySlots() {
        log.info((Object)">>getKeySlots()");
        if (this.pkcs11 == null) {
            log.error((Object)"pkcs11 instance is null, please Initialize PKCS11<excute getInstance method> ");
            return null;
        }
        try {
            this.slots = this.pkcs11.C_GetSlotList(true);
            if (this.slots == null || this.slots.length < 1) {
                this.slots = null;
                log.error((Object)"slots.length<1");
                return null;
            }
        }
        catch (PKCS11Exception e) {
            log.error((Object)"\u83b7\u53d6slots\u9519\u8bef Error!");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        log.info((Object)("slots.length [" + this.slots.length + "]"));
        return this.slots;
    }

    public long getKeySlot() {
        log.info((Object)">>getKeySlot()");
        if (this.slots == null || this.slots.length < 1) {
            this.getKeySlots();
        }
        if (this.slots != null && this.slots.length > 0) {
            this.slot = this.slots[0];
        }
        log.info((Object)("return slot[" + this.slot + "]"));
        return this.slot;
    }

    public String getTokenInfo() throws PKCS11Exception {
        log.info((Object)">>getTokenInfo()");
        CK_TOKEN_INFO tokenInfo = this.pkcs11.C_GetTokenInfo(this.slot);
        String tInfo = tokenInfo.toString();
        log.info((Object)("return tokenInfo [" + tInfo + "]"));
        return tInfo;
    }

    public void Opensession() {
        log.info((Object)">>Opensession()");
        if (this.session != -1L && this.getSessionState() != -1L) {
            log.info((Object)("session[" + this.session + "]"));
            return;
        }
        if (this.session != -1L) {
            this.closeSession();
        }
        try {
            this.session = this.pkcs11.C_OpenSession(this.slot, 6L, null, null);
            log.info((Object)("session[" + this.session + "]"));
        }
        catch (Exception e) {
            this.resetSession();
        }
    }

    public long getSessionState() {
        log.info((Object)">>getSessionState()");
        long sessionState = -1L;
        try {
            CK_SESSION_INFO sessionInfo = this.pkcs11.C_GetSessionInfo(this.session);
            sessionState = Functions.ckUlongTojLong(sessionInfo.state);
        }
        catch (Exception e) {
            log.error((Object)("sessionState[" + sessionState + "]"));
            log.error((Object)e.getMessage());
        }
        log.info((Object)("return sessionState[" + sessionState + "]"));
        return sessionState;
    }

    public void closeSession() {
        log.info((Object)">>closeSession()");
        try {
            this.pkcs11.C_CloseSession(this.session);
        }
        catch (PKCS11Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.resetSession();
    }

    public boolean usbKeyLogin(char[] password, String alias) throws CertificateException, PKCS11Exception {
        block14: {
            log.info((Object)(">>usbKeyLogin(key type:" + alias));
            System.out.println();
            log.info((Object)("key type:" + alias));
            if (alias.equalsIgnoreCase("finger")) {
                if (this.getSessionState() == 3L) {
                    this.pkcs11.C_Logout(this.session);
                }
                try {
                    this.pkcs11.C_Login(this.session, 1L, pPin);
                    this.initKeyPair();
                    return true;
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                if (password == null) {
                    log.error((Object)"password is null");
                    return false;
                }
                if (this.session == -1L) {
                    this.Opensession();
                }
                if (this.getSessionState() == 3L) {
                    if (this.pinPassword != null && this.pinPassword.equals(String.valueOf(password))) {
                        this.initKeyPair();
                        log.info((Object)"UKey has login  check again return true");
                        return true;
                    }
                    if (this.pinPassword == null) {
                        log.info((Object)"sessionState == CKS_RW_USER_FUNCTIONS but pinPass ==null ,continue");
                    } else {
                        log.info((Object)"UKey has login  check again return false");
                        return false;
                    }
                }
                try {
                    this.pkcs11.C_Login(this.session, 1L, password);
                    this.pinPassword = String.valueOf(password);
                    this.initKeyPair();
                    log.info((Object)"usbKeyLogin return true");
                    return true;
                }
                catch (PKCS11Exception e) {
                    String p11msg = e.getLocalizedMessage();
                    log.info((Object)("p11msg[" + p11msg + "]"));
                    if ("CKR_USER_ALREADY_LOGGED_IN".equals(p11msg)) {
                        this.pkcs11.C_Logout(this.session);
                        this.pkcs11.C_Login(this.session, 1L, password);
                        this.initKeyPair();
                        log.info((Object)"usbKeyLogin return true");
                        return true;
                    }
                    if (!"CKR_PIN_LOCKED".equals(p11msg)) break block14;
                    String msg = "\u5bc6\u7801\u591a\u6b21\u8f93\u9519\uff0cKEY\u5df2\u88ab\u9501\u3002(CKR_PIN_LOCKED CODE:164)";
                    JOptionPane.showMessageDialog(null, "\u5bc6\u7801\u591a\u6b21\u8f93\u9519\uff0cKEY\u5df2\u88ab\u9501", "\u8b66\u544a", 2);
                    log.error((Object)msg);
                    log.info((Object)"usbKey has locked return false");
                }
            }
        }
        log.info((Object)"usbKeyLogin return false");
        return false;
    }

    public void initKeyPair() throws CertificateException, PKCS11Exception {
        log.info((Object)">>initKeyPair()");
        HashMap<byte[], X509Certificate> certs = this.getCertMap();
        HashMap<byte[], Long> priKeys = this.getPriKeyMap();
        HashMap<byte[], PublicKey> pubKeys = this.getPubKeyMap();
        this.certPriKeyPair = new HashMap();
        this.pubpriKeyPair = new HashMap();
        Set<byte[]> certKeyIDs = certs.keySet();
        Set<byte[]> priKeyIDs = priKeys.keySet();
        Set<byte[]> pubKeyIDs = pubKeys.keySet();
        for (byte[] certKid : certKeyIDs) {
            for (byte[] priKid : priKeyIDs) {
                if (!Arrays.equals(certKid, priKid)) continue;
                this.certPriKeyPair.put(certs.get(certKid), priKeys.get(priKid));
                log.info((Object)("get a match ,cert subject[" + certs.get(certKid).getSubjectX500Principal().getName() + "]"));
            }
        }
        for (byte[] pubKid : pubKeyIDs) {
            for (byte[] priKid : priKeyIDs) {
                if (!Arrays.equals(pubKid, priKid)) continue;
                this.pubpriKeyPair.put(pubKeys.get(pubKid), priKeys.get(priKid));
                log.info((Object)("get a match ,pubKid[" + pubKid + "]"));
            }
        }
    }

    public HashMap<byte[], X509Certificate> getCertMap() throws PKCS11Exception, CertificateException {
        log.info((Object)">>getCertMap()");
        this.Opensession();
        this.certMap = new HashMap();
        CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{ATTR_CLASS_CERT};
        this.pkcs11.C_FindObjectsInit(this.session, attrs);
        long[] certHandles = this.pkcs11.C_FindObjects(this.session, 100L);
        this.pkcs11.C_FindObjectsFinal(this.session);
        log.debug((Object)("Find Certificate Handles:" + certHandles.length));
        long[] lArray = certHandles;
        int n = certHandles.length;
        int n2 = 0;
        while (n2 < n) {
            long handle = lArray[n2];
            attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L), new CK_ATTRIBUTE(17L)};
            this.pkcs11.C_GetAttributeValue(this.session, handle, attrs);
            log.debug((Object)("C_GetAttributeValue with Certificate handle:" + handle));
            byte[] kid = attrs[0].getByteArray();
            log.debug((Object)"CKA_ID:[".concat(DataUtil.transformByteArrayToHexString(kid, true)).concat("]"));
            byte[] bytes = attrs[1].getByteArray();
            log.debug((Object)"CKA_VALUE:[".concat(DataUtil.transformByteArrayToHexString(bytes, true)).concat("]"));
            if (bytes == null) {
                throw new CertificateException("unexpectedly retrieved null byte array");
            }
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509", "TopSM");
                X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(bytes));
                log.debug((Object)"Conert Certificate:\n".concat(cert.toString()));
                if (attrs[0].pValue != null) {
                    this.certMap.put(kid, cert);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        return this.certMap;
    }

    public HashMap<byte[], Long> getPriKeyMap() throws PKCS11Exception {
        log.info((Object)">>getPriKeyMap()");
        this.priKeyMap = new HashMap();
        CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{ATTR_CLASS_PKEY};
        this.pkcs11.C_FindObjectsInit(this.session, attrs);
        long[] privateKeyHandles = this.pkcs11.C_FindObjects(this.session, 100L);
        this.pkcs11.C_FindObjectsFinal(this.session);
        log.debug((Object)("Find PrivateKey Handles:" + privateKeyHandles.length));
        long[] lArray = privateKeyHandles;
        int n = privateKeyHandles.length;
        int n2 = 0;
        while (n2 < n) {
            long handle = lArray[n2];
            attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
            this.pkcs11.C_GetAttributeValue(this.session, handle, attrs);
            log.debug((Object)("C_GetAttributeValue with PrivateKey handle:" + handle));
            byte[] kid = new byte[]{};
            if (attrs[0].pValue != null) {
                kid = attrs[0].getByteArray();
            }
            log.debug((Object)"CKA_ID:[".concat(DataUtil.transformByteArrayToHexString(kid, true)).concat("]"));
            this.priKeyMap.put(kid, handle);
            log.debug((Object)"Find a match.");
            ++n2;
        }
        return this.priKeyMap;
    }

    public HashMap<byte[], PublicKey> getPubKeyMap() throws PKCS11Exception {
        log.info((Object)">>getPubKeyMap()");
        return this.pubKeyMap;
    }

    public long getPrivateKeyHandle(Certificate cert) {
        log.info((Object)">>getPrivateKeyHandle()");
        long privateKeyHandle = this.getCertPriKeyPair().get(cert);
        log.info((Object)("return privateKeyHandle[" + privateKeyHandle + "]"));
        return privateKeyHandle;
    }

    public byte[] sign(long privateKeyHandle, byte[] plaintext, String algorithm) throws PKCS11Exception, NoSuchAlgorithmException, SignatureException {
        log.info((Object)">>sign()");
        log.info((Object)("algorithm[" + algorithm + "]"));
        byte[] signature = null;
        if (algorithm.equalsIgnoreCase("SM3withSM2")) {
            log.info((Object)"Sm2\u8bc1\u4e66,\u8c03\u7528SM2\u7b7e\u540d\u63a5\u53e3");
            log.info((Object)"Sm2\u8bc1\u4e66,\u7b7e\u540d\u673a\u5236[-2097151999]");
            this.pkcs11.C_SignInit(this.session, new CK_MECHANISM(-2097151999L), privateKeyHandle);
            log.info((Object)("Sm2\u8bc1\u4e66,CK_MECHANISM[" + new CK_MECHANISM(-2097151999L).getMechanism() + "]"));
            signature = this.pkcs11.C_Sign(this.session, plaintext);
        } else if (algorithm.equalsIgnoreCase("SHA1withRSA")) {
            log.info((Object)"RSA\u8bc1\u4e66,\u8c03\u7528RSA\u7b7e\u540d\u63a5\u53e3");
            log.info((Object)"RSA\u8bc1\u4e66,\u7b7e\u540d\u673a\u5236[1]");
            this.pkcs11.C_SignInit(this.session, new CK_MECHANISM(1L), privateKeyHandle);
            log.info((Object)("RSA\u8bc1\u4e66,CK_MECHANISM[" + new CK_MECHANISM(1L).getMechanism() + "]"));
            byte[] md = PKCS11ServiceUtil.getFormateData(plaintext, algorithm);
            byte[] b = PKCS11ServiceUtil.encodeSignature(md, algorithm);
            signature = this.pkcs11.C_Sign(this.session, b);
        } else {
            throw new RuntimeException("does not support such algorithm[" + algorithm + "]");
        }
        return signature;
    }

    public boolean verify(byte[] plaintext, byte[] signature, Certificate cert, String signAlgorithm) throws Exception {
        log.info((Object)">>verify()");
        throw new RuntimeException("this method is not enabled,\u8be5\u65b9\u6cd5\u5c1a\u672a\u542f\u7528");
    }

    public byte[] encode(String algorithm, byte[] in, long pubkey) throws PKCS11Exception {
        log.info((Object)">>encode()");
        byte[] outtmp = new byte[1024];
        int dret = -1;
        if (algorithm.equalsIgnoreCase("SM3withSM2")) {
            this.pkcs11.C_EncryptInit(this.session, new CK_MECHANISM(-2097151999L), pubkey);
            dret = this.pkcs11.C_Encrypt(this.session, in, 0, in.length, outtmp, 0, outtmp.length);
        } else if (algorithm.equalsIgnoreCase("SHA1withRSA")) {
            this.pkcs11.C_EncryptInit(this.session, new CK_MECHANISM(1L), pubkey);
            dret = this.pkcs11.C_Encrypt(this.session, in, 0, in.length, outtmp, 0, outtmp.length);
        } else {
            throw new RuntimeException("does not support such algorithm[" + algorithm + "]");
        }
        byte[] out = new byte[dret];
        System.arraycopy(outtmp, 0, out, 0, dret);
        log.info((Object)("encode return ret[" + dret + "]"));
        return out;
    }

    public byte[] decode(String algorithm, byte[] in, long privateKeyHandle) throws PKCS11Exception {
        log.info((Object)">>decode()");
        byte[] outtmp = new byte[1024];
        int dret = -1;
        if (algorithm.equalsIgnoreCase("SM3withSM2")) {
            this.pkcs11.C_DecryptInit(this.session, new CK_MECHANISM(-2097151999L), privateKeyHandle);
            dret = this.pkcs11.C_Decrypt(this.session, in, 0, in.length, outtmp, 0, outtmp.length);
        } else if (algorithm.equalsIgnoreCase("SHA1withRSA")) {
            this.pkcs11.C_DecryptInit(this.session, new CK_MECHANISM(1L), privateKeyHandle);
            dret = this.pkcs11.C_Decrypt(this.session, in, 0, in.length, outtmp, 0, outtmp.length);
        } else {
            throw new RuntimeException("does not support such algorithm[" + algorithm + "]");
        }
        byte[] out = new byte[dret];
        System.arraycopy(outtmp, 0, out, 0, dret);
        log.info((Object)("decode return ret[" + dret + "]"));
        return out;
    }

    public byte[] initRSAKey(String algorithm, byte[] in, long privateKeyHandle) throws PKCS11Exception {
        log.info((Object)">>decode()");
        byte[] outtmp = new byte[1024];
        int dret = -1;
        if (algorithm.equalsIgnoreCase("SM3withSM2")) {
            this.pkcs11.C_DecryptInit(this.session, new CK_MECHANISM(-2097151999L), privateKeyHandle);
            dret = this.pkcs11.C_Decrypt(this.session, in, 0, in.length, outtmp, 0, outtmp.length);
        } else if (algorithm.equalsIgnoreCase("SHA1withRSA")) {
            this.pkcs11.C_DecryptInit(this.session, new CK_MECHANISM(1L), privateKeyHandle);
            dret = this.pkcs11.C_Decrypt(this.session, in, 0, in.length, outtmp, 0, outtmp.length);
        } else {
            throw new RuntimeException("does not support such algorithm[" + algorithm + "]");
        }
        byte[] out = new byte[dret];
        System.arraycopy(outtmp, 0, out, 0, dret);
        log.info((Object)("decode return ret[" + dret + "]"));
        return out;
    }

    public HashMap<X509Certificate, Long> getCertPriKeyPair() {
        log.info((Object)">>getCertPriKeyPair()");
        return this.certPriKeyPair;
    }

    public HashMap<PublicKey, Long> getPubpriKeyPair() {
        log.info((Object)">>getPubpriKeyPair()");
        return this.pubpriKeyPair;
    }

    public void reset() {
        log.info((Object)">>reset()");
        log.info((Object)"reset contains:logout,reset slot/pinPassword/pkcs11/session & empty pubKeyMap/priKeyMap/certMap");
        try {
            this.pkcs11.C_Logout(this.session);
        }
        catch (PKCS11Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.pinPassword = null;
        this.pkcs11 = null;
        this.slot = -1L;
        this.session = -1L;
        this.pubKeyMap = new HashMap();
        this.priKeyMap = new HashMap();
        this.certMap = new HashMap();
    }

    private void resetSession() {
        log.info((Object)">>resetSession()");
        this.session = -1L;
    }
}

