/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cert;

import com.itrus.cert.asn1.DERTags;
import com.itrus.util.CertUtils;
import com.itrus.util.DERUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Stack;

public class ItrusCRL
implements DERTags {
    private boolean debug = true;
    private Date thisUpdate = null;
    private Date nextUpdate = null;
    private int version = 0;
    private int pos = 0;
    private int[] indexMap = null;
    private byte[] revokedCertSNs = null;
    private byte[] issuerDNBytes = null;
    private int count = 0;
    private static final int[] prime_list = new int[]{53, 97, 193, 389, 769, 1543, 3079, 6151, 12289, 24593, 49157, 98317, 196613, 393241, 786433, 1572869, 0x30000B, 0x60000D, 0xC00005, 25165843, 0x3000005, 100663319, 201326611, 402653189, 805306457, 0x60000005};

    public int revokedCount() {
        return this.count;
    }

    public ItrusCRL(InputStream in) throws IOException {
        this.init(in);
    }

    public boolean isRevoked(BigInteger bi) {
        return this.findSerialNumber(bi);
    }

    public boolean isRevoked(String serialNumber) {
        return this.isRevoked(DERUtils.HexStringToBigInteger(serialNumber));
    }

    public boolean isRevoked(X509Certificate cert) {
        return this.isRevoked(cert.getSerialNumber());
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public String getIssuerDNString() {
        if (this.issuerDNBytes == null) {
            return null;
        }
        return CertUtils.getX509NameString(this.issuerDNBytes);
    }

    public boolean isOnValidPeriod() {
        Date now = new Date();
        return !now.before(this.thisUpdate) && !now.after(this.nextUpdate);
    }

    private void init(InputStream in) throws IOException {
        int bound = 0;
        int tag = 0;
        int length = 0;
        byte[] b = null;
        int next = 0;
        int revokedCertsSeqLength = 0;
        int revokedCertSeqLength = 0;
        int index = 0;
        int dateTimes = 0;
        int sequenceOrder = 0;
        Stack<Integer> stack = new Stack<Integer>();
        int p = 0;
        int i = 0;
        int conflict = 0;
        boolean isFirstSerialNumber = true;
        this.pos = 0;
        while (this.pos <= next) {
            tag = in.read();
            ++this.pos;
            if (this.pos == 0 && tag != 48) {
                throw new IOException("CRL format error, should be DER binary");
            }
            length = this.readLength(in);
            if (tag == 48) {
                if (++sequenceOrder == 4) {
                    this.issuerDNBytes = new byte[length];
                    in.read(this.issuerDNBytes, 0, length);
                    this.pos += length;
                } else if (sequenceOrder == 5) {
                    revokedCertsSeqLength = length;
                    next = this.pos + length;
                    stack.push(new Integer(next));
                } else if (sequenceOrder == 6) {
                    revokedCertSeqLength = length;
                    next = this.pos + length;
                    stack.push(new Integer(next));
                } else {
                    next = this.pos + length;
                    stack.push(new Integer(next));
                }
            } else if (tag == 49) {
                next = this.pos + length;
                stack.push(new Integer(next));
            } else if (tag == 2) {
                b = new byte[length];
                in.read(b, 0, length);
                this.pos += length;
                if (length == 1 && sequenceOrder == 2) {
                    this.version = b[0];
                } else {
                    int oldCapacity;
                    if (null == this.revokedCertSNs && isFirstSerialNumber) {
                        int nearlyRevokedCount = 0;
                        if (b[0] == 0) {
                            nearlyRevokedCount = revokedCertsSeqLength / (revokedCertSeqLength - 1);
                            this.revokedCertSNs = new byte[(length + 1) * nearlyRevokedCount];
                        } else {
                            nearlyRevokedCount = revokedCertsSeqLength / revokedCertSeqLength;
                            this.revokedCertSNs = new byte[(length + 2) * nearlyRevokedCount];
                        }
                        bound = DERUtils.lower_bound(prime_list, nearlyRevokedCount << 1);
                        this.indexMap = new int[bound];
                        for (i = 0; i < this.indexMap.length; ++i) {
                            this.indexMap[i] = -1;
                        }
                        isFirstSerialNumber = false;
                    }
                    if ((oldCapacity = this.revokedCertSNs.length) < index + length + 1) {
                        byte[] oldData = this.revokedCertSNs;
                        int newCapacity = oldCapacity * 6 / 5;
                        this.revokedCertSNs = new byte[newCapacity];
                        System.arraycopy(oldData, 0, this.revokedCertSNs, 0, oldCapacity);
                    }
                    this.revokedCertSNs[index] = (byte)length;
                    System.arraycopy(b, 0, this.revokedCertSNs, index + 1, length);
                    p = new BigInteger(b).mod(DERUtils.HexStringToBigInteger(Integer.toHexString(bound))).intValue();
                    if (this.indexMap[p] == -1) {
                        this.indexMap[p] = index;
                    } else {
                        for (i = 1; i <= 20; ++i) {
                            ++conflict;
                            if ((p += (i << 0) % bound) >= bound) {
                                p -= bound;
                            }
                            if (this.indexMap[p] == -1) {
                                this.indexMap[p] = index;
                                break;
                            }
                            if (this.isSerialNumberExist(b, this.indexMap[p])) break;
                            if (this.indexMap[p] != -1) continue;
                        }
                    }
                    index += length + 1;
                    ++this.count;
                }
            } else {
                b = new byte[length];
                in.read(b, 0, length);
                this.pos += length;
                if (tag == 23 || tag == 24) {
                    if (dateTimes == 0) {
                        this.thisUpdate = DERUtils.StringToDate(new String(b), tag);
                        ++dateTimes;
                    } else if (dateTimes == 1) {
                        this.nextUpdate = DERUtils.StringToDate(new String(b), tag);
                        ++dateTimes;
                    }
                }
            }
            if (this.pos != next || stack.size() <= 0) continue;
            boolean exit = false;
            do {
                if (stack.size() != 0) continue;
                exit = true;
                break;
            } while (this.pos == (next = ((Integer)stack.pop()).intValue()));
            if (exit) break;
            stack.push(new Integer(next));
        }
        if (this.debug) {
            int arrCount = 0;
            int iaLength = 0;
            if (this.indexMap != null) {
                for (i = 0; i < this.indexMap.length; ++i) {
                    if (this.indexMap[i] == -1) continue;
                    ++arrCount;
                }
                iaLength = this.indexMap.length;
            }
            System.out.println("Array:\u6570\u7ec4\u5927\u5c0f=" + iaLength + ", \u540a\u9500\u8bc1\u4e66=" + this.count + ", \u5360\u7528\u4f4d\u7f6e=" + arrCount + ", \u5c11\u4e86=" + (this.count - arrCount) + ", \u51b2\u7a81\u6b21\u6570=" + conflict);
            if (this.revokedCertSNs != null) {
                System.out.println("\u5e8f\u5217\u53f7\u5b58\u50a8\u7a7a\u95f4=" + this.revokedCertSNs.length);
                int myposition = 0;
                byte mylength = 0;
                mylength = this.revokedCertSNs[myposition];
                while (myposition < this.revokedCertSNs.length && mylength != 0) {
                    byte[] mysn = new byte[mylength];
                    System.arraycopy(this.revokedCertSNs, myposition + 1, mysn, 0, mylength);
                    if ((myposition += mylength + 1) >= this.revokedCertSNs.length) break;
                    mylength = this.revokedCertSNs[myposition];
                }
            }
        }
    }

    private boolean isSerialNumberExist(byte[] sn, int index) {
        int mylength = this.revokedCertSNs[index];
        if (mylength != sn.length) {
            return false;
        }
        byte[] mysn = new byte[mylength];
        System.arraycopy(this.revokedCertSNs, index + 1, mysn, 0, mylength);
        while (mylength-- != 0) {
            if (sn[mylength] == mysn[mylength]) continue;
            return false;
        }
        return true;
    }

    private int readLength(InputStream is) throws IOException {
        int length = is.read();
        ++this.pos;
        if (length < 0) {
            throw new IOException("EOF found when length expected");
        }
        if (length == 128) {
            return -1;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IOException("DER length more than 4 bytes");
            }
            length = 0;
            for (int i = 0; i < size; ++i) {
                int next = is.read();
                ++this.pos;
                if (next < 0) {
                    throw new IOException("EOF found reading length");
                }
                length = (length << 8) + next;
            }
            if (length < 0) {
                throw new IOException("corrupted steam - negative length found");
            }
        }
        return length;
    }

    private boolean findSerialNumber(BigInteger bi) {
        if (this.indexMap == null) {
            return false;
        }
        int bound = this.indexMap.length;
        byte[] b = bi.toByteArray();
        bound = this.indexMap.length;
        int p = bi.mod(DERUtils.HexStringToBigInteger(Integer.toHexString(bound))).intValue();
        boolean find = false;
        int i = 0;
        if (this.indexMap[p] == -1) {
            find = false;
        } else if (this.isSerialNumberExist(b, this.indexMap[p])) {
            find = true;
        } else {
            i = 1;
            while (true) {
                if (i > 20) {
                    find = false;
                    break;
                }
                if ((p += (i << 0) % bound) >= bound) {
                    p -= bound;
                }
                if (this.indexMap[p] == -1) {
                    find = false;
                    break;
                }
                if (this.isSerialNumberExist(b, this.indexMap[p])) {
                    find = true;
                    break;
                }
                ++i;
            }
        }
        return find;
    }

    public int getVersion() {
        return this.version + 1;
    }
}

