/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cms.jcajce;

import cn.tca.TopBasicCrypto.asn1.ASN1ObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DERObjectIdentifier;
import cn.tca.TopBasicCrypto.asn1.DEROctetString;
import cn.tca.TopBasicCrypto.asn1.cms.IssuerAndSerialNumber;
import cn.tca.TopBasicCrypto.asn1.cms.SignerIdentifier;
import cn.tca.TopBasicCrypto.asn1.cms.SignerInfo;
import cn.tca.TopBasicCrypto.asn1.x500.X500Name;
import cn.tca.TopBasicCrypto.asn1.x509.AlgorithmIdentifier;
import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.SignerInfoGenerator;
import cn.tca.TopBasicCrypto.operator.OperatorCreationException;
import cn.topca.security.x509.AlgorithmId;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;

public class RsaSignerInfoGenerator
extends SignerInfoGenerator {
    private ByteArrayOutputStream _stream = null;
    private PrivateKey _key = null;
    private X509Certificate _cert = null;
    private AlgorithmIdentifier digestAlgId = null;
    private AlgorithmIdentifier signatureAlgId = null;

    public RsaSignerInfoGenerator(PrivateKey key, X509Certificate cert) throws OperatorCreationException {
        super(null, null, null, true);
        if (key == null || cert == null) {
            throw new OperatorCreationException("key and cert can not be null");
        }
        this._stream = new ByteArrayOutputStream();
        this._key = key;
        this._cert = cert;
        this.digestAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(AlgorithmId.SHA_oid.toString()));
        this.signatureAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(AlgorithmId.RSAEncryption_oid.toString()));
    }

    @Override
    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgId;
    }

    @Override
    public OutputStream getCalculatingOutputStream() {
        return this._stream;
    }

    @Override
    public SignerInfo generate(ASN1ObjectIdentifier asn1objectidentifier) throws CMSException {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(this._key);
            signature.update(this._stream.toByteArray());
            byte[] abyte0 = signature.sign();
            X500Name issuer = new X500Name(this._cert.getIssuerDN().toString());
            BigInteger serialNumber = this._cert.getSerialNumber();
            IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(issuer, serialNumber);
            return new SignerInfo(new SignerIdentifier(issuerAndSerialNumber), this.digestAlgId, null, this.signatureAlgId, new DEROctetString(abyte0), null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("No Such Algorithm SHA1withRSA", e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("Invalid Key", e);
        }
        catch (SignatureException e) {
            throw new CMSException("Calculate signature failed", e);
        }
    }
}

