/*
 * Decompiled with CFR 0.152.
 */
package com.itrus.cryptorole.bc;

import cn.tca.TopBasicCrypto.cms.CMSException;
import cn.tca.TopBasicCrypto.cms.CMSProcessable;
import cn.tca.TopBasicCrypto.cms.CMSProcessableByteArray;
import cn.tca.TopBasicCrypto.cms.CMSSignedData;
import cn.tca.TopBasicCrypto.cms.SignerInformation;
import cn.tca.TopBasicCrypto.cms.SignerInformationStore;
import cn.tca.TopBasicCrypto.jce.provider.BouncyCastleProvider;
import cn.tca.TopBasicCrypto.util.encoders.Base64;
import cn.topca.security.sm.SM2PrivateKey;
import cn.topca.security.sm.TopSMProvider;
import cn.topca.security.x509.AlgorithmId;
import com.itrus.asn1.cms.CMSEnvelopedDataEx;
import com.itrus.cert.X509Certificate;
import com.itrus.cms.CMSEnvelopedAsymmetricDecryptor;
import com.itrus.cms.jcajce.CMSEnvelopedRSADecryptor;
import com.itrus.cms.jcajce.CMSEnvelopedSM2Decryptor;
import com.itrus.cryptorole.CryptoException;
import com.itrus.cryptorole.NotSupportException;
import com.itrus.cryptorole.Recipient;
import com.itrus.cryptorole.Sender;
import com.itrus.cryptorole.SignatureVerifyException;
import com.itrus.cryptorole.bc.SenderBcImpl;
import com.itrus.svm.SVM;
import com.itrus.svm.SignerAndEncryptedDigest;
import com.itrus.util.FileUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class RecipientBcImpl
extends Recipient {
    private static String PROVIDER = "BC";
    private static String PROVIDER_TOPSM = "TopSM";

    @Override
    public void initCertWithKey(String keyStoreFileName, char[] keyStorePassword, String keyAlias, char[] keyPassword) throws NotSupportException, CryptoException {
        try {
            FileInputStream fis = new FileInputStream(keyStoreFileName);
            KeyStore keystore = KeyStore.getInstance("JKS");
            keystore.load(fis, keyStorePassword);
            fis.close();
            this.keyOfDecryptor = (PrivateKey)keystore.getKey(keyAlias, keyPassword);
            this.certOfDecryptor = (java.security.cert.X509Certificate)keystore.getCertificate(keyAlias);
        }
        catch (FileNotFoundException e) {
            throw new CryptoException(e);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public void initCertWithKey(String pfxFileName, char[] keyPassword) throws NotSupportException, CryptoException {
        try {
            FileInputStream fis = new FileInputStream(pfxFileName);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(fis, keyPassword);
            fis.close();
            Enumeration<String> enums = keyStore.aliases();
            while (enums.hasMoreElements()) {
                String keyAlias = enums.nextElement();
                if (!keyStore.isKeyEntry(keyAlias)) continue;
                this.keyOfDecryptor = (PrivateKey)keyStore.getKey(keyAlias, keyPassword);
                this.certOfDecryptor = (java.security.cert.X509Certificate)keyStore.getCertificate(keyAlias);
            }
        }
        catch (FileNotFoundException e) {
            throw new CryptoException(e);
        }
        catch (KeyStoreException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public boolean doVerify(byte[] originalMessage, byte[] encryptedDigest, java.security.cert.X509Certificate signer, String signAlgorithm) throws CryptoException {
        if (signAlgorithm == null) {
            signAlgorithm = "EC".equalsIgnoreCase(signer.getPublicKey().getAlgorithm()) || "SM2".equalsIgnoreCase(signer.getPublicKey().getAlgorithm()) ? "SM3withSM2" : this.signAlgorithm;
        }
        try {
            Signature signature = Signature.getInstance(signAlgorithm);
            signature.initVerify(signer);
            signature.update(originalMessage);
            return signature.verify(encryptedDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        catch (SignatureException e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public java.security.cert.X509Certificate verifySignature(byte[] originalMessage, byte[] signedData) throws CryptoException, SignatureVerifyException {
        return this.verifyAndParsePkcs7(originalMessage, signedData).getSigner();
    }

    public java.security.cert.X509Certificate verifySignature(String originalMessage, String signedData) throws CryptoException, SignatureVerifyException {
        return SVM.verifySignature(originalMessage, signedData);
    }

    @Override
    public java.security.cert.X509Certificate verifySignatureIncludeOriginal(byte[] signedDataIncludeOriginal) throws NotSupportException, CryptoException, SignatureVerifyException {
        SignerAndEncryptedDigest signerAndEncryptedDigest = SVM.verifyAndParsePkcs7(null, signedDataIncludeOriginal);
        return signerAndEncryptedDigest.getSigner();
    }

    public SignerAndEncryptedDigest verifyAndParsePkcs7(byte[] oriData, byte[] pkcs7) throws SignatureVerifyException, CryptoException {
        try {
            SignerAndEncryptedDigest signerAndEncryptedDigest = new SignerAndEncryptedDigest();
            java.security.cert.X509Certificate cert = null;
            if (oriData == null) {
                cert = this.verdifyIncludeOriginal(pkcs7);
                signerAndEncryptedDigest.setSigner(X509Certificate.getInstance(cert));
            } else {
                cert = this.verifyPkcs7Detached(oriData, pkcs7);
                signerAndEncryptedDigest.setSigner(X509Certificate.getInstance(cert));
            }
            return signerAndEncryptedDigest;
        }
        catch (CertificateEncodingException e) {
            throw new CryptoException(e);
        }
        catch (CertificateException e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public byte[] decryptMessage(byte[] encryptedData) throws CryptoException {
        if (this.keyOfDecryptor == null || this.certOfDecryptor == null) {
            throw new CryptoException(this.notInitializeKeyMessage);
        }
        try {
            CMSEnvelopedDataEx enveloped = new CMSEnvelopedDataEx(encryptedData);
            String publicKeyAlgorithm = this.certOfDecryptor.getPublicKey().getAlgorithm();
            if (AlgorithmId.SM2_oid.toString().equals(publicKeyAlgorithm)) {
                publicKeyAlgorithm = "SM2";
            }
            CMSEnvelopedAsymmetricDecryptor decryptor = "SM2".equalsIgnoreCase(publicKeyAlgorithm) ? new CMSEnvelopedSM2Decryptor(this.certOfDecryptor, (SM2PrivateKey)this.keyOfDecryptor) : new CMSEnvelopedRSADecryptor(this.certOfDecryptor, (RSAPrivateKey)this.keyOfDecryptor);
            return enveloped.getContent(decryptor);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    @Override
    public void decryptFile(String encryptedFileName, String destinationFileName) throws CryptoException, IOException {
        byte[] encryptedMessage = FileUtils.readBytesFromFile(encryptedFileName);
        byte[] originalMessage = this.decryptMessage(encryptedMessage);
        FileUtils.saveBytesToFile(originalMessage, destinationFileName);
    }

    @Override
    public void decryptFileEx(String encryptedFileName, String destinationFileName) throws CryptoException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(encryptedFileName);
            out = new FileOutputStream(destinationFileName);
            int i = 0;
            byte[] c = new byte[1];
            byte[] p7B64KeyAndIV = new byte[10240];
            while (((InputStream)in).read(c, 0, 1) != -1) {
                String s = new String(c);
                if (s.compareToIgnoreCase("|") != 0) {
                    p7B64KeyAndIV[i++] = c[0];
                    continue;
                }
                p7B64KeyAndIV[i] = 0;
                break;
            }
            byte[] p7 = Base64.decode(new String(p7B64KeyAndIV, 0, i));
            byte[] bB64KeyAndIV = this.decryptMessage(p7);
            byte[] szB64KeyAndIV = Base64.decode(new String(bB64KeyAndIV));
            byte[] szB64Key = null;
            byte[] szB64IV = null;
            String temp = new String(szB64KeyAndIV);
            int index = temp.indexOf("|");
            String temp2 = temp.substring(0, index);
            String temp3 = temp.substring(index + 1);
            szB64Key = temp2.getBytes();
            szB64IV = temp3.getBytes();
            byte[] bkey = Base64.decode(new String(szB64Key));
            byte[] biv = Base64.decode(new String(szB64IV));
            DESedeKeySpec dks = new DESedeKeySpec(bkey);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey key = keyFactory.generateSecret(dks);
            IvParameterSpec iv = new IvParameterSpec(biv, 0, 8);
            Cipher c1 = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            c1.init(2, (Key)key, iv, null);
            byte[] buff = new byte[10240];
            int size = 0;
            byte[] buff2 = null;
            while ((size = ((InputStream)in).read(buff)) != -1) {
                buff2 = c1.update(buff, 0, size);
                out.write(buff2);
            }
            buff2 = c1.doFinal();
            out.write(buff2);
        }
        catch (FileNotFoundException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoException(e);
        }
        catch (IllegalStateException e) {
            throw new CryptoException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoException(e);
        }
        catch (BadPaddingException e) {
            throw new CryptoException(e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
        }
    }

    public void decryptFileWithHeader(String header, String encryptedFileName, String destinationFileName) throws CryptoException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            boolean readOK = false;
            in = new FileInputStream(encryptedFileName);
            out = new FileOutputStream(destinationFileName);
            byte[] c = new byte[1];
            while (((InputStream)in).read(c, 0, 1) != -1) {
                String s = new String(c);
                if (s.compareToIgnoreCase("|") != 0) continue;
                readOK = true;
                break;
            }
            if (!readOK) {
                throw new CryptoException("Read Encrypted File Header failed.");
            }
            byte[] bB64KeyAndIV = header.getBytes();
            byte[] szB64KeyAndIV = Base64.decode(new String(bB64KeyAndIV));
            byte[] szB64Key = null;
            byte[] szB64IV = null;
            String temp = new String(szB64KeyAndIV);
            int index = temp.indexOf("|");
            String temp2 = temp.substring(0, index);
            String temp3 = temp.substring(index + 1);
            szB64Key = temp2.getBytes();
            szB64IV = temp3.getBytes();
            byte[] bkey = Base64.decode(new String(szB64Key));
            byte[] biv = Base64.decode(new String(szB64IV));
            DESedeKeySpec dks = new DESedeKeySpec(bkey);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey key = keyFactory.generateSecret(dks);
            IvParameterSpec iv = new IvParameterSpec(biv, 0, 8);
            Cipher c1 = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            c1.init(2, (Key)key, iv, null);
            byte[] buff = new byte[10240];
            int size = 0;
            byte[] buff2 = null;
            while ((size = ((InputStream)in).read(buff)) != -1) {
                buff2 = c1.update(buff, 0, size);
                out.write(buff2);
            }
            buff2 = c1.doFinal();
            out.write(buff2);
        }
        catch (FileNotFoundException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoException(e);
        }
        catch (IllegalStateException e) {
            throw new CryptoException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoException(e);
        }
        catch (BadPaddingException e) {
            throw new CryptoException(e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
        }
    }

    public static void decryptFileWithSymmetricKey(String symmetricKey, String encryptedFileName, String destinationFileName) throws CryptoException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(encryptedFileName);
            out = new FileOutputStream(destinationFileName);
            byte[] bB64KeyAndIV = symmetricKey.getBytes();
            byte[] szB64KeyAndIV = Base64.decode(new String(bB64KeyAndIV));
            byte[] szB64Key = null;
            byte[] szB64IV = null;
            String temp = new String(szB64KeyAndIV);
            int index = temp.indexOf("|");
            String temp2 = temp.substring(0, index);
            String temp3 = temp.substring(index + 1);
            szB64Key = temp2.getBytes();
            szB64IV = temp3.getBytes();
            byte[] bkey = Base64.decode(new String(szB64Key));
            byte[] biv = Base64.decode(new String(szB64IV));
            DESedeKeySpec dks = new DESedeKeySpec(bkey);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey key = keyFactory.generateSecret(dks);
            IvParameterSpec iv = new IvParameterSpec(biv, 0, 8);
            Cipher c1 = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            c1.init(2, (Key)key, iv, null);
            byte[] buff = new byte[10240];
            int size = 0;
            byte[] buff2 = null;
            while ((size = ((InputStream)in).read(buff)) != -1) {
                buff2 = c1.update(buff, 0, size);
                out.write(buff2);
            }
            buff2 = c1.doFinal();
            out.write(buff2);
        }
        catch (FileNotFoundException e) {
            throw new CryptoException(e);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoException(e);
        }
        catch (IllegalStateException e) {
            throw new CryptoException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoException(e);
        }
        catch (BadPaddingException e) {
            throw new CryptoException(e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new CryptoException(e);
                }
            }
        }
    }

    public java.security.cert.X509Certificate verdifyIncludeOriginal(byte[] signdata) throws SignatureVerifyException, CryptoException {
        try {
            CMSSignedData sign = new CMSSignedData(signdata);
            CertStore certs = sign.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signers = sign.getSignerInfos();
            Collection c = signers.getSigners();
            for (SignerInformation signer : c) {
                Collection<? extends Certificate> certCollection;
                Iterator<? extends Certificate> certIt;
                java.security.cert.X509Certificate cert;
                boolean flag = signer.verify((cert = (java.security.cert.X509Certificate)(certIt = (certCollection = certs.getCertificates(signer.getSID())).iterator()).next()).getPublicKey(), "BC");
                if (flag) {
                    return cert;
                }
                if (flag) continue;
                SignatureVerifyException e = new SignatureVerifyException("Signature verify failed, plaintext may be falsified. Signer is [" + cert.getSubjectDN().getName() + "]");
                e.setSigner(cert);
                throw e;
            }
        }
        catch (CMSException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        catch (CertStoreException e) {
            throw new CryptoException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CryptoException(e);
        }
        return null;
    }

    private java.security.cert.X509Certificate verifyPkcs7Detached(byte[] originalMessage, byte[] pkcs7) throws CryptoException, SignatureVerifyException {
        try {
            CMSProcessableByteArray cmsProcessable = new CMSProcessableByteArray(originalMessage);
            CMSSignedData cmsSignedData = new CMSSignedData((CMSProcessable)cmsProcessable, pkcs7);
            CertStore certs = cmsSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signers = cmsSignedData.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            if (it.hasNext()) {
                Collection<? extends Certificate> certCollection;
                Iterator<? extends Certificate> certIt;
                java.security.cert.X509Certificate cert;
                SignerInformation signer = (SignerInformation)it.next();
                if (signer.verify((cert = (java.security.cert.X509Certificate)(certIt = (certCollection = certs.getCertificates(signer.getSID())).iterator()).next()).getPublicKey(), "BC")) {
                    return cert;
                }
                SignatureVerifyException e = new SignatureVerifyException("Signature verify failed, plaintext may be falsified. Signer is [" + cert.getSubjectDN().getName() + "]");
                e.setSigner(cert);
                throw e;
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        String rsa = "D:/test/test01.pfx";
        String sm2 = "D:/test/server(SM2).pfx";
        char[] password = "password".toCharArray();
        byte[] plainText = "test".getBytes();
        SenderBcImpl sender = new SenderBcImpl();
        ((Sender)sender).initCertWithKey(sm2, password);
        sender.addRecipientCert(sender.getSignerCert());
        byte[] encry = ((Sender)sender).encryptMessage(plainText);
        System.out.println(new String(Base64.encode(encry)));
        RecipientBcImpl rbi = new RecipientBcImpl();
        byte[] bb = ((Recipient)rbi).decryptMessage(encry);
        System.out.println(new String(bb));
    }

    static {
        if (Security.getProvider(PROVIDER) == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
        if (Security.getProperty(PROVIDER_TOPSM) == null) {
            Security.addProvider(new TopSMProvider());
        }
    }
}

